/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.JavaLineMarkerProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import java.util.Collection;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

public class GroovyLineMarkerProvider
extends JavaLineMarkerProvider {
    public GroovyLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        super(daemonSettings, colorsManager);
    }

    public LineMarkerInfo getLineMarkerInfo(PsiElement element) {
        ASTNode node;
        PsiElement parent = element.getParent();
        if (parent instanceof PsiNameIdentifierOwner && (node = element.getNode()) != null && TokenSets.PROPERTY_NAMES.contains(node.getElementType())) {
            return super.getLineMarkerInfo(((PsiNameIdentifierOwner)parent).getNameIdentifier());
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS && element.getFirstChild() == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!((element1 = element1.getParent()) instanceof PsiMember)) continue;
                isMember = true;
                break;
            }
            if (isMember && !(element1 instanceof PsiAnonymousClass) && !(element1.getParent() instanceof PsiAnonymousClass)) {
                boolean drawSeparator = false;
                int category = GroovyLineMarkerProvider.getCategory((PsiElement)element1);
                for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                    int category1 = GroovyLineMarkerProvider.getCategory((PsiElement)child);
                    if (category1 == 0) continue;
                    drawSeparator = category != 1 || category1 != 1;
                    break;
                }
                if (drawSeparator) {
                    GrDocComment comment = null;
                    if (element1 instanceof GrDocCommentOwner) {
                        comment = ((GrDocCommentOwner)element1).getDocComment();
                    }
                    LineMarkerInfo info = new LineMarkerInfo(element, comment != null ? comment.getTextRange() : element.getTextRange(), null, 4, (Function)NullableFunction.NULL, null, GutterIconRenderer.Alignment.RIGHT);
                    EditorColorsScheme scheme = this.myColorsManager.getGlobalScheme();
                    info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        return super.getLineMarkerInfo(element);
    }

    public void collectSlowLineMarkers(List<PsiElement> elements, Collection<LineMarkerInfo> result) {
        super.collectSlowLineMarkers(elements, result);
    }
}

