/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.ForLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceForLoopWithWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ForLoopPredicate forLoopPredicate = new ForLoopPredicate();
        if (forLoopPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/forloop/ReplaceForLoopWithWhileLoopIntention.getElementPredicate must not return null");
        }
        return forLoopPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiCodeBlock newBody;
        PsiBlockStatement blockStatement;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/forloop/ReplaceForLoopWithWhileLoopIntention.processIntention must not be null");
        }
        PsiForStatement forStatement = (PsiForStatement)element.getParent();
        if (forStatement == null) {
            return;
        }
        PsiStatement initialization = forStatement.getInitialization();
        if (initialization != null && !(initialization instanceof PsiEmptyStatement)) {
            PsiElement parent = forStatement.getParent();
            parent.addBefore((PsiElement)initialization, (PsiElement)forStatement);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiWhileStatement whileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", element);
        PsiExpression forCondition = forStatement.getCondition();
        PsiExpression whileCondition = whileStatement.getCondition();
        PsiStatement body = forStatement.getBody();
        if (forCondition != null) {
            assert (whileCondition != null);
            whileCondition.replace((PsiElement)forCondition);
        }
        if ((blockStatement = (PsiBlockStatement)whileStatement.getBody()) == null) {
            return;
        }
        if (body instanceof PsiBlockStatement) {
            PsiBlockStatement newWhileBody = (PsiBlockStatement)blockStatement.replace((PsiElement)body);
            newBody = newWhileBody.getCodeBlock();
        } else {
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            if (body != null && !(body instanceof PsiEmptyStatement)) {
                codeBlock.addAfter((PsiElement)body, codeBlock.getFirstChild());
            }
            newBody = codeBlock;
        }
        PsiStatement update = forStatement.getUpdate();
        if (update != null) {
            if (update instanceof PsiExpressionListStatement) {
                PsiExpression[] expressions;
                PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)update;
                PsiExpressionList expressionList = expressionListStatement.getExpressionList();
                for (PsiExpression expression : expressions = expressionList.getExpressions()) {
                    PsiStatement updateStatement = factory.createStatementFromText(expression.getText() + ';', element);
                    newBody.addBefore((PsiElement)updateStatement, newBody.getLastChild());
                }
            } else {
                PsiStatement updateStatement = factory.createStatementFromText(update.getText() + ';', element);
                newBody.addBefore((PsiElement)updateStatement, newBody.getLastChild());
            }
        }
        forStatement.replace((PsiElement)whileStatement);
    }
}

