/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.CharacterIterator;

public class Segment
implements Cloneable,
CharacterIterator {
    private boolean partialReturn;
    private int current;
    public char[] array;
    public int count;
    public int offset;

    public Segment() {
    }

    public Segment(char[] cArray, int n, int n2) {
        this.array = cArray;
        this.offset = n;
        this.count = n2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public char current() {
        if (this.count == 0 || this.current >= this.getEndIndex()) {
            return '\uffff';
        }
        return this.array[this.current];
    }

    public char first() {
        if (this.count == 0) {
            return '\uffff';
        }
        this.current = this.getBeginIndex();
        return this.array[this.current];
    }

    public int getBeginIndex() {
        return this.offset;
    }

    public int getEndIndex() {
        return this.offset + this.count;
    }

    public int getIndex() {
        return this.current;
    }

    public char last() {
        if (this.count == 0) {
            this.current = this.getEndIndex();
            return '\uffff';
        }
        this.current = this.getEndIndex() - 1;
        return this.array[this.current];
    }

    public char next() {
        if (this.count == 0) {
            return '\uffff';
        }
        if (this.current + 1 >= this.getEndIndex()) {
            this.current = this.getEndIndex();
            return '\uffff';
        }
        ++this.current;
        return this.array[this.current];
    }

    public char previous() {
        if (this.count == 0 || this.current == this.getBeginIndex()) {
            return '\uffff';
        }
        --this.current;
        return this.array[this.current];
    }

    public char setIndex(int n) {
        if (n < this.getBeginIndex() || n > this.getEndIndex()) {
            throw new IllegalArgumentException("position: " + n + ", beginIndex: " + this.getBeginIndex() + ", endIndex: " + this.getEndIndex() + ", text: " + this.toString());
        }
        this.current = n;
        if (n == this.getEndIndex()) {
            return '\uffff';
        }
        return this.array[this.current];
    }

    public String toString() {
        if (this.array != null) {
            return new String(this.array, this.offset, this.count);
        }
        return "";
    }

    public void setPartialReturn(boolean bl) {
        this.partialReturn = bl;
    }

    public boolean isPartialReturn() {
        return this.partialReturn;
    }
}

