/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    static int SCROLL_NON_SCROLLABLES = 10;
    static int ROWS_PER_WHEEL_CLICK = 3;
    protected JScrollPane scrollpane;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    MouseWheelListener mouseWheelListener;
    ContainerListener containerListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollPaneUI();
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        this.scrollpane = jScrollPane;
        LookAndFeel.installColorsAndFont(jScrollPane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        LookAndFeel.installBorder(jScrollPane, "ScrollPane.border");
        jScrollPane.setOpaque(true);
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        jScrollPane.setForeground(null);
        jScrollPane.setBackground(null);
        jScrollPane.setFont(null);
        jScrollPane.setBorder(null);
        this.scrollpane = null;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installDefaults((JScrollPane)jComponent);
        this.installListeners((JScrollPane)jComponent);
        this.installKeyboardActions((JScrollPane)jComponent);
    }

    protected void installListeners(JScrollPane jScrollPane) {
        if (this.spPropertyChangeListener == null) {
            this.spPropertyChangeListener = this.createPropertyChangeListener();
        }
        jScrollPane.addPropertyChangeListener(this.spPropertyChangeListener);
        if (this.hsbChangeListener == null) {
            this.hsbChangeListener = this.createHSBChangeListener();
        }
        jScrollPane.getHorizontalScrollBar().getModel().addChangeListener(this.hsbChangeListener);
        if (this.vsbChangeListener == null) {
            this.vsbChangeListener = this.createVSBChangeListener();
        }
        jScrollPane.getVerticalScrollBar().getModel().addChangeListener(this.vsbChangeListener);
        if (this.viewportChangeListener == null) {
            this.viewportChangeListener = this.createViewportChangeListener();
        }
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = this.createMouseWheelListener();
        }
        if (this.containerListener == null) {
            this.containerListener = new ViewportContainerListener(this);
        }
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.addChangeListener(this.viewportChangeListener);
        jViewport.addContainerListener(this.containerListener);
        for (int i = 0; i < jViewport.getComponentCount(); ++i) {
            jViewport.getComponent(i).addMouseWheelListener(this.mouseWheelListener);
        }
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("ScrollPane.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("ScrollPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("ScrollPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("scrollLeft", new AbstractAction(this, "scrollLeft"){
            private /* synthetic */ BasicScrollPaneUI this$0;
            {
                this.this$0 = basicScrollPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("scrollEnd", new AbstractAction(this, "scrollEnd"){
            private /* synthetic */ BasicScrollPaneUI this$0;
            {
                this.this$0 = basicScrollPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar;
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar2 = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar2.isVisible()) {
                    jScrollBar2.setValue(jScrollBar2.getMaximum());
                }
                if ((jScrollBar = jScrollPane.getVerticalScrollBar()).isVisible()) {
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            }
        });
        actionMapUIResource.put("unitScrollUp", new AbstractAction(this, "unitScrollUp"){
            private /* synthetic */ BasicScrollPaneUI this$0;
            {
                this.this$0 = basicScrollPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("unitScrollLeft", new AbstractAction(this, "unitScrollLeft"){
            private /* synthetic */ BasicScrollPaneUI this$0;
            {
                this.this$0 = basicScrollPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("scrollUp", new AbstractAction(this, "scrollUp"){
            private /* synthetic */ BasicScrollPaneUI this$0;
            {
                this.this$0 = basicScrollPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(-1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("scrollRight", new AbstractAction(this, "scrollRight"){
            private /* synthetic */ BasicScrollPaneUI this$0;
            {
                this.this$0 = basicScrollPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("scrollHome", new AbstractAction(this, "scrollHome"){
            private /* synthetic */ BasicScrollPaneUI this$0;
            {
                this.this$0 = basicScrollPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar;
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar2 = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar2.isVisible()) {
                    jScrollBar2.setValue(jScrollBar2.getMinimum());
                }
                if ((jScrollBar = jScrollPane.getVerticalScrollBar()).isVisible()) {
                    jScrollBar.setValue(jScrollBar.getMinimum());
                }
            }
        });
        actionMapUIResource.put("scrollDown", new AbstractAction(this, "scrollDown"){
            private /* synthetic */ BasicScrollPaneUI this$0;
            {
                this.this$0 = basicScrollPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getBlockIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("unitScrollDown", new AbstractAction(this, "unitScrollDown"){
            private /* synthetic */ BasicScrollPaneUI this$0;
            {
                this.this$0 = basicScrollPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        actionMapUIResource.put("unitScrollRight", new AbstractAction(this, "unitScrollRight"){
            private /* synthetic */ BasicScrollPaneUI this$0;
            {
                this.this$0 = basicScrollPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                if (jScrollBar.isVisible()) {
                    int n = jScrollBar.getUnitIncrement(1);
                    jScrollBar.setValue(jScrollBar.getValue() + n);
                }
            }
        });
        return actionMapUIResource;
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jScrollPane, actionMap);
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
        SwingUtilities.replaceUIActionMap(jScrollPane, null);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, null);
    }

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener(this);
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener(this);
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler(this);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallDefaults((JScrollPane)jComponent);
        this.uninstallListeners((JScrollPane)jComponent);
        this.installKeyboardActions((JScrollPane)jComponent);
    }

    protected void uninstallListeners(JComponent jComponent) {
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        jScrollPane.removePropertyChangeListener(this.spPropertyChangeListener);
        jScrollPane.getHorizontalScrollBar().getModel().removeChangeListener(this.hsbChangeListener);
        jScrollPane.getVerticalScrollBar().getModel().removeChangeListener(this.vsbChangeListener);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.removeChangeListener(this.viewportChangeListener);
        jViewport.removeContainerListener(this.containerListener);
        for (int i = 0; i < jViewport.getComponentCount(); ++i) {
            jViewport.getComponent(i).removeMouseWheelListener(this.mouseWheelListener);
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        ScrollPaneLayout scrollPaneLayout = (ScrollPaneLayout)jScrollPane.getLayout();
        return scrollPaneLayout.minimumLayoutSize(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getHorizontalScrollBar();
        jScrollBar.setMaximum(jViewport.getViewSize().width);
        jScrollBar.setValue(jViewport.getViewPosition().x);
        jScrollBar.setVisibleAmount(jViewport.getExtentSize().width);
        JScrollBar jScrollBar2 = this.scrollpane.getVerticalScrollBar();
        jScrollBar2.setMaximum(jViewport.getViewSize().height);
        jScrollBar2.setValue(jViewport.getViewPosition().y);
        jScrollBar2.setVisibleAmount(jViewport.getExtentSize().height);
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        jViewport.removeChangeListener(this.viewportChangeListener);
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        jViewport2.addChangeListener(this.viewportChangeListener);
        this.syncScrollPaneWithViewport();
    }

    class ViewportContainerListener
    implements ContainerListener {
        private /* synthetic */ BasicScrollPaneUI this$0;

        public void componentAdded(ContainerEvent containerEvent) {
            containerEvent.getChild().addMouseWheelListener(this.this$0.mouseWheelListener);
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            containerEvent.getChild().removeMouseWheelListener(this.this$0.mouseWheelListener);
        }

        ViewportContainerListener(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        private /* synthetic */ BasicScrollPaneUI this$0;
        final Rectangle rect;

        private /* synthetic */ void finit$() {
            this.rect = new Rectangle();
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (this.this$0.scrollpane.getViewport().getComponentCount() == 0) {
                return;
            }
            Component component = this.this$0.scrollpane.getViewport().getComponent(0);
            JScrollBar jScrollBar = this.this$0.scrollpane.getVerticalScrollBar();
            Scrollable scrollable = component instanceof Scrollable ? (Scrollable)((Object)component) : null;
            boolean bl = scrollable != null && scrollable.getScrollableTracksViewportHeight();
            int n = mouseWheelEvent.getWheelRotation() * ROWS_PER_WHEEL_CLICK;
            if (jScrollBar != null && !bl) {
                int n2;
                if (scrollable != null) {
                    this.bounds(component);
                    n2 = scrollable.getScrollableUnitIncrement(this.rect, 1, n);
                } else {
                    n2 = n * SCROLL_NON_SCROLLABLES;
                }
                this.scroll(jScrollBar, n2);
            } else {
                boolean bl2;
                jScrollBar = this.this$0.scrollpane.getHorizontalScrollBar();
                boolean bl3 = bl2 = scrollable != null && scrollable.getScrollableTracksViewportWidth();
                if (jScrollBar != null && !bl2) {
                    int n3;
                    if (scrollable != null) {
                        this.bounds(component);
                        n3 = scrollable.getScrollableUnitIncrement(this.rect, 0, n);
                    } else {
                        n3 = n * SCROLL_NON_SCROLLABLES;
                    }
                    this.scroll(jScrollBar, n3);
                }
            }
        }

        final void bounds(Component component) {
            component.getParent().getBounds(this.rect);
            this.rect.x = this.getValue(this.this$0.scrollpane.getHorizontalScrollBar());
            this.rect.y = this.getValue(this.this$0.scrollpane.getVerticalScrollBar());
        }

        final int getValue(JScrollBar jScrollBar) {
            if (jScrollBar != null) {
                return jScrollBar.getValue();
            }
            return 0;
        }

        final void scroll(JScrollBar jScrollBar, int n) {
            int n2 = jScrollBar.getValue() + n;
            if (n2 < jScrollBar.getMinimum()) {
                n2 = jScrollBar.getMinimum();
            }
            if (n2 > jScrollBar.getMaximum()) {
                n2 = jScrollBar.getMaximum();
            }
            jScrollBar.setValue(n2);
        }

        protected MouseWheelHandler(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
            this.finit$();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicScrollPaneUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("viewport")) {
                this.this$0.updateViewport(propertyChangeEvent);
            } else if (string.equals("rowHeader")) {
                this.this$0.updateRowHeader(propertyChangeEvent);
            } else if (string.equals("columnHeader")) {
                this.this$0.updateColumnHeader(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBarPolicy") || propertyChangeEvent.getPropertyName().equals("verticalScrollBarPolicy")) {
                this.this$0.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("verticalScrollBar")) {
                JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
                jScrollBar.getModel().removeChangeListener(this.this$0.vsbChangeListener);
                JScrollBar jScrollBar2 = (JScrollBar)propertyChangeEvent.getNewValue();
                jScrollBar2.getModel().addChangeListener(this.this$0.vsbChangeListener);
            } else if (string.equals("horizontalScrollBar")) {
                JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
                jScrollBar.getModel().removeChangeListener(this.this$0.hsbChangeListener);
                JScrollBar jScrollBar3 = (JScrollBar)propertyChangeEvent.getNewValue();
                jScrollBar3.getModel().addChangeListener(this.this$0.hsbChangeListener);
            }
        }

        public PropertyChangeHandler(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        private /* synthetic */ BasicScrollPaneUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = this.this$0.scrollpane.getViewport();
            JScrollBar jScrollBar = this.this$0.scrollpane.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.this$0.scrollpane.getVerticalScrollBar();
            this.this$0.syncScrollPaneWithViewport();
        }

        public ViewportChangeHandler(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        private /* synthetic */ BasicScrollPaneUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            JScrollBar jScrollBar = this.this$0.scrollpane.getVerticalScrollBar();
            JViewport jViewport = this.this$0.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            int n = jScrollBar.getValue();
            if (n != point.y) {
                point.y = n;
                jViewport.setViewPosition(point);
            }
            point.x = 0;
            JViewport jViewport2 = this.this$0.scrollpane.getRowHeader();
            if (jViewport2 != null && !jViewport2.getViewPosition().equals(point)) {
                jViewport2.setViewPosition(point);
            }
        }

        public VSBChangeListener(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        private /* synthetic */ BasicScrollPaneUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            JScrollBar jScrollBar = this.this$0.scrollpane.getHorizontalScrollBar();
            JViewport jViewport = this.this$0.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            int n = jScrollBar.getValue();
            if (n != point.x) {
                point.x = n;
                jViewport.setViewPosition(point);
            }
            point.y = 0;
            JViewport jViewport2 = this.this$0.scrollpane.getColumnHeader();
            if (jViewport2 != null && !jViewport2.getViewPosition().equals(point)) {
                jViewport2.setViewPosition(point);
            }
        }

        public HSBChangeListener(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
        }
    }
}

