/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.SizeRequirements;

public class OverlayLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 18082829169631543L;
    private Container target;
    private SizeRequirements[] xChildren;
    private SizeRequirements[] yChildren;
    private SizeRequirements xTotal;
    private SizeRequirements yTotal;
    private int[] offsetsX;
    private int[] offsetsY;
    private int[] spansX;
    private int[] spansY;

    public OverlayLayout(Container container) {
        this.target = container;
    }

    public void invalidateLayout(Container container) {
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
        this.offsetsX = null;
        this.offsetsY = null;
        this.spansX = null;
        this.spansY = null;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        if (container != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkTotalRequirements();
        return new Dimension(this.xTotal.preferred, this.yTotal.preferred);
    }

    public Dimension minimumLayoutSize(Container container) {
        if (container != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkTotalRequirements();
        return new Dimension(this.xTotal.minimum, this.yTotal.minimum);
    }

    public Dimension maximumLayoutSize(Container container) {
        if (container != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkTotalRequirements();
        return new Dimension(this.xTotal.maximum, this.yTotal.maximum);
    }

    public float getLayoutAlignmentX(Container container) {
        if (container != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkTotalRequirements();
        return this.xTotal.alignment;
    }

    public float getLayoutAlignmentY(Container container) {
        if (container != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkTotalRequirements();
        return this.yTotal.alignment;
    }

    public void layoutContainer(Container container) {
        if (container != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkLayout();
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setBounds(this.offsetsX[i], this.offsetsY[i], this.spansX[i], this.spansY[i]);
        }
    }

    private void checkRequirements() {
        if (this.xChildren == null || this.yChildren == null) {
            Component[] componentArray = this.target.getComponents();
            this.xChildren = new SizeRequirements[componentArray.length];
            this.yChildren = new SizeRequirements[componentArray.length];
            for (int i = 0; i < componentArray.length; ++i) {
                if (!componentArray[i].isVisible()) {
                    this.xChildren[i] = new SizeRequirements();
                    this.yChildren[i] = new SizeRequirements();
                    continue;
                }
                this.xChildren[i] = new SizeRequirements(componentArray[i].getMinimumSize().width, componentArray[i].getPreferredSize().width, componentArray[i].getMaximumSize().width, componentArray[i].getAlignmentX());
                this.yChildren[i] = new SizeRequirements(componentArray[i].getMinimumSize().height, componentArray[i].getPreferredSize().height, componentArray[i].getMaximumSize().height, componentArray[i].getAlignmentY());
            }
        }
    }

    private void checkTotalRequirements() {
        if (this.xTotal == null || this.yTotal == null) {
            this.checkRequirements();
            this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
            this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
        }
    }

    private void checkLayout() {
        if (this.offsetsX == null || this.offsetsY == null || this.spansX == null || this.spansY == null) {
            this.checkRequirements();
            this.checkTotalRequirements();
            int n = this.target.getComponents().length;
            this.offsetsX = new int[n];
            this.offsetsY = new int[n];
            this.spansX = new int[n];
            this.spansY = new int[n];
            Insets insets = this.target.getInsets();
            int n2 = this.target.getWidth() - insets.left - insets.right;
            int n3 = this.target.getHeight() - insets.top - insets.bottom;
            SizeRequirements.calculateAlignedPositions(n2, this.xTotal, this.xChildren, this.offsetsX, this.spansX);
            SizeRequirements.calculateAlignedPositions(n3, this.yTotal, this.yChildren, this.offsetsY, this.spansY);
        }
    }
}

