/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;

public final class DelegationPermission
extends BasicPermission {
    public DelegationPermission(String string) {
        super(string);
        DelegationPermission.checkSyntax(string);
    }

    public DelegationPermission(String string, String string2) {
        super(string, string2);
        DelegationPermission.checkSyntax(string);
    }

    private static void checkSyntax(String string) {
        int n = string.indexOf(34, 1);
        int n2 = string.length();
        if (string.charAt(0) != '\"' || string.charAt(n2 - 1) != '\"' || n == -1 || n + 3 >= n2 || string.charAt(n + 1) != ' ' || string.charAt(n + 2) != '\"') {
            throw new IllegalArgumentException("invalid syntax for principals");
        }
    }

    public boolean implies(Permission permission) {
        return this.equals(permission);
    }

    public PermissionCollection newPermissionCollection() {
        return new PermissionCollection(this){
            private /* synthetic */ DelegationPermission this$0;
            private Vector permissions;
            {
                this.this$0 = delegationPermission;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.permissions = new Vector();
            }

            public void add(Permission permission) {
                if (this.isReadOnly()) {
                    throw new SecurityException("readonly");
                }
                if (!(permission instanceof DelegationPermission)) {
                    throw new IllegalArgumentException("can only add DelegationPermissions");
                }
                this.permissions.add(permission);
            }

            public boolean implies(Permission permission) {
                if (!(permission instanceof DelegationPermission)) {
                    return false;
                }
                Enumeration enumeration = this.elements();
                while (enumeration.hasMoreElements()) {
                    DelegationPermission delegationPermission = (DelegationPermission)enumeration.nextElement();
                    if (!delegationPermission.implies(permission)) continue;
                    return true;
                }
                return false;
            }

            public Enumeration elements() {
                return this.permissions.elements();
            }
        };
    }
}

