/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.security.x509.X500DistinguishedName;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class TrustAnchor {
    private final X500DistinguishedName caName;
    private final PublicKey caKey;
    private final X509Certificate trustedCert;
    private final byte[] nameConstraints;

    public TrustAnchor(X509Certificate x509Certificate, byte[] byArray) {
        if (x509Certificate == null) {
            throw new NullPointerException();
        }
        this.trustedCert = x509Certificate;
        this.caName = null;
        this.caKey = null;
        this.nameConstraints = (byte[])(byArray != null ? (byte[])byArray.clone() : null);
    }

    public TrustAnchor(String string, PublicKey publicKey, byte[] byArray) {
        if (string == null || publicKey == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.trustedCert = null;
        this.caName = new X500DistinguishedName(string);
        this.caKey = publicKey;
        this.nameConstraints = (byte[])(byArray != null ? (byte[])byArray.clone() : null);
    }

    public final X509Certificate getTrustedCert() {
        return this.trustedCert;
    }

    public final String getCAName() {
        if (this.caName != null) {
            return this.caName.toString();
        }
        return null;
    }

    public final PublicKey getCAPublicKey() {
        return this.caKey;
    }

    public final byte[] getNameConstraints() {
        if (this.nameConstraints == null) {
            return null;
        }
        return (byte[])this.nameConstraints.clone();
    }

    public String toString() {
        if (this.trustedCert == null) {
            return "[ Trusted CA Public Key=" + this.caKey + ", Trusted CA Issuer Name=" + this.caName.toString() + " ]";
        }
        return "[ Trusted CA Certificate=" + this.trustedCert + " ]";
    }
}

