/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import gnu.java.rmi.server.RMIHashes;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.util.Hashtable;

public class RemoteObjectInvocationHandler
extends RemoteObject
implements InvocationHandler,
Remote,
Serializable {
    static final long serialVersionUID = 2L;
    static Hashtable methodHashCodes = new Hashtable();
    static final Class[] noArgsC = new Class[0];
    static final Class[] anObjectC = new Class[]{RemoteObjectInvocationHandler.class$("java.lang.Object")};
    static final Object[] noArgs = new Object[0];

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public RemoteObjectInvocationHandler(RemoteRef remoteRef) {
        super(remoteRef);
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (!(object instanceof Remote)) {
            String string = object == null ? "null" : object.getClass().getName();
            throw new IllegalAccessException(string + " does not implement " + RemoteObjectInvocationHandler.class$("java.rmi.Remote").getName());
        }
        if (objectArray == null) {
            objectArray = noArgs;
        }
        String string = method.getName();
        switch (string.charAt(0)) {
            case 'e': {
                if (objectArray.length != 1 || !string.equals("equals") || !method.getParameterTypes()[0].equals(RemoteObjectInvocationHandler.class$("java.lang.Object"))) break;
                if (objectArray[0] instanceof Proxy) {
                    InvocationHandler invocationHandler = Proxy.getInvocationHandler(objectArray[0]);
                    if (invocationHandler == null) {
                        return Boolean.FALSE;
                    }
                    return invocationHandler.equals(this) ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
            case 'h': {
                if (objectArray.length != 0 || !string.equals("hashCode")) break;
                int n = Proxy.getInvocationHandler(object).hashCode();
                return new Integer(n);
            }
            case 't': {
                if (objectArray.length != 0 || !string.equals("toString")) break;
                return "Proxy stub:" + this.ref.remoteToString();
            }
        }
        Long l = (Long)methodHashCodes.get(method);
        if (l == null) {
            l = new Long(RMIHashes.getMethodHash(method));
            methodHashCodes.put(method, l);
        }
        try {
            return this.getRef().invoke((Remote)object, method, objectArray, l);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            Class[] classArray = method.getExceptionTypes();
            Class clazz = exception.getClass();
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].equals(clazz)) continue;
                throw exception;
            }
            throw new UnexpectedException(method.getName(), exception);
        }
    }
}

