/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.VMNetworkInterface;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public final class NetworkInterface {
    private String name;
    private Vector inetAddresses;

    NetworkInterface(String string, InetAddress inetAddress) {
        this.name = string;
        this.inetAddresses = new Vector(1, 1);
        this.inetAddresses.add(inetAddress);
    }

    NetworkInterface(String string, InetAddress[] inetAddressArray) {
        this.name = string;
        this.inetAddresses = new Vector(inetAddressArray.length, 1);
        for (int i = 0; i < inetAddressArray.length; ++i) {
            this.inetAddresses.add(inetAddressArray[i]);
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration getInetAddresses() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return this.inetAddresses.elements();
        }
        Vector vector = new Vector(1, 1);
        Enumeration enumeration = this.inetAddresses.elements();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress = (InetAddress)enumeration.nextElement();
            try {
                securityManager.checkConnect(inetAddress.getHostAddress(), 58000);
                vector.add(inetAddress);
            }
            catch (SecurityException securityException) {}
        }
        return vector.elements();
    }

    public String getDisplayName() {
        return this.name;
    }

    public static NetworkInterface getByName(String string) throws SocketException {
        Enumeration enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = (NetworkInterface)enumeration.nextElement();
            if (!string.equals(networkInterface.getName())) continue;
            return networkInterface;
        }
        return null;
    }

    public static NetworkInterface getByInetAddress(InetAddress inetAddress) throws SocketException {
        Enumeration enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = (NetworkInterface)enumeration.nextElement();
            Enumeration enumeration2 = networkInterface.inetAddresses.elements();
            while (enumeration2.hasMoreElements()) {
                if (!inetAddress.equals((InetAddress)enumeration2.nextElement())) continue;
                return networkInterface;
            }
        }
        throw new SocketException("no network interface is bound to such an IP address");
    }

    private static Collection condense(Collection collection) {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            NetworkInterface networkInterface = (NetworkInterface)iterator.next();
            String string = networkInterface.getName();
            if (hashMap.containsKey(string)) {
                NetworkInterface networkInterface2 = (NetworkInterface)hashMap.get(string);
                if (networkInterface2.inetAddresses.containsAll(networkInterface.inetAddresses)) continue;
                Iterator iterator2 = networkInterface.inetAddresses.iterator();
                while (iterator2.hasNext()) {
                    InetAddress inetAddress = (InetAddress)iterator2.next();
                    if (networkInterface2.inetAddresses.contains(inetAddress)) continue;
                    networkInterface2.inetAddresses.add(inetAddress);
                }
                continue;
            }
            hashMap.put(string, networkInterface);
        }
        return hashMap.values();
    }

    public static Enumeration getNetworkInterfaces() throws SocketException {
        Vector vector = VMNetworkInterface.getInterfaces();
        if (vector.isEmpty()) {
            return null;
        }
        Collection collection = NetworkInterface.condense(vector);
        return Collections.enumeration(collection);
    }

    public boolean equals(Object object) {
        if (!(object instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface networkInterface = (NetworkInterface)object;
        return this.name.equals(networkInterface.name) && this.inetAddresses.equals(networkInterface.inetAddresses);
    }

    public int hashCode() {
        return this.name.hashCode() + this.inetAddresses.hashCode();
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = "name: " + this.getDisplayName() + " (" + this.getName() + ") addresses:" + string;
        Enumeration enumeration = this.inetAddresses.elements();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress = (InetAddress)enumeration.nextElement();
            string2 = string2 + new StringBuffer().append(inetAddress.toString()).append(";").append(string);
        }
        return string2;
    }
}

