/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class StringReader
extends Reader {
    private String buf;
    private int pos;
    private int markedPos;
    private int count;

    public StringReader(String string) {
        this.buf = string;
        this.count = string.length();
        this.pos = 0;
        this.markedPos = 0;
    }

    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.buf = null;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                this.markedPos = this.pos;
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                if (this.pos < this.count) {
                    int n2 = this.buf.charAt(this.pos++) & 0xFFFF;
                    Object var3_4 = null;
                    return n2;
                }
                n = -1;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
            Object var3_5 = null;
            return n;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                if (this.pos >= this.count) {
                    int n4 = -1;
                    Object var8_7 = null;
                    return n4;
                }
                int n5 = Math.min(this.count, this.pos + n2);
                this.buf.getChars(this.pos, n5, cArray, n);
                int n6 = n5 - this.pos;
                this.pos = n5;
                n3 = n6;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
            Object var8_8 = null;
            return n3;
        }
    }

    public boolean ready() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
        return true;
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                this.pos = this.markedPos;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                long l2 = Math.min((long)(this.count - this.pos), l < 0L ? 0L : l);
                this.pos += (int)l2;
                long l3 = l2;
                Object var8_5 = null;
                return l3;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                throw throwable;
            }
        }
    }
}

