/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.Util;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class ServerHello
implements Handshake.Body {
    private final ProtocolVersion version;
    private final Random random;
    private final byte[] sessionId;
    private final CipherSuite suite;
    private final CompressionMethod comp;
    private final List extensions;

    ServerHello(ProtocolVersion protocolVersion, Random random, byte[] byArray, CipherSuite cipherSuite, CompressionMethod compressionMethod) {
        this(protocolVersion, random, byArray, cipherSuite, compressionMethod, null);
    }

    ServerHello(ProtocolVersion protocolVersion, Random random, byte[] byArray, CipherSuite cipherSuite, CompressionMethod compressionMethod, List list2) {
        this.version = protocolVersion;
        this.random = random;
        this.sessionId = byArray;
        this.suite = cipherSuite;
        this.comp = compressionMethod;
        this.extensions = list2;
    }

    static ServerHello read(InputStream inputStream) throws IOException {
        ProtocolVersion protocolVersion = ProtocolVersion.read(inputStream);
        Random random = Random.read(inputStream);
        byte[] byArray = new byte[inputStream.read() & 0xFF];
        inputStream.read(byArray);
        CipherSuite cipherSuite = CipherSuite.read(inputStream).resolve(protocolVersion);
        CompressionMethod compressionMethod = CompressionMethod.read(inputStream);
        LinkedList linkedList = null;
        if (inputStream.available() > 0) {
            Extension extension;
            linkedList = new LinkedList();
            int n = inputStream.read() >>> 8 & 0xFF | inputStream.read() & 0xFF;
            for (int i = 0; i < n; i += extension.getValue().length + 4) {
                extension = Extension.read(inputStream);
                linkedList.add(extension);
            }
        }
        return new ServerHello(protocolVersion, random, byArray, cipherSuite, compressionMethod, linkedList);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.version.write(outputStream);
        this.random.write(outputStream);
        outputStream.write(this.sessionId.length);
        outputStream.write(this.sessionId);
        this.suite.write(outputStream);
        outputStream.write(this.comp.getValue());
        if (this.extensions != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Iterator iterator = this.extensions.iterator();
            while (iterator.hasNext()) {
                ((Extension)iterator.next()).write(byteArrayOutputStream);
            }
            outputStream.write(byteArrayOutputStream.size() >>> 8 & 0xFF);
            outputStream.write(byteArrayOutputStream.size() & 0xFF);
            byteArrayOutputStream.writeTo(outputStream);
        }
    }

    ProtocolVersion getVersion() {
        return this.version;
    }

    Random getRandom() {
        return this.random;
    }

    byte[] getSessionId() {
        return (byte[])this.sessionId.clone();
    }

    CipherSuite getCipherSuite() {
        return this.suite;
    }

    CompressionMethod getCompressionMethod() {
        return this.comp;
    }

    List getExtensions() {
        return this.extensions;
    }

    public String toString() {
        String string;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        printWriter.println("  version = " + this.version + ";");
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.random.toString()));
        try {
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.print("  ");
                printWriter.println(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        printWriter.println("  sessionId = " + Util.toHexString(this.sessionId, ':') + ";");
        printWriter.println("  cipherSuite = " + this.suite + ";");
        printWriter.println("  compressionMethod = " + this.comp + ";");
        if (this.extensions != null) {
            printWriter.println("  extensions = {");
            Iterator iterator = this.extensions.iterator();
            while (iterator.hasNext()) {
                bufferedReader = new BufferedReader(new StringReader(iterator.next().toString()));
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        printWriter.print("    ");
                        printWriter.println(string);
                    }
                }
                catch (IOException iOException) {
                }
            }
            printWriter.println("  };");
        }
        printWriter.println("} ServerHello;");
        return stringWriter.toString();
    }
}

