/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.javax.crypto.key.BaseKeyAgreementParty;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.key.dh.ElGamalKeyAgreement;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.interfaces.DHPublicKey;

public class ElGamalSender
extends ElGamalKeyAgreement {
    private DHPublicKey B;

    protected void engineInit(Map map) throws KeyAgreementException {
        this.rnd = (SecureRandom)map.get("gnu.crypto.elgamal.ka.prng");
        this.B = (DHPublicKey)map.get("gnu.crypto.elgamal.ka.recipient.public.key");
        if (this.B == null) {
            throw new KeyAgreementException("missing recipient public key");
        }
    }

    protected OutgoingMessage engineProcessMessage(IncomingMessage incomingMessage) throws KeyAgreementException {
        if (this.step == 0) {
            return this.computeSharedSecret(incomingMessage);
        }
        throw new IllegalStateException("unexpected state");
    }

    private OutgoingMessage computeSharedSecret(IncomingMessage incomingMessage) throws KeyAgreementException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.B.getParams().getP();
        BigInteger bigInteger3 = this.B.getParams().getG();
        BigInteger bigInteger4 = this.B.getY();
        BigInteger bigInteger5 = bigInteger2.subtract(BaseKeyAgreementParty.TWO);
        byte[] byArray = new byte[(bigInteger5.bitLength() + 7) / 8];
        do {
            this.nextRandomBytes(byArray);
        } while ((bigInteger = new BigInteger(1, byArray)).compareTo(BaseKeyAgreementParty.TWO) >= 0 && bigInteger.compareTo(bigInteger5) <= 0);
        OutgoingMessage outgoingMessage = new OutgoingMessage();
        outgoingMessage.writeMPI(bigInteger3.modPow(bigInteger, bigInteger2));
        this.ZZ = bigInteger4.modPow(bigInteger, bigInteger2);
        this.complete = true;
        return outgoingMessage;
    }
}

