/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.X500DistinguishedName;
import gnu.java.security.x509.X509CRLEntry;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public class X509CRL
extends java.security.cert.X509CRL
implements GnuPKIExtension {
    private static final Logger log = Logger.getLogger(X509CRL.class$("gnu.java.security.x509.X509CRL").getName());
    private static final OID ID_DSA = new OID("1.2.840.10040.4.1");
    private static final OID ID_DSA_WITH_SHA1 = new OID("1.2.840.10040.4.3");
    private static final OID ID_RSA = new OID("1.2.840.113549.1.1.1");
    private static final OID ID_RSA_WITH_MD2 = new OID("1.2.840.113549.1.1.2");
    private static final OID ID_RSA_WITH_MD5 = new OID("1.2.840.113549.1.1.4");
    private static final OID ID_RSA_WITH_SHA1 = new OID("1.2.840.113549.1.1.5");
    private byte[] encoded;
    private byte[] tbsCRLBytes;
    private int version;
    private OID algId;
    private byte[] algParams;
    private Date thisUpdate;
    private Date nextUpdate;
    private X500DistinguishedName issuerDN;
    private HashMap revokedCerts = new HashMap();
    private HashMap extensions = new HashMap();
    private OID sigAlg;
    private byte[] sigAlgParams;
    private byte[] rawSig;
    private byte[] signature;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public X509CRL(InputStream inputStream) throws CRLException, IOException {
        try {
            this.parse(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CRLException(exception.toString());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof X509CRL)) {
            return false;
        }
        return ((X509CRL)object).getRevokedCertificates().equals(this.revokedCerts.values());
    }

    public int hashCode() {
        return this.revokedCerts.hashCode();
    }

    public byte[] getEncoded() throws CRLException {
        return (byte[])this.encoded.clone();
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.sigAlg.toString());
        this.doVerify(signature, publicKey);
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.sigAlg.toString(), string);
        this.doVerify(signature, publicKey);
    }

    public int getVersion() {
        return this.version;
    }

    public Principal getIssuerDN() {
        return this.issuerDN;
    }

    public X500Principal getIssuerX500Principal() {
        return new X500Principal(this.issuerDN.getDer());
    }

    public Date getThisUpdate() {
        return (Date)this.thisUpdate.clone();
    }

    public Date getNextUpdate() {
        if (this.nextUpdate != null) {
            return (Date)this.nextUpdate.clone();
        }
        return null;
    }

    public java.security.cert.X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        return (java.security.cert.X509CRLEntry)this.revokedCerts.get(bigInteger);
    }

    public Set getRevokedCertificates() {
        return Collections.unmodifiableSet(new HashSet(this.revokedCerts.values()));
    }

    public byte[] getTBSCertList() throws CRLException {
        return (byte[])this.tbsCRLBytes.clone();
    }

    public byte[] getSignature() {
        return (byte[])this.rawSig.clone();
    }

    public String getSigAlgName() {
        if (this.sigAlg.equals(ID_DSA_WITH_SHA1)) {
            return "SHA1withDSA";
        }
        if (this.sigAlg.equals(ID_RSA_WITH_MD2)) {
            return "MD2withRSA";
        }
        if (this.sigAlg.equals(ID_RSA_WITH_MD5)) {
            return "MD5withRSA";
        }
        if (this.sigAlg.equals(ID_RSA_WITH_SHA1)) {
            return "SHA1withRSA";
        }
        return "unknown";
    }

    public String getSigAlgOID() {
        return this.sigAlg.toString();
    }

    public byte[] getSigAlgParams() {
        if (this.sigAlgParams != null) {
            return (byte[])this.sigAlgParams.clone();
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        Iterator iterator = this.extensions.values().iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.isCritical() || extension.isSupported()) continue;
            return true;
        }
        return false;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.extensions.values().iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getOid().toString());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.extensions.values().iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (extension.isCritical()) continue;
            hashSet.add(extension.getOid().toString());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public byte[] getExtensionValue(String string) {
        Extension extension = this.getExtension(new OID(string));
        if (extension != null) {
            return extension.getValue().getEncoded();
        }
        return null;
    }

    public Extension getExtension(OID oID) {
        return (Extension)this.extensions.get(oID);
    }

    public Collection getExtensions() {
        return this.extensions.values();
    }

    public String toString() {
        return X509CRL.class$("gnu.java.security.x509.X509CRL").getName();
    }

    public boolean isRevoked(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("not a X.509 certificate");
        }
        BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
        X509CRLEntry x509CRLEntry = (X509CRLEntry)this.revokedCerts.get(bigInteger);
        if (x509CRLEntry == null) {
            return false;
        }
        return x509CRLEntry.getRevocationDate().compareTo(new Date()) < 0;
    }

    private void doVerify(Signature signature, PublicKey publicKey) throws CRLException, InvalidKeyException, SignatureException {
        signature.initVerify(publicKey);
        signature.update(this.tbsCRLBytes);
        if (!signature.verify(this.signature)) {
            throw new CRLException("signature not verified");
        }
    }

    private void parse(InputStream inputStream) throws Exception {
        DERReader dERReader = new DERReader(inputStream);
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed CertificateList");
        }
        this.encoded = dERValue.getEncoded();
        dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed TBSCertList");
        }
        this.tbsCRLBytes = dERValue.getEncoded();
        dERValue = dERReader.read();
        if (dERValue.getValue() instanceof BigInteger) {
            this.version = ((BigInteger)dERValue.getValue()).intValue() + 1;
            dERValue = dERReader.read();
        } else {
            this.version = 1;
        }
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        DERValue dERValue2 = dERReader.read();
        this.algId = (OID)dERValue2.getValue();
        if (dERValue.getLength() > dERValue2.getEncodedLength()) {
            dERValue = dERReader.read();
            this.algParams = dERValue.getEncoded();
            if (dERValue.isConstructed()) {
                inputStream.skip(dERValue.getLength());
            }
        }
        dERValue = dERReader.read();
        this.issuerDN = new X500DistinguishedName(dERValue.getEncoded());
        dERReader.skip(dERValue.getLength());
        this.thisUpdate = (Date)dERReader.read().getValue();
        dERValue = dERReader.read();
        if (dERValue.getValue() instanceof Date) {
            this.nextUpdate = (Date)dERValue.getValue();
            dERValue = dERReader.read();
        }
        if (dERValue.getTag() != 0) {
            X509CRLEntry x509CRLEntry;
            for (int i = 0; i < dERValue.getLength(); i += x509CRLEntry.getEncoded().length) {
                x509CRLEntry = new X509CRLEntry(this.version, dERReader);
                this.revokedCerts.put(x509CRLEntry.getSerialNumber(), x509CRLEntry);
            }
            dERValue = dERReader.read();
        }
        if (dERValue.getTagClass() != 0 && dERValue.getTag() == 0) {
            DERValue dERValue3;
            if (this.version < 2) {
                throw new IOException("extra data in CRL");
            }
            DERValue dERValue4 = dERReader.read();
            if (!dERValue4.isConstructed()) {
                throw new IOException("malformed Extensions");
            }
            for (int i = 0; i < dERValue4.getLength(); i += dERValue3.getEncodedLength()) {
                dERValue3 = dERReader.read();
                if (!dERValue3.isConstructed()) {
                    throw new IOException("malformed Extension");
                }
                Extension extension = new Extension(dERValue3.getEncoded());
                this.extensions.put(extension.getOid(), extension);
                dERReader.skip(dERValue3.getLength());
            }
            dERValue = dERReader.read();
        }
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        DERValue dERValue5 = dERReader.read();
        if (dERValue5.getTag() != 6) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        this.sigAlg = (OID)dERValue5.getValue();
        if (dERValue.getLength() > dERValue5.getEncodedLength()) {
            dERValue = dERReader.read();
            this.sigAlgParams = dERValue.getEncoded();
            if (dERValue.isConstructed()) {
                inputStream.skip(dERValue.getLength());
            }
        }
        dERValue = dERReader.read();
        this.rawSig = dERValue.getEncoded();
        this.signature = ((BitString)dERValue.getValue()).toByteArray();
    }
}

