/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.ArrayList;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.EngineDescriptorManager;
import org.eclipse.help.ui.internal.views.RenameDialog;
import org.eclipse.help.ui.internal.views.ScopePreferenceDialog;
import org.eclipse.help.ui.internal.views.ScopePreferenceManager;
import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.help.ui.internal.views.ScopeSetManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ScopeSetDialog
extends ListDialog {
    private ScopeSetManager manager;
    private EngineDescriptorManager descManager;
    private static final int NEW_ID = 1025;
    private static final int EDIT_ID = 1026;
    private static final int RENAME_ID = 1027;
    private static final int REMOVE_ID = 1028;
    private Button editButton;
    private Button renameButton;
    private Button removeButton;
    private ArrayList sets;
    private ArrayList operations;

    public ScopeSetDialog(Shell parent, ScopeSetManager manager, EngineDescriptorManager descManager) {
        super(parent);
        this.manager = manager;
        this.descManager = descManager;
        this.sets = this.extractSets(manager.getScopeSets(false));
        this.setContentProvider(new ScopeContentProvider());
        this.setLabelProvider((ILabelProvider)new ScopeLabelProvider());
        this.setInitialSelections(new Object[]{manager.getActiveSet()});
    }

    private ArrayList extractSets(ScopeSet[] array) {
        ArrayList<ScopeSet> list = new ArrayList<ScopeSet>();
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    protected Control createDialogArea(Composite container) {
        Composite listContainer = (Composite)super.createDialogArea(container);
        this.createEditingButtons(listContainer);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ScopeSetDialog.this.updateButtons();
            }
        });
        return listContainer;
    }

    private void createEditingButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        this.createButton(buttonComposite, 1025, Messages.ScopeSetDialog_new, false);
        this.renameButton = this.createButton(buttonComposite, 1027, Messages.ScopeSetDialog_rename, false);
        this.editButton = this.createButton(buttonComposite, 1026, Messages.ScopeSetDialog_edit, false);
        this.removeButton = this.createButton(buttonComposite, 1028, Messages.ScopeSetDialog_remove, false);
        this.updateButtons();
    }

    public ScopeSet getActiveSet() {
        Object[] result = this.getResult();
        if (result != null && result.length > 0) {
            return (ScopeSet)result[0];
        }
        return null;
    }

    protected void okPressed() {
        if (this.operations != null) {
            int i = 0;
            while (i < this.operations.size()) {
                PendingOperation operation = (PendingOperation)this.operations.get(i);
                operation.commit();
                ++i;
            }
            this.operations = null;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.operations != null) {
            int i = 0;
            while (i < this.operations.size()) {
                PendingOperation operation = (PendingOperation)this.operations.get(i);
                operation.cancel();
                ++i;
            }
            this.operations = null;
        }
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.doNew();
                break;
            }
            case 1026: {
                this.doEdit();
                break;
            }
            case 1027: {
                this.doRename();
                break;
            }
            case 1028: {
                this.doRemove();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void doNew() {
        IStructuredSelection ssel = (IStructuredSelection)this.getTableViewer().getSelection();
        ScopeSet set = (ScopeSet)ssel.getFirstElement();
        ScopeSet newSet = new ScopeSet(set);
        String name = this.getNewName(newSet.getName());
        if (name != null) {
            newSet.setName(name);
            this.scheduleOperation(new AddOperation(newSet));
            this.sets.add(newSet);
            this.getTableViewer().refresh();
            this.updateButtons();
        }
    }

    private void doEdit() {
        IStructuredSelection ssel = (IStructuredSelection)this.getTableViewer().getSelection();
        ScopeSet set = (ScopeSet)ssel.getFirstElement();
        if (set != null) {
            ScopePreferenceManager manager = new ScopePreferenceManager(this.descManager, set);
            ScopePreferenceDialog dialog = new ScopePreferenceDialog(this.getShell(), manager, this.descManager, set.isEditable());
            dialog.setPreferenceStore(set.getPreferenceStore());
            dialog.create();
            dialog.getShell().setText(NLS.bind((String)Messages.ScopePreferenceDialog_wtitle, (Object)set.getName()));
            dialog.open();
        }
    }

    private void doRename() {
        RenameOperation rop;
        String oldName;
        String newName;
        IStructuredSelection ssel = (IStructuredSelection)this.getTableViewer().getSelection();
        ScopeSet set = (ScopeSet)ssel.getFirstElement();
        if (set != null && (newName = this.getNewName(oldName = (rop = (RenameOperation)this.findOperation(set, RenameOperation.class)) != null ? rop.newName : set.getName())) != null) {
            if (rop != null) {
                rop.newName = newName;
            } else {
                this.scheduleOperation(new RenameOperation(set, newName));
            }
            this.getTableViewer().update((Object)set, null);
            this.updateButtons();
        }
    }

    private String getNewName(String oldName) {
        RenameDialog dialog = new RenameDialog(this.getShell(), oldName);
        int i = 0;
        while (i < this.sets.size()) {
            ScopeSet set = (ScopeSet)this.sets.get(i);
            dialog.addOldName(set.getName());
            ++i;
        }
        dialog.create();
        dialog.getShell().setText(Messages.RenameDialog_wtitle);
        if (dialog.open() == 0) {
            return dialog.getNewName();
        }
        return null;
    }

    private void doRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.getTableViewer().getSelection();
        ScopeSet set = (ScopeSet)ssel.getFirstElement();
        if (set != null) {
            this.scheduleOperation(new RemoveOperation(set));
            this.sets.remove(set);
            this.getTableViewer().refresh();
            this.updateButtons();
        }
    }

    private void scheduleOperation(PendingOperation op) {
        if (this.operations == null) {
            this.operations = new ArrayList();
        }
        this.operations.add(op);
    }

    private void updateButtons() {
        IStructuredSelection ssel = (IStructuredSelection)this.getTableViewer().getSelection();
        this.editButton.setEnabled(!ssel.isEmpty());
        ScopeSet set = (ScopeSet)ssel.getFirstElement();
        boolean editableSet = set != null && set.isEditable() && !set.isImplicit();
        this.removeButton.setEnabled(editableSet);
        this.renameButton.setEnabled(editableSet);
        Button okButton = this.getOkButton();
        if (okButton != null) {
            okButton.setEnabled(set != null);
        }
    }

    private PendingOperation findOperation(ScopeSet set, Class type) {
        if (this.operations != null) {
            int i = 0;
            while (i < this.operations.size()) {
                PendingOperation op = (PendingOperation)this.operations.get(i);
                if (op.getClass().equals(type) && op.set.equals(set)) {
                    return op;
                }
                ++i;
            }
        }
        return null;
    }

    private abstract class PendingOperation {
        ScopeSet set;

        public PendingOperation(ScopeSet set) {
            this.set = set;
        }

        public abstract void commit();

        public abstract void cancel();
    }

    private class AddOperation
    extends PendingOperation {
        public AddOperation(ScopeSet set) {
            super(set);
        }

        public void commit() {
            ScopeSetDialog.this.manager.add(this.set);
        }

        public void cancel() {
            this.set.dispose();
        }
    }

    private class RenameOperation
    extends PendingOperation {
        private String newName;

        public RenameOperation(ScopeSet set, String newName) {
            super(set);
            this.newName = newName;
        }

        public void commit() {
            this.set.setName(this.newName);
        }

        public void cancel() {
        }
    }

    private class RemoveOperation
    extends PendingOperation {
        public RemoveOperation(ScopeSet set) {
            super(set);
        }

        public void commit() {
            ScopeSetDialog.this.manager.remove(this.set);
        }

        public void cancel() {
        }
    }

    private class ScopeContentProvider
    implements IStructuredContentProvider {
        private ScopeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ScopeSetDialog.this.sets.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ScopeLabelProvider
    extends LabelProvider {
        private ScopeLabelProvider() {
        }

        public String getText(Object obj) {
            String name = this.findNewName((ScopeSet)obj);
            if (name != null) {
                return name;
            }
            return ((ScopeSet)obj).getName();
        }

        private String findNewName(ScopeSet set) {
            PendingOperation op = ScopeSetDialog.this.findOperation(set, RenameOperation.class);
            if (op != null) {
                RenameOperation rop = (RenameOperation)op;
                return rop.newName;
            }
            return null;
        }

        public Image getImage(Object obj) {
            return HelpUIResources.getImage("obj16/scopeset_obj.gif");
        }
    }
}

