/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;

public class IncludedSchemaDescriptor
implements ISchemaDescriptor {
    private URL fSchemaURL;
    private String fSchemaLocation;
    private Schema fSchema;
    private long fLastModified;

    public IncludedSchemaDescriptor(URL schemaURL) {
        this.fSchemaURL = schemaURL;
        File file = new File(this.fSchemaURL.getFile());
        if (file.exists()) {
            this.fLastModified = file.lastModified();
        }
    }

    public static URL computeURL(ISchemaDescriptor parentDesc, String schemaLocation) throws MalformedURLException {
        if (schemaLocation.startsWith("schema://")) {
            Path path = new Path(schemaLocation.substring(9));
            return IncludedSchemaDescriptor.getPluginRelativePath(path.segment(0), path.removeFirstSegments(1), parentDesc.getSchemaURL());
        }
        URL parentURL = parentDesc.getSchemaURL();
        Path path = new Path(parentURL.getPath());
        path = path.removeLastSegments(1).append(schemaLocation);
        return new URL(parentURL.getProtocol(), parentURL.getHost(), path.toString());
    }

    private static URL getPluginRelativePath(String pluginID, IPath path, URL parentURL) {
        IPluginModelBase model;
        URL url = SchemaRegistry.getSchemaURL(pluginID, path.toString());
        if (url == null && (model = PDECore.getDefault().getModelManager().findModel(pluginID)) != null) {
            url = SchemaRegistry.getSchemaFromSourceExtension(model.getPluginBase(), path);
        }
        try {
            File file;
            if (url == null && parentURL != null && (file = new File(parentURL.getFile(), "../../../" + pluginID + "/" + path.toString())).exists() && file.isFile()) {
                url = file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return url;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getPointId() {
        int dotLoc = this.fSchemaLocation.lastIndexOf(46);
        if (dotLoc != -1) {
            return this.fSchemaLocation.substring(0, dotLoc);
        }
        return null;
    }

    public URL getSchemaURL() {
        return this.fSchemaURL;
    }

    public ISchema getSchema(boolean abbreviated) {
        if (this.fSchema == null && this.fSchemaURL != null) {
            this.fSchema = new Schema(this, this.fSchemaURL, abbreviated);
            this.fSchema.load();
        }
        return this.fSchema;
    }

    public boolean isStandalone() {
        return false;
    }

    public long getLastModified() {
        return this.fLastModified;
    }
}

