/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerDefaultPage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerDescriptor;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerSelectionPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension2;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ClasspathContainerWizard
extends Wizard {
    private ClasspathContainerDescriptor fPageDesc;
    private IClasspathEntry fEntryToEdit;
    private IClasspathEntry[] fNewEntries;
    private IClasspathContainerPage fContainerPage;
    private IJavaProject fCurrProject;
    private IClasspathEntry[] fCurrClasspath;
    private ClasspathContainerSelectionPage fSelectionWizardPage;

    public ClasspathContainerWizard(IClasspathEntry entryToEdit, IJavaProject currProject, IClasspathEntry[] currEntries) {
        this(entryToEdit, null, currProject, currEntries);
    }

    public ClasspathContainerWizard(ClasspathContainerDescriptor pageDesc, IJavaProject currProject, IClasspathEntry[] currEntries) {
        this(null, pageDesc, currProject, currEntries);
    }

    private ClasspathContainerWizard(IClasspathEntry entryToEdit, ClasspathContainerDescriptor pageDesc, IJavaProject currProject, IClasspathEntry[] currEntries) {
        this.fEntryToEdit = entryToEdit;
        this.fPageDesc = pageDesc;
        this.fNewEntries = null;
        this.fCurrProject = currProject;
        this.fCurrClasspath = currEntries;
        String title = entryToEdit == null ? NewWizardMessages.ClasspathContainerWizard_new_title : NewWizardMessages.ClasspathContainerWizard_edit_title;
        this.setWindowTitle(title);
    }

    public IClasspathEntry getNewEntry() {
        IClasspathEntry[] entries = this.getNewEntries();
        if (entries != null) {
            return entries[0];
        }
        return null;
    }

    public IClasspathEntry[] getNewEntries() {
        return this.fNewEntries;
    }

    public boolean performFinish() {
        if (this.fContainerPage != null && this.fContainerPage.finish()) {
            if (this.fEntryToEdit == null && this.fContainerPage instanceof IClasspathContainerPageExtension2) {
                this.fNewEntries = ((IClasspathContainerPageExtension2)((Object)this.fContainerPage)).getNewContainers();
            } else {
                IClasspathEntry[] iClasspathEntryArray;
                IClasspathEntry entry = this.fContainerPage.getSelection();
                if (entry != null) {
                    IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[1];
                    iClasspathEntryArray = iClasspathEntryArray2;
                    iClasspathEntryArray2[0] = entry;
                } else {
                    iClasspathEntryArray = null;
                }
                this.fNewEntries = iClasspathEntryArray;
            }
            return true;
        }
        return false;
    }

    public void addPages() {
        if (this.fPageDesc != null) {
            this.fContainerPage = this.getContainerPage(this.fPageDesc);
            this.addPage(this.fContainerPage);
        } else if (this.fEntryToEdit == null) {
            ClasspathContainerDescriptor[] containers = ClasspathContainerDescriptor.getDescriptors();
            this.fSelectionWizardPage = new ClasspathContainerSelectionPage(containers);
            this.addPage((IWizardPage)this.fSelectionWizardPage);
            this.fContainerPage = new ClasspathContainerDefaultPage();
            this.addPage(this.fContainerPage);
        } else {
            ClasspathContainerDescriptor[] containers = ClasspathContainerDescriptor.getDescriptors();
            ClasspathContainerDescriptor descriptor = this.findDescriptorPage(containers, this.fEntryToEdit);
            this.fContainerPage = this.getContainerPage(descriptor);
            this.addPage(this.fContainerPage);
        }
        super.addPages();
    }

    private IClasspathContainerPage getContainerPage(ClasspathContainerDescriptor pageDesc) {
        IClasspathContainerPage containerPage = null;
        if (pageDesc != null) {
            IClasspathContainerPage page = pageDesc.getPage();
            if (page != null) {
                return page;
            }
            try {
                containerPage = pageDesc.createPage();
            }
            catch (CoreException e) {
                this.handlePageCreationFailed(e);
                containerPage = null;
            }
        }
        if (containerPage == null) {
            containerPage = new ClasspathContainerDefaultPage();
            if (pageDesc != null) {
                pageDesc.setPage(containerPage);
            }
        }
        if (containerPage instanceof IClasspathContainerPageExtension) {
            ((IClasspathContainerPageExtension)((Object)containerPage)).initialize(this.fCurrProject, this.fCurrClasspath);
        }
        containerPage.setSelection(this.fEntryToEdit);
        containerPage.setWizard((IWizard)this);
        return containerPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fSelectionWizardPage) {
            ClasspathContainerDescriptor selected = this.fSelectionWizardPage.getSelected();
            this.fContainerPage = this.getContainerPage(selected);
            return this.fContainerPage;
        }
        return super.getNextPage(page);
    }

    private void handlePageCreationFailed(CoreException e) {
        String title = NewWizardMessages.ClasspathContainerWizard_pagecreationerror_title;
        String message = NewWizardMessages.ClasspathContainerWizard_pagecreationerror_message;
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    private ClasspathContainerDescriptor findDescriptorPage(ClasspathContainerDescriptor[] containers, IClasspathEntry entry) {
        int i = 0;
        while (i < containers.length) {
            if (containers[i].canEdit(entry)) {
                return containers[i];
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
        if (this.fSelectionWizardPage != null) {
            ClasspathContainerDescriptor[] descriptors = this.fSelectionWizardPage.getContainers();
            int i = 0;
            while (i < descriptors.length) {
                descriptors[i].dispose();
                ++i;
            }
        }
        super.dispose();
    }

    public boolean canFinish() {
        if (this.fSelectionWizardPage != null && !this.fContainerPage.isPageComplete()) {
            return false;
        }
        if (this.fContainerPage != null) {
            return this.fContainerPage.isPageComplete();
        }
        return false;
    }

    public static int openWizard(Shell shell, ClasspathContainerWizard wizard) {
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        return dialog.open();
    }
}

