/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.viewers;

import java.util.Collection;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IListChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.observable.list.WritableList;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.WritableSet;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ObservableListContentProvider
implements IStructuredContentProvider {
    private IObservableList observableList = new WritableList();
    private Viewer viewer;
    private IListChangeListener listener = new IListChangeListener(){

        public void handleListChange(IObservableList source, ListDiff diff) {
            if (ObservableListContentProvider.this.viewer.getControl().isDisposed()) {
                return;
            }
            ListDiffEntry[] differences = diff.getDifferences();
            int i = 0;
            while (i < differences.length) {
                ListDiffEntry entry = differences[i];
                if (entry.isAddition()) {
                    ObservableListContentProvider.this.knownElements.add(entry.getElement());
                    if (ObservableListContentProvider.this.viewer instanceof AbstractListViewer) {
                        ((AbstractListViewer)ObservableListContentProvider.this.viewer).add(entry.getElement());
                    } else {
                        ((TableViewer)ObservableListContentProvider.this.viewer).insert(entry.getElement(), entry.getPosition());
                    }
                } else {
                    if (ObservableListContentProvider.this.viewer instanceof AbstractListViewer) {
                        ((AbstractListViewer)ObservableListContentProvider.this.viewer).remove(entry.getElement());
                    } else {
                        ((TableViewer)ObservableListContentProvider.this.viewer).remove(entry.getElement());
                    }
                    ObservableListContentProvider.this.knownElements.remove(entry.getElement());
                }
                ++i;
            }
        }
    };
    private IObservableSet knownElements = new WritableSet();

    public Object[] getElements(Object inputElement) {
        return this.observableList.toArray();
    }

    public void dispose() {
        this.observableList.removeListChangeListener(this.listener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (!(viewer instanceof TableViewer) && !(viewer instanceof AbstractListViewer)) {
            throw new IllegalArgumentException("This content provider only works with TableViewer or AbstractListViewer");
        }
        if (newInput != null && !(newInput instanceof IObservableList)) {
            throw new IllegalArgumentException("This content provider only works with input of type IObservableList");
        }
        this.setInput((IObservableList)newInput);
    }

    private void setInput(IObservableList list) {
        if (list == null) {
            list = new WritableList();
        }
        if (this.observableList != null) {
            this.observableList.removeListChangeListener(this.listener);
        }
        this.knownElements.clear();
        this.observableList = list;
        this.knownElements.addAll((Collection)list);
        this.observableList.addListChangeListener(this.listener);
    }

    public IObservableSet getKnownElements() {
        return this.knownElements;
    }
}

