/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ObservableList;

public class WritableList
extends ObservableList {
    public WritableList() {
        this(Object.class);
    }

    public WritableList(Object elementType) {
        super(new ArrayList(), elementType);
    }

    public Object set(int index, Object element) {
        this.getterCalled();
        Object oldElement = this.wrappedList.set(index, element);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, false, oldElement), Diffs.createListDiffEntry(index, true, element)));
        return oldElement;
    }

    public Object remove(int index) {
        this.getterCalled();
        Object oldElement = this.wrappedList.remove(index);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, false, oldElement)));
        return oldElement;
    }

    public boolean add(Object element) {
        this.getterCalled();
        boolean added = this.wrappedList.add(element);
        if (added) {
            this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(this.wrappedList.size() - 1, true, element)));
        }
        return added;
    }

    public void add(int index, Object element) {
        this.wrappedList.add(index, element);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, true, element)));
    }

    public boolean addAll(Collection c) {
        ListDiffEntry[] entries = new ListDiffEntry[c.size()];
        int i = 0;
        int addIndex = c.size();
        for (Object element : c) {
            entries[i++] = Diffs.createListDiffEntry(addIndex++, true, element);
        }
        boolean added = this.wrappedList.addAll(c);
        this.fireListChange(Diffs.createListDiff(entries));
        return added;
    }

    public boolean addAll(int index, Collection c) {
        ListDiffEntry[] entries = new ListDiffEntry[c.size()];
        int i = 0;
        int addIndex = index;
        for (Object element : c) {
            entries[i++] = Diffs.createListDiffEntry(addIndex++, true, element);
        }
        boolean added = this.wrappedList.addAll(index, c);
        this.fireListChange(Diffs.createListDiff(entries));
        return added;
    }

    public boolean remove(Object o) {
        int index = this.wrappedList.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.wrappedList.remove(index);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, false, o)));
        return true;
    }

    public boolean removeAll(Collection c) {
        ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>();
        for (Object element : c) {
            int removeIndex = this.wrappedList.indexOf(element);
            if (removeIndex == -1) continue;
            this.wrappedList.remove(removeIndex);
            entries.add(Diffs.createListDiffEntry(removeIndex, true, element));
        }
        this.fireListChange(Diffs.createListDiff(entries.toArray(new ListDiffEntry[entries.size()])));
        return entries.size() > 0;
    }

    public boolean retainAll(Collection c) {
        ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>();
        int removeIndex = 0;
        Iterator it = this.wrappedList.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!c.contains(element)) {
                entries.add(Diffs.createListDiffEntry(removeIndex, false, element));
                it.remove();
                continue;
            }
            ++removeIndex;
        }
        this.fireListChange(Diffs.createListDiff(entries.toArray(new ListDiffEntry[entries.size()])));
        return entries.size() > 0;
    }

    public void clear() {
        ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>();
        for (Object element : this.wrappedList) {
            entries.add(Diffs.createListDiffEntry(0, false, element));
        }
        this.fireListChange(Diffs.createListDiff(entries.toArray(new ListDiffEntry[entries.size()])));
    }
}

