/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.IBreakpointOrganizer;
import org.eclipse.debug.ui.IBreakpointOrganizerDelegate;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;

public class BreakpointOrganizerExtension
implements IBreakpointOrganizer {
    private IConfigurationElement fElement;
    private IBreakpointOrganizerDelegate fDelegate;
    private ImageDescriptor fDescriptor;
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_ID = "id";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_OTHERS_LABEL = "othersLabel";

    public BreakpointOrganizerExtension(IConfigurationElement element) {
        this.fElement = element;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fDescriptor == null) {
            this.fDescriptor = DebugUIPlugin.getImageDescriptor(this.fElement, ATTR_ICON);
            if (this.fDescriptor == null) {
                this.fDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
        }
        return this.fDescriptor;
    }

    public String getLabel() {
        return this.fElement.getAttribute(ATTR_LABEL);
    }

    public String getIdentifier() {
        return this.fElement.getAttribute(ATTR_ID);
    }

    protected IBreakpointOrganizerDelegate getOrganizer() {
        if (this.fDelegate == null) {
            try {
                this.fDelegate = (IBreakpointOrganizerDelegate)this.fElement.createExecutableExtension(ATTR_CLASS);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return this.fDelegate;
    }

    public IAdaptable[] getCategories(IBreakpoint breakpoint) {
        return this.getOrganizer().getCategories(breakpoint);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.getOrganizer().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.getOrganizer().removePropertyChangeListener(listener);
    }

    public void addBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
        this.getOrganizer().addBreakpoint(breakpoint, category);
    }

    public void removeBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
        this.getOrganizer().removeBreakpoint(breakpoint, category);
    }

    public boolean canAdd(IBreakpoint breakpoint, IAdaptable category) {
        return this.getOrganizer().canAdd(breakpoint, category);
    }

    public boolean canRemove(IBreakpoint breakpoint, IAdaptable category) {
        return this.getOrganizer().canRemove(breakpoint, category);
    }

    public void dispose() {
        if (this.fDelegate != null) {
            this.fDelegate.dispose();
        }
    }

    public String getOthersLabel() {
        String attribute = this.fElement.getAttribute(ATTR_OTHERS_LABEL);
        if (attribute == null) {
            return DebugUIViewsMessages.OtherBreakpointOrganizer_0;
        }
        return attribute;
    }

    public IAdaptable[] getCategories() {
        return this.getOrganizer().getCategories();
    }
}

