/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.saxparser;

import java.util.Vector;
import org.eclipse.wst.dtd.core.internal.saxparser.AttNode;
import org.eclipse.wst.dtd.core.internal.saxparser.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.saxparser.CMGroupNode;
import org.eclipse.wst.dtd.core.internal.saxparser.CMNode;
import org.eclipse.wst.dtd.core.internal.saxparser.CMReferenceNode;
import org.eclipse.wst.dtd.core.internal.saxparser.CMRepeatableNode;
import org.eclipse.wst.dtd.core.internal.saxparser.EntityDecl;
import org.eclipse.wst.dtd.core.internal.saxparser.EntityPool;
import org.eclipse.wst.dtd.core.internal.saxparser.ExternalID;
import org.eclipse.wst.dtd.core.internal.saxparser.NotationDecl;
import org.eclipse.wst.dtd.core.internal.saxparser.StringParser;

public class DTDScanner {
    private static final char[] empty_string = new char[]{'E', 'M', 'P', 'T', 'Y'};
    private static final char[] any_string = new char[]{'A', 'N', 'Y'};
    private static final char[] pcdata_string = new char[]{'#', 'P', 'C', 'D', 'A', 'T', 'A'};
    private static final char[] cdata_string = new char[]{'C', 'D', 'A', 'T', 'A'};
    private static final char[] id_string = new char[]{'I', 'D'};
    private static final char[] ref_string = new char[]{'R', 'E', 'F'};
    private static final char[] entit_string = new char[]{'E', 'N', 'T', 'I', 'T'};
    private static final char[] ies_string = new char[]{'I', 'E', 'S'};
    private static final char[] nmtoken_string = new char[]{'N', 'M', 'T', 'O', 'K', 'E', 'N'};
    private static final char[] notation_string = new char[]{'N', 'O', 'T', 'A', 'T', 'I', 'O', 'N'};
    private static final char[] required_string = new char[]{'#', 'R', 'E', 'Q', 'U', 'I', 'R', 'E', 'D'};
    private static final char[] implied_string = new char[]{'#', 'I', 'M', 'P', 'L', 'I', 'E', 'D'};
    private static final char[] fixed_string = new char[]{'#', 'F', 'I', 'X', 'E', 'D'};
    private static final char[] system_string = new char[]{'S', 'Y', 'S', 'T', 'E', 'M'};
    private static final char[] public_string = new char[]{'P', 'U', 'B', 'L', 'I', 'C'};
    private static final char[] ndata_string = new char[]{'N', 'D', 'A', 'T', 'A'};
    private int[] fOpStack = null;
    private CMGroupNode[] fGrpStack = null;
    private EntityPool entityPool;
    static final int Att_Scanner_State_Name = 1;
    static final int Att_Scanner_State_Type = 2;
    static final int Att_Scanner_State_DefaultType = 3;
    static final int Att_Scanner_State_DefaultValue = 4;
    private StringParser contentString;
    private String cData;
    private int prevNodeOffset = 0;
    private int nodeOffset = 1;
    private String ownerDTD;
    private String errorString;

    public DTDScanner(String ownerDTD, String cm) {
        this.contentString = new StringParser(cm);
        this.cData = cm;
        this.ownerDTD = ownerDTD;
    }

    public CMNode scanContentModel() {
        CMNode cmNode = null;
        this.contentString.skipPastSpaces();
        if (this.contentString.skippedString(empty_string)) {
            cmNode = new CMBasicNode("EMPTY", 1);
        } else if (this.contentString.skippedString(any_string)) {
            cmNode = new CMBasicNode("ANY", 2);
        } else if (this.contentString.lookingAtChar('%', true)) {
            cmNode = new CMReferenceNode(this.contentString.getData(), 5);
        } else {
            if (!this.contentString.lookingAtChar('(', true)) {
                return cmNode;
            }
            this.contentString.skipPastSpaces();
            boolean skippedPCDATA = this.contentString.skippedString(pcdata_string);
            cmNode = skippedPCDATA ? this.scanMixed() : this.scanChildren();
        }
        return cmNode;
    }

    private CMNode scanMixed() {
        CMGroupNode cmNode = new CMGroupNode();
        cmNode.setGroupKind(11);
        cmNode.addChild(new CMBasicNode("#PCDATA", 3));
        boolean starRequired = false;
        while (true) {
            if (this.contentString.lookingAtSpace(true)) {
                this.contentString.skipPastSpaces();
            }
            this.prevNodeOffset = this.contentString.getCurrentOffset();
            if (!this.contentString.lookingAtChar('|', true)) {
                if (!this.contentString.lookingAtChar(')', true) || !this.contentString.lookingAtChar('*', true)) break;
                cmNode.setOccurrence(10);
                break;
            }
            if (this.contentString.lookingAtSpace(true)) {
                this.contentString.skipPastSpaces();
            }
            this.nodeOffset = this.contentString.getCurrentOffset();
            if (this.nodeOffset != -1) {
                this.prevNodeOffset = this.nodeOffset;
            }
            starRequired = true;
            this.contentString.skipPastNameAndPEReference(')');
            this.nodeOffset = this.contentString.getCurrentOffset();
            if (this.nodeOffset == -1) break;
            int len = this.nodeOffset - this.prevNodeOffset;
            String refName = this.contentString.getString(this.prevNodeOffset, len);
            this.prevNodeOffset = this.nodeOffset;
            if (refName.startsWith("%")) {
                cmNode.addChild(new CMReferenceNode(refName, 5));
                continue;
            }
            cmNode.addChild(new CMReferenceNode(refName, 4));
        }
        if (cmNode.getChildren().size() == 1) {
            return (CMBasicNode)cmNode.getChildren().elementAt(0);
        }
        return cmNode;
    }

    private CMNode scanChildren() {
        CMReferenceNode ref;
        CMRepeatableNode rn;
        CMGroupNode cmNode;
        if (this.contentString.lookingAtSpace(true)) {
            this.contentString.skipPastSpaces();
        }
        this.prevNodeOffset = this.contentString.getCurrentOffset();
        this.nodeOffset = this.contentString.getCurrentOffset();
        int depth = 1;
        this.initializeContentModelStack(depth);
        this.fGrpStack[depth] = cmNode = new CMGroupNode();
        while (true) {
            if (this.contentString.lookingAtChar('(', true)) {
                if (this.contentString.lookingAtSpace(true)) {
                    this.contentString.skipPastSpaces();
                }
                this.initializeContentModelStack(++depth);
                this.fGrpStack[depth] = new CMGroupNode();
                this.fGrpStack[depth - 1].addChild(this.fGrpStack[depth]);
                continue;
            }
            this.prevNodeOffset = this.contentString.getCurrentOffset();
            this.contentString.skipPastNameAndPEReference(')');
            this.nodeOffset = this.contentString.getCurrentOffset();
            int len = this.nodeOffset - this.prevNodeOffset;
            if (this.nodeOffset == -1 || len < 1) break;
            String nodeName = this.contentString.getString(this.prevNodeOffset, len);
            rn = nodeName.startsWith("%") ? new CMReferenceNode(nodeName, 5) : new CMReferenceNode(nodeName, 4);
            this.fGrpStack[depth].addChild(rn);
            this.prevNodeOffset = this.nodeOffset;
            if (this.contentString.lookingAtChar('?', true)) {
                rn.setOccurrence(8);
            } else if (this.contentString.lookingAtChar('*', true)) {
                rn.setOccurrence(10);
            } else if (this.contentString.lookingAtChar('+', true)) {
                rn.setOccurrence(9);
            }
            if (this.contentString.lookingAtSpace(true)) {
                this.contentString.skipPastSpaces();
            }
            this.prevNodeOffset = this.contentString.getCurrentOffset();
            while (true) {
                if (this.fOpStack[depth] != 12 && this.contentString.lookingAtChar('|', true)) {
                    this.fOpStack[depth] = 11;
                    this.fGrpStack[depth].setGroupKind(11);
                    if (!this.contentString.lookingAtSpace(true)) break;
                    this.contentString.skipPastSpaces();
                    break;
                }
                if (this.fOpStack[depth] != 11 && this.contentString.lookingAtChar(',', true)) {
                    this.fOpStack[depth] = 12;
                    this.fGrpStack[depth].setGroupKind(12);
                    if (!this.contentString.lookingAtSpace(true)) break;
                    this.contentString.skipPastSpaces();
                    break;
                }
                if (this.contentString.lookingAtSpace(true)) {
                    this.contentString.skipPastSpaces();
                }
                this.contentString.lookingAtChar(')', true);
                if (this.contentString.lookingAtChar('?', true)) {
                    this.fGrpStack[depth].setOccurrence(8);
                } else if (this.contentString.lookingAtChar('*', true)) {
                    this.fGrpStack[depth].setOccurrence(10);
                } else if (this.contentString.lookingAtChar('+', true)) {
                    this.fGrpStack[depth].setOccurrence(9);
                }
                if (--depth == 0) break;
                if (!this.contentString.lookingAtSpace(true)) continue;
                this.contentString.skipPastSpaces();
            }
            if (depth == 0) break;
        }
        if (cmNode.getChildren().size() == 1 && (rn = (CMRepeatableNode)cmNode.getChildren().elementAt(0)) instanceof CMReferenceNode && (ref = (CMReferenceNode)rn).getType() == 4) {
            if (ref.getOccurrence() == 7) {
                ref.setOccurrence(cmNode.getOccurrence());
                return ref;
            }
            if (cmNode.getOccurrence() == 7) {
                return ref;
            }
        }
        return cmNode;
    }

    public Vector scanAttlistDecl(EntityPool entityPool) {
        Vector<AttNode> attList = new Vector<AttNode>();
        this.entityPool = entityPool;
        int scannerState = 1;
        while (true) {
            AttNode attNode = new AttNode();
            if (scannerState == 1 && (scannerState = this.checkForAttributeWithPEReference(attNode, scannerState)) == -1) {
                return attList;
            }
            if (scannerState == 2) {
                if (this.contentString.skippedString(cdata_string)) {
                    attNode.type = new String(cdata_string);
                    scannerState = 3;
                } else if (this.contentString.skippedString(id_string)) {
                    attNode.type = !this.contentString.skippedString(ref_string) ? new String(id_string) : (!this.contentString.lookingAtChar('S', true) ? "IDREF" : "IDREFS");
                    scannerState = 3;
                } else if (this.contentString.skippedString(entit_string)) {
                    if (this.contentString.lookingAtChar('Y', true)) {
                        attNode.type = "ENTITY";
                    } else if (this.contentString.skippedString(ies_string)) {
                        attNode.type = "ENTITIES";
                    }
                    scannerState = 3;
                } else if (this.contentString.skippedString(nmtoken_string)) {
                    attNode.type = this.contentString.lookingAtChar('S', true) ? "NMTOKENS" : "NMTOKEN";
                    scannerState = 3;
                } else if (this.contentString.skippedString(notation_string)) {
                    if (this.contentString.lookingAtSpace(true)) {
                        this.contentString.skipPastSpaces();
                    }
                    if (!this.contentString.lookingAtChar('(', true)) {
                        System.out.println(" missing ( in notation ");
                    }
                    attNode.type = "NOTATION";
                    attNode.enumList = this.scanEnumeration(this.contentString, true);
                    scannerState = 3;
                } else if (this.contentString.lookingAtChar('(', true)) {
                    attNode.type = "ENUMERATION";
                    attNode.enumList = this.scanEnumeration(this.contentString, false);
                    scannerState = 3;
                } else if ((scannerState = this.checkForAttributeWithPEReference(attNode, scannerState)) == 2) {
                    this.setErrorString("Failed to find type for attribute '" + attNode.name + "'.  Please refer to the original DTD file.");
                    return attList;
                }
            }
            if (scannerState == 3) {
                this.contentString.skipPastSpaces();
                if (this.contentString.skippedString(required_string)) {
                    attNode.defaultType = new String(required_string);
                } else if (this.contentString.skippedString(implied_string)) {
                    attNode.defaultType = new String(implied_string);
                } else {
                    if (this.contentString.skippedString(fixed_string)) {
                        this.contentString.skipPastSpaces();
                        attNode.defaultType = new String(fixed_string);
                    } else {
                        attNode.defaultType = "NOFIXED";
                    }
                    if (this.contentString.lookingAtSpace(true)) {
                        this.contentString.skipPastSpaces();
                    }
                    attNode.defaultValue = this.scanDefaultAttValue(this.contentString);
                }
                scannerState = 1;
            }
            attList.addElement(attNode);
            if (this.contentString.lookingAtSpace(true)) {
                this.contentString.skipPastSpaces();
            }
            this.nodeOffset = this.contentString.getCurrentOffset();
            if (this.nodeOffset >= this.cData.length()) {
                return attList;
            }
            this.prevNodeOffset = this.contentString.getCurrentOffset();
        }
    }

    private void initializeContentModelStack(int depth) {
        if (this.fOpStack == null) {
            this.fOpStack = new int[8];
            this.fGrpStack = new CMGroupNode[8];
        } else if (depth == this.fOpStack.length) {
            int[] newStack = new int[depth * 2];
            System.arraycopy(this.fOpStack, 0, newStack, 0, depth);
            this.fOpStack = newStack;
            CMGroupNode[] newGrpStack = new CMGroupNode[depth * 2];
            System.arraycopy(this.fGrpStack, 0, newGrpStack, 0, depth);
            this.fGrpStack = newGrpStack;
        }
        this.fOpStack[depth] = -1;
        this.fGrpStack[depth] = null;
    }

    private int checkForAttributeWithPEReference(AttNode attNode, int scannerState) {
        int state = -1;
        if (scannerState == 1) {
            String pe;
            EntityDecl pEntity;
            String rawText;
            this.contentString.skipPastNameAndPEReference(' ');
            this.nodeOffset = this.contentString.getCurrentOffset();
            int len = this.nodeOffset - this.prevNodeOffset;
            attNode.name = rawText = this.contentString.getString(this.prevNodeOffset, len);
            state = rawText.startsWith("%") && rawText.endsWith(";") ? ((pEntity = this.entityPool.referPara(pe = rawText.substring(1, rawText.length() - 1))) != null ? this.whatIsTheNextAttributeScanningState(pEntity.expandedValue, scannerState) : 2) : 2;
        } else if (scannerState == 2) {
            if (this.contentString.lookingAtChar('%', true)) {
                String rawText = this.getPEName();
                attNode.type = "%" + rawText;
                String peName = rawText.substring(0, rawText.length() - 1);
                EntityDecl pEntity = this.entityPool.referPara(peName);
                state = pEntity != null ? this.whatIsTheNextAttributeScanningState(pEntity.expandedValue, scannerState) : 3;
            } else {
                state = 2;
            }
        } else if (scannerState == 3) {
            if (this.contentString.lookingAtChar('%', true)) {
                String rawText;
                attNode.defaultType = rawText = this.getPEName();
                EntityDecl pEntity = this.entityPool.referPara(rawText.substring(1, rawText.length() - 1));
                state = pEntity != null ? this.whatIsTheNextAttributeScanningState(pEntity.expandedValue, scannerState) : 4;
            } else {
                state = 3;
            }
        } else if (scannerState == 4) {
            if (this.contentString.lookingAtChar('%', true)) {
                String rawText;
                attNode.defaultValue = rawText = this.getPEName();
                EntityDecl pEntity = this.entityPool.referPara(rawText.substring(1, rawText.length() - 1));
                state = pEntity != null ? this.whatIsTheNextAttributeScanningState(pEntity.expandedValue, scannerState) : 4;
            } else {
                state = 4;
            }
        }
        if (this.contentString.lookingAtSpace(true)) {
            this.contentString.skipPastSpaces();
        }
        this.prevNodeOffset = this.contentString.getCurrentOffset();
        return state;
    }

    private String getPEName() {
        this.prevNodeOffset = this.contentString.getCurrentOffset();
        this.contentString.skipToChar(';', true);
        this.nodeOffset = this.contentString.getCurrentOffset();
        int len = this.nodeOffset - this.prevNodeOffset;
        return this.contentString.getString(this.prevNodeOffset, len);
    }

    private int whatIsTheNextAttributeScanningState(String attrContentString, int currentState) {
        StringParser sp = new StringParser(attrContentString.trim());
        int nextState = currentState;
        int nOffset = 0;
        do {
            if (nextState == 1) {
                if (this.isAttrName(sp)) {
                    nextState = 2;
                }
            } else if (nextState == 2) {
                if (this.isAttrType(sp)) {
                    nextState = 3;
                } else {
                    System.out.println("WhatistheNext Attr Part - is not an Attr Type");
                }
            }
            if (nextState == 3) {
                int dType = this.isAttrDefaultType(sp);
                if (dType == 1) {
                    nextState = 1;
                } else {
                    if (dType == 2) {
                        nextState = 3;
                    }
                    if (this.scanDefaultAttValue(sp) != null) {
                        nextState = 1;
                    }
                }
            }
            sp.skipPastSpaces();
        } while (nOffset != sp.getCurrentOffset() && (nOffset = sp.getCurrentOffset()) < attrContentString.length() && nOffset != -1);
        return nextState;
    }

    private boolean isAttrName(StringParser sp) {
        boolean isAttrName = false;
        int prev = sp.getCurrentOffset();
        sp.skipPastName(' ');
        if (sp.getCurrentOffset() - prev > 0) {
            isAttrName = true;
        }
        return isAttrName;
    }

    private boolean isAttrType(StringParser sp) {
        boolean isAttrType = false;
        if (sp.skippedString(cdata_string)) {
            isAttrType = true;
        } else if (sp.skippedString(id_string)) {
            isAttrType = !sp.skippedString(ref_string) ? true : (!sp.lookingAtChar('S', true) ? true : true);
        } else if (sp.skippedString(entit_string)) {
            if (sp.lookingAtChar('Y', true)) {
                isAttrType = true;
            } else if (sp.skippedString(ies_string)) {
                isAttrType = true;
            }
        } else if (sp.skippedString(nmtoken_string)) {
            isAttrType = sp.lookingAtChar('S', true) ? true : true;
        } else if (sp.skippedString(notation_string)) {
            sp.lookingAtChar('(', true);
            Vector enumList = this.scanEnumeration(sp, true);
            isAttrType = enumList != null && enumList.size() != 0;
        } else if (sp.lookingAtChar('(', true)) {
            Vector enumList = this.scanEnumeration(sp, false);
            isAttrType = enumList != null && enumList.size() != 0;
        }
        return isAttrType;
    }

    private int isAttrDefaultType(StringParser sp) {
        int result = 0;
        if (sp.skippedString(required_string)) {
            result = 1;
        } else if (sp.skippedString(implied_string)) {
            result = 1;
        } else if (sp.skippedString(fixed_string)) {
            result = 2;
        }
        return result;
    }

    private Vector scanEnumeration(StringParser sp, boolean isNotationType) {
        Vector<String> enumList = null;
        if (sp.lookingAtSpace(true)) {
            sp.skipPastSpaces();
        }
        int prevNodeOffset = sp.getCurrentOffset();
        while (true) {
            if (isNotationType) {
                sp.skipPastNameAndPEReference(')');
            } else {
                sp.skipPastNmtokenAndPEReference(')');
            }
            int nodeOffset = sp.getCurrentOffset();
            if (nodeOffset == -1) {
                return enumList;
            }
            int len = nodeOffset - prevNodeOffset;
            String nodeName = sp.getString(prevNodeOffset, len);
            if (enumList == null) {
                enumList = new Vector<String>();
            }
            enumList.addElement(nodeName);
            if (sp.lookingAtSpace(true)) {
                sp.skipPastSpaces();
            }
            if (!sp.lookingAtChar('|', true)) {
                if (sp.lookingAtChar(')', true)) break;
                System.out.println("scanning enum values - error missing ')'");
                break;
            }
            if (sp.lookingAtSpace(true)) {
                sp.skipPastSpaces();
            }
            prevNodeOffset = sp.getCurrentOffset();
        }
        return enumList;
    }

    public String scanDefaultAttValue(StringParser sp) {
        String value = null;
        sp.skipPastSpaces();
        boolean single = sp.lookingAtChar('\'', true);
        if (!single && !sp.lookingAtChar('\"', true)) {
            return value;
        }
        char qchar = single ? (char)'\'' : '\"';
        int sOffset = sp.getCurrentOffset();
        sp.skipToChar(qchar, true);
        int len = sp.getCurrentOffset() - sOffset - 1;
        value = len == 0 ? "" : sp.getString(sOffset, len);
        return value;
    }

    public EntityDecl scanEntityDecl() {
        int len;
        this.prevNodeOffset = 1;
        this.nodeOffset = 1;
        boolean isPEDecl = false;
        EntityDecl entityDecl = null;
        String name = null;
        String ndata = null;
        if (this.contentString.lookingAtSpace(true)) {
            this.contentString.skipPastSpaces();
            if (!this.contentString.lookingAtChar('%', true)) {
                isPEDecl = false;
            } else if (this.contentString.lookingAtSpace(true)) {
                isPEDecl = true;
            }
            this.prevNodeOffset = this.contentString.getCurrentOffset();
            this.contentString.skipPastName(' ');
            this.nodeOffset = this.contentString.getCurrentOffset();
            len = this.nodeOffset - this.prevNodeOffset;
            if (len > 0) {
                name = this.contentString.getString(this.prevNodeOffset, len);
                this.prevNodeOffset = this.nodeOffset;
            }
        }
        if (name == null) {
            return null;
        }
        this.contentString.skipPastSpaces();
        this.prevNodeOffset = this.contentString.getCurrentOffset();
        boolean single = this.contentString.lookingAtChar('\'', true);
        if (single || this.contentString.lookingAtChar('\"', true)) {
            String value = this.scanEntityValue(single);
            entityDecl = new EntityDecl(name, this.ownerDTD, value, isPEDecl);
        } else {
            ExternalID xID = this.scanExternalID();
            if (xID != null) {
                if (!isPEDecl) {
                    boolean unparsed = false;
                    this.contentString.skipPastSpaces();
                    unparsed = this.contentString.skippedString(ndata_string);
                    if (unparsed) {
                        this.contentString.skipPastSpaces();
                        this.prevNodeOffset = this.contentString.getCurrentOffset();
                        this.contentString.skipPastName(' ');
                        this.nodeOffset = this.contentString.getCurrentOffset();
                        len = this.nodeOffset - this.prevNodeOffset;
                        ndata = this.contentString.getString(this.prevNodeOffset, len);
                    }
                }
                entityDecl = new EntityDecl(name, this.ownerDTD, xID, isPEDecl, ndata);
            }
        }
        return entityDecl;
    }

    public NotationDecl scanNotationDecl() {
        this.prevNodeOffset = 1;
        this.nodeOffset = 1;
        NotationDecl notationDecl = null;
        String name = null;
        if (this.contentString.lookingAtSpace(true)) {
            this.contentString.skipPastSpaces();
            this.prevNodeOffset = this.contentString.getCurrentOffset();
            this.contentString.skipPastName(' ');
            this.nodeOffset = this.contentString.getCurrentOffset();
            int len = this.nodeOffset - this.prevNodeOffset;
            if (len > 0) {
                name = this.contentString.getString(this.prevNodeOffset, len);
                this.prevNodeOffset = this.nodeOffset;
            }
        }
        if (name == null) {
            return null;
        }
        this.contentString.skipPastSpaces();
        this.prevNodeOffset = this.contentString.getCurrentOffset();
        notationDecl = new NotationDecl(name, this.ownerDTD);
        ExternalID xID = this.scanExternalID();
        if (xID != null) {
            if (xID.getSystemLiteral() != null) {
                notationDecl.setSystemId(xID.getSystemLiteral());
            }
            if (xID.getPubIdLiteral() != null) {
                notationDecl.setPublicId(xID.getPubIdLiteral());
            }
        }
        return notationDecl;
    }

    private String scanEntityValue(boolean single) {
        char qchar = single ? (char)'\'' : '\"';
        this.prevNodeOffset = this.contentString.getCurrentOffset();
        this.contentString.skipToChar(qchar, false);
        int len = this.contentString.getCurrentOffset() - this.prevNodeOffset;
        String value = this.contentString.getString(this.prevNodeOffset, len);
        return value;
    }

    private ExternalID scanExternalID() {
        ExternalID xID = null;
        char qchar = '\"';
        if (this.contentString.skippedString(system_string)) {
            if (!this.contentString.lookingAtSpace(true)) {
                return null;
            }
            this.contentString.skipPastSpaces();
            if (this.contentString.lookingAtChar('\'', true)) {
                qchar = '\'';
            } else if (this.contentString.lookingAtChar('\"', true)) {
                qchar = '\"';
            }
            this.prevNodeOffset = this.contentString.getCurrentOffset();
            this.contentString.skipToChar(qchar, true);
            int len = this.contentString.getCurrentOffset() - this.prevNodeOffset - 1;
            String systemId = this.contentString.getString(this.prevNodeOffset, len);
            xID = new ExternalID(systemId);
        } else if (this.contentString.skippedString(public_string)) {
            if (!this.contentString.lookingAtSpace(true)) {
                return null;
            }
            this.contentString.skipPastSpaces();
            if (this.contentString.lookingAtChar('\'', true)) {
                qchar = '\'';
            } else if (this.contentString.lookingAtChar('\"', true)) {
                qchar = '\"';
            }
            this.prevNodeOffset = this.contentString.getCurrentOffset();
            this.contentString.skipToChar(qchar, true);
            int len = this.contentString.getCurrentOffset() - this.prevNodeOffset - 1;
            String publicId = this.contentString.getString(this.prevNodeOffset, len);
            this.contentString.skipPastSpaces();
            if (this.contentString.lookingAtChar('\'', true)) {
                qchar = '\'';
            } else if (this.contentString.lookingAtChar('\"', true)) {
                qchar = '\"';
            }
            this.prevNodeOffset = this.contentString.getCurrentOffset();
            this.contentString.skipToChar(qchar, true);
            len = this.contentString.getCurrentOffset() - this.prevNodeOffset - 1;
            if (len > 0) {
                String systemId = this.contentString.getString(this.prevNodeOffset, len);
                xID = new ExternalID(publicId, systemId);
            } else {
                xID = new ExternalID(publicId, null);
            }
        }
        return xID;
    }

    String scanPublicID() {
        String pID = null;
        if (this.contentString.skippedString(public_string)) {
            if (!this.contentString.lookingAtSpace(true)) {
                return pID;
            }
            this.contentString.skipPastSpaces();
            this.prevNodeOffset = this.contentString.getCurrentOffset();
            this.contentString.skipToChar(' ', true);
            int len = this.contentString.getCurrentOffset() - this.prevNodeOffset;
            pID = this.contentString.getString(this.prevNodeOffset, len);
        }
        return pID;
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.exit(1);
        }
        DTDScanner sc = new DTDScanner("hello.dtd", " gif SYSTEM \"GIF File\" ");
        NotationDecl n = sc.scanNotationDecl();
        System.out.println("Noation Name: " + n.getNodeName());
        System.out.println("SystemId: " + n.getSystemId());
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }
}

