/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class HTMLPrinter {
    private static RGB BG_COLOR_RGB;

    static {
        block3: {
            BG_COLOR_RGB = null;
            final Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                try {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            BG_COLOR_RGB = display.getSystemColor(29).getRGB();
                        }
                    });
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 45) break block3;
                    throw sWTError;
                }
            }
        }
    }

    private HTMLPrinter() {
    }

    private static String replace(String string, char c, String string2) {
        int n = 0;
        int n2 = string.indexOf(c, n);
        if (n2 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string2);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String convertToHTMLContent(String string) {
        string = HTMLPrinter.replace(string, '&', "&amp;");
        string = HTMLPrinter.replace(string, '\"', "&quot;");
        string = HTMLPrinter.replace(string, '<', "&lt;");
        return HTMLPrinter.replace(string, '>', "&gt;");
    }

    public static String read(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        try {
            int n = reader.read(cArray);
            while (n > 0) {
                stringBuffer.append(cArray, 0, n);
                n = reader.read(cArray);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n, RGB rGB, URL uRL) {
        if (rGB == null) {
            HTMLPrinter.insertPageProlog(stringBuffer, n, uRL);
        } else {
            StringBuffer stringBuffer2 = new StringBuffer(300);
            stringBuffer2.append("<html>");
            HTMLPrinter.appendStyleSheetURL(stringBuffer2, uRL);
            stringBuffer2.append("<body text=\"#000000\" bgcolor=\"");
            HTMLPrinter.appendColor(stringBuffer2, rGB);
            stringBuffer2.append("\"><font size=-1>");
            stringBuffer.insert(n, stringBuffer2.toString());
        }
    }

    public static void insertStyles(StringBuffer stringBuffer, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer(10 * stringArray.length);
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            stringBuffer2.append(" style=\"");
            stringBuffer2.append(stringArray[n]);
            stringBuffer2.append('\"');
            ++n;
        }
        n = stringBuffer.indexOf("<body ");
        if (n == -1) {
            return;
        }
        stringBuffer.insert(n + 5, (Object)stringBuffer2);
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n, RGB rGB) {
        if (rGB == null) {
            HTMLPrinter.insertPageProlog(stringBuffer, n);
        } else {
            StringBuffer stringBuffer2 = new StringBuffer(60);
            stringBuffer2.append("<html><body text=\"#000000\" bgcolor=\"");
            HTMLPrinter.appendColor(stringBuffer2, rGB);
            stringBuffer2.append("\"><font size=-1>");
            stringBuffer.insert(n, stringBuffer2.toString());
        }
    }

    private static void appendStyleSheetURL(StringBuffer stringBuffer, URL uRL) {
        if (uRL == null) {
            return;
        }
        stringBuffer.append("<head>");
        stringBuffer.append("<LINK REL=\"stylesheet\" HREF= \"");
        stringBuffer.append(uRL);
        stringBuffer.append("\" CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        stringBuffer.append("</head>");
    }

    private static void appendColor(StringBuffer stringBuffer, RGB rGB) {
        stringBuffer.append('#');
        stringBuffer.append(Integer.toHexString(rGB.red));
        stringBuffer.append(Integer.toHexString(rGB.green));
        stringBuffer.append(Integer.toHexString(rGB.blue));
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n) {
        HTMLPrinter.insertPageProlog(stringBuffer, n, HTMLPrinter.getBgColor());
    }

    public static void insertPageProlog(StringBuffer stringBuffer, int n, URL uRL) {
        HTMLPrinter.insertPageProlog(stringBuffer, n, HTMLPrinter.getBgColor(), uRL);
    }

    private static RGB getBgColor() {
        if (BG_COLOR_RGB != null) {
            return BG_COLOR_RGB;
        }
        return new RGB(255, 255, 225);
    }

    public static void addPageProlog(StringBuffer stringBuffer) {
        HTMLPrinter.insertPageProlog(stringBuffer, stringBuffer.length());
    }

    public static void addPageEpilog(StringBuffer stringBuffer) {
        stringBuffer.append("</font></body></html>");
    }

    public static void startBulletList(StringBuffer stringBuffer) {
        stringBuffer.append("<ul>");
    }

    public static void endBulletList(StringBuffer stringBuffer) {
        stringBuffer.append("</ul>");
    }

    public static void addBullet(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<li>");
            stringBuffer.append(string);
            stringBuffer.append("</li>");
        }
    }

    public static void addSmallHeader(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<h5>");
            stringBuffer.append(string);
            stringBuffer.append("</h5>");
        }
    }

    public static void addParagraph(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append("<p>");
            stringBuffer.append(string);
        }
    }

    public static void addParagraph(StringBuffer stringBuffer, Reader reader) {
        if (reader != null) {
            HTMLPrinter.addParagraph(stringBuffer, HTMLPrinter.read(reader));
        }
    }
}

