/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class RelativeLayout
implements LayoutManager {
    protected int reqWid;
    protected int reqHgt;
    protected int curWid;
    protected int curHgt;
    protected List<Tracker> curComps = new ArrayList<Tracker>();

    public RelativeLayout(int wid, int ht) {
        this.reqWid = wid;
        this.reqHgt = ht;
    }

    public void addLayoutComponent(String name, Component comp) {
        StringTokenizer st = new StringTokenizer(name, ",");
        int x = Integer.parseInt(st.nextToken());
        int y = Integer.parseInt(st.nextToken());
        this.addLayoutComponent(comp, new Dimension(x, y));
    }

    public void addLayoutComponent(Component comp, Object constraint) {
        Dimension d = (Dimension)constraint;
        int x = d.width;
        int y = d.height;
        Tracker t = new Tracker(x, y, comp);
        this.curComps.add(t);
    }

    public void layoutContainer(Container target) {
        Dimension targSize = target.getSize();
        Insets ins = target.getInsets();
        this.curWid = targSize.width;
        this.curHgt = targSize.height;
        float widRatio = (float)this.curWid / (float)this.reqWid;
        float hgtRatio = (float)this.curHgt / (float)this.reqHgt;
        int i = 0;
        while (i < this.curComps.size()) {
            Tracker t = this.curComps.get(i);
            Component tc = t.getComponent();
            Dimension d = tc.getPreferredSize();
            int px = ins.right + (int)((float)t.getRequestedLoc().x * widRatio);
            int py = ins.top + (int)((float)t.getRequestedLoc().y * hgtRatio);
            int pw = d.width;
            int ph = d.height;
            tc.setBounds(px, py, pw, ph);
            ++i;
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        int minw = 0;
        int minh = 0;
        int i = 0;
        while (i < this.curComps.size()) {
            Tracker t = this.curComps.get(i);
            Component tc = t.getComponent();
            Dimension d = tc.getMinimumSize();
            Point rl = t.getRequestedLoc();
            minw = Math.max(minw, rl.x + d.width);
            minh = Math.max(minh, rl.y + d.height);
            ++i;
        }
        return new Dimension(minw, minw);
    }

    public Dimension preferredLayoutSize(Container target) {
        int prefw = 0;
        int prefh = 0;
        int i = 0;
        while (i < this.curComps.size()) {
            Tracker t = this.curComps.get(i);
            Component tc = t.getComponent();
            Dimension d = tc.getMinimumSize();
            Point rl = t.getRequestedLoc();
            prefw = Math.max(prefw, rl.x + d.width);
            prefh = Math.max(prefh, rl.y + d.height);
            ++i;
        }
        return new Dimension(prefw, prefh);
    }

    public void removeLayoutComponent(Component c) {
        this.curComps.remove(c);
    }

    static class Tracker {
        int absx;
        int absy;
        Component theComp;

        Tracker(int x, int y, Component c) {
            this.absx = x;
            this.absy = y;
            this.theComp = c;
        }

        public Point getRequestedLoc() {
            return new Point(this.absx, this.absy);
        }

        public Component getComponent() {
            return this.theComp;
        }
    }
}

