/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.layout.ArchitectLayout;
import ca.sqlpower.architect.layout.LayoutNode;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.LayoutAnimator;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

public class AutoLayoutAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(AutoLayoutAction.class);
    private PlayPen pp;
    private boolean animationEnabled = true;
    private ArchitectLayout layout;
    private int framesPerSecond = 25;

    public AutoLayoutAction() {
        super("Auto Layout", ASUtils.createIcon("AutoLayout", "Automatic Table Layout", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "Automatic Layout");
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            this.layout = (ArchitectLayout)this.layout.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.layout != null) {
            List<TablePane> tablePanes = new ArrayList<TablePane>(this.pp.getSelectedTables());
            ArrayList<TablePane> notLaidOut = new ArrayList<TablePane>(this.pp.getTablePanes());
            notLaidOut.removeAll(tablePanes);
            Point layoutAreaOffset = new Point();
            if (tablePanes.size() == 0 || tablePanes.size() == 1) {
                tablePanes = this.pp.getTablePanes();
            } else if (tablePanes.size() != this.pp.getTablePanes().size()) {
                int maxWidth = 0;
                for (LayoutNode layoutNode : notLaidOut) {
                    int width = layoutNode.getWidth() + layoutNode.getX();
                    if (width <= maxWidth) continue;
                    maxWidth = width;
                }
                layoutAreaOffset = new Point(maxWidth, 0);
            }
            List<Relationship> relationships = this.pp.getRelationships();
            logger.debug((Object)("About to do layout. tablePanes=" + tablePanes));
            logger.debug((Object)("About to do layout. relationships=" + relationships));
            Rectangle layoutArea = new Rectangle(layoutAreaOffset, this.layout.getNewArea(tablePanes));
            this.layout.setup(tablePanes, relationships, layoutArea);
            LayoutAnimator layoutAnimator = new LayoutAnimator(this.pp, this.layout);
            layoutAnimator.setAnimationEnabled(this.animationEnabled);
            layoutAnimator.setFramesPerSecond(this.framesPerSecond);
            layoutAnimator.startAnimation();
        }
    }

    public void setPlayPen(PlayPen pp) {
        this.pp = pp;
    }

    public PlayPen getPlayPen() {
        return this.pp;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
    }

    public ArchitectLayout getLayout() {
        return this.layout;
    }

    public void setLayout(ArchitectLayout layout) {
        this.layout = layout;
    }
}

