/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.ProfileSettings;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProfileResult<T extends SQLObject>
implements Comparable<AbstractProfileResult>,
ProfileResult<T> {
    private T profiledObject;
    private long createEndTime = -1L;
    private long createStartTime = -1L;
    private Exception ex;
    private ProfileSettings settings;
    private int progress = 0;
    private Integer jobSize = null;
    private String message = null;
    private boolean started = false;
    private boolean cancelled = false;
    private boolean finished = false;

    public AbstractProfileResult(T profiledObject) {
        if (profiledObject == null) {
            throw new NullPointerException("The profiled object has to be non-null");
        }
        this.profiledObject = profiledObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populate() {
        try {
            this.message = ((SQLObject)this.getProfiledObject()).getName();
            if (!this.cancelled) {
                this.initialize();
                this.doProfile();
            }
        }
        catch (Exception ex) {
            this.setException(ex);
            ex.printStackTrace();
        }
        finally {
            this.finish();
            ++this.progress;
        }
    }

    public abstract void doProfile() throws SQLException, ArchitectException;

    void initialize() {
        this.started = true;
        this.finished = false;
        this.setCreateStartTime(System.currentTimeMillis());
    }

    public void finish(long endTime) {
        this.setCreateEndTime(endTime);
        this.finished = true;
    }

    void finish() {
        this.finish(System.currentTimeMillis());
    }

    @Override
    public T getProfiledObject() {
        return this.profiledObject;
    }

    @Override
    public long getCreateStartTime() {
        return this.createStartTime;
    }

    public void setCreateStartTime(long createStartTime) {
        this.createStartTime = createStartTime;
    }

    @Override
    public long getTimeToCreate() {
        return this.createEndTime - this.createStartTime;
    }

    public void setCreateEndTime(long createEndTime) {
        this.createEndTime = createEndTime;
    }

    @Override
    public long getCreateEndTime() {
        return this.createEndTime;
    }

    @Override
    public Exception getException() {
        return this.ex;
    }

    protected void setException(Exception ex) {
        this.ex = ex;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public synchronized Integer getJobSize() {
        return this.jobSize;
    }

    @Override
    public synchronized String getMessage() {
        return this.message;
    }

    @Override
    public synchronized int getProgress() {
        return this.progress;
    }

    @Override
    public synchronized boolean hasStarted() {
        return this.started;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished;
    }

    @Override
    public final int compareTo(AbstractProfileResult o) {
        T po = this.getProfiledObject();
        T opo = o.getProfiledObject();
        SQLObject so1 = ArchitectUtils.getAncestor(po, SQLDatabase.class);
        SQLObject so2 = ArchitectUtils.getAncestor(opo, SQLDatabase.class);
        int diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = ArchitectUtils.getAncestor(po, SQLCatalog.class);
        so2 = ArchitectUtils.getAncestor(opo, SQLCatalog.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = ArchitectUtils.getAncestor(po, SQLSchema.class);
        so2 = ArchitectUtils.getAncestor(opo, SQLSchema.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = ArchitectUtils.getAncestor(po, SQLTable.class);
        so2 = ArchitectUtils.getAncestor(opo, SQLTable.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        so1 = ArchitectUtils.getAncestor(po, SQLColumn.class);
        so2 = ArchitectUtils.getAncestor(opo, SQLColumn.class);
        diff = so1 == null && so2 != null ? -1 : (so1 != null && so2 == null ? 1 : (so1 != null && so2 != null ? so1.getName().compareTo(so2.getName()) : 0));
        if (diff != 0) {
            return diff;
        }
        if (this.createEndTime > o.createEndTime) {
            return 1;
        }
        if (this.createEndTime < o.createEndTime) {
            return -1;
        }
        if (this.createStartTime > o.createStartTime) {
            return 1;
        }
        if (this.createStartTime < o.createStartTime) {
            return -1;
        }
        return 0;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof AbstractProfileResult)) {
            return false;
        }
        AbstractProfileResult o = (AbstractProfileResult)obj;
        return this.compareTo(o) == 0;
    }

    public final int hashCode() {
        int hash = 17;
        T po = this.getProfiledObject();
        SQLObject so = ArchitectUtils.getAncestor(po, SQLDatabase.class);
        if (so != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = ArchitectUtils.getAncestor(po, SQLCatalog.class)) != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = ArchitectUtils.getAncestor(po, SQLSchema.class)) != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = ArchitectUtils.getAncestor(po, SQLTable.class)) != null) {
            hash *= so.getName().hashCode();
        }
        if ((so = ArchitectUtils.getAncestor(po, SQLColumn.class)) != null) {
            hash *= so.getName().hashCode();
        }
        hash = (int)((long)hash * this.createEndTime);
        hash = (int)((long)hash * this.createStartTime);
        return hash;
    }

    public ProfileSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ProfileSettings settings) {
        this.settings = settings;
    }
}

