# NOTE: Derived from lib/Zoidberg/Fish/Log.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Zoidberg::Fish::Log;

#line 308 "lib/Zoidberg/Fish/Log.pm (autosplit into blib/lib/auto/Zoidberg/Fish/Log/fc.al)"
sub fc {
	my $self = shift;
	my ($opt, $args) = getopt 'reverse,-r editor,-e$ list,-l nonu,-n -s -* +* @', @_;
	unshift @$args, grep /^[+-]\d+$/, @{$$opt{_opts}} if exists $$opt{_opts};
	my @replace = split('=', shift(@$args), 2) if $$args[0] =~ /=/;
	error 'to many arguments' if @$args > 2;
	my ($first, $last) = @$args;

	# get selection
	if (!$first) { ($first,$last) = $$opt{list} ? (-16, -1) : (-1, -1) }
	elsif (!$last) { $last = $$opt{list} ? '-1' : $first }

	# list history ?
	my @hist_opts = map "--$_", grep $$opt{$_}, qw/nonu reverse/;
	return $$self{shell}->builtin('history', @hist_opts, $first, $last) if $$opt{list};

	# get/edit commands
	my $cmd = join "\n", 
		@{ $$self{shell}->builtin('history', @hist_opts, $first, $last) };
	$cmd =~ s{\Q$replace[0]\E}{$replace[1]}g if @replace;
	my $editor = $$opt{editor} || $ENV{FCEDIT} || $ENV{EDITOR} || 'vi';
	unless ($$opt{'-s'} or $editor eq '-') {
		# edit history - editor behaviour consistent with T:RL:Z
		debug "going to edit: << '...'\n$cmd\n...\nwith: $editor";
		eval 'require File::Temp' || error 'need File::Temp from CPAN';
		my ($fh, $file) = File::Temp::tempfile(
			'Zoid_fc_XXXXX', DIR => File::Spec->tmpdir );
		print {$fh} $cmd;
		close $fh;
		$$self{shell}->shell($editor.' '.$file);
		error if $@;
		open TMP, $file or error "Could not read $file";
		my $cmd = join '', <TMP>;
		close TMP;
		unlink $file;
	}
	else { debug "going to execute without editing: << '...'\n$cmd\n..." }

	# execute commands
	$$self{shell}->shell($cmd) if length $cmd;
	$$self{shell}{previous_cmd} = $cmd; # reset string to be logged

	#  TODO inherit environment and redirection from self
}

1;
# end of Zoidberg::Fish::Log::fc
