/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xmlrpc.AuthDemo;
import org.apache.xmlrpc.AuthenticationFailed;
import org.apache.xmlrpc.Base64;
import org.apache.xmlrpc.Echo;
import org.apache.xmlrpc.ServerInputStream;
import org.apache.xmlrpc.SystemHandler;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcServer;

public class WebServer
implements Runnable {
    protected XmlRpcServer xmlrpc;
    protected ServerSocket serverSocket;
    protected Thread listener;
    protected Vector accept;
    protected Vector deny;
    protected Stack threadpool;
    protected ThreadGroup runners;
    private InetAddress address;
    private int port;
    private boolean paranoid;
    protected static final byte[] ctype = WebServer.toHTTPBytes("Content-Type: text/xml\r\n");
    protected static final byte[] clength = WebServer.toHTTPBytes("Content-Length: ");
    protected static final byte[] newline = WebServer.toHTTPBytes("\r\n");
    protected static final byte[] doubleNewline = WebServer.toHTTPBytes("\r\n\r\n");
    protected static final byte[] conkeep = WebServer.toHTTPBytes("Connection: Keep-Alive\r\n");
    protected static final byte[] conclose = WebServer.toHTTPBytes("Connection: close\r\n");
    protected static final byte[] ok = WebServer.toHTTPBytes(" 200 OK\r\n");
    protected static final byte[] server = WebServer.toHTTPBytes("Server: Apache XML-RPC 1.0\r\n");
    protected static final byte[] wwwAuthenticate = WebServer.toHTTPBytes("WWW-Authenticate: Basic realm=XML-RPC\r\n");
    private static final String HTTP_11 = "HTTP/1.1";
    private static final String STAR = "*";
    static /* synthetic */ Class class$org$apache$xmlrpc$WebServer;
    static /* synthetic */ Class class$java$lang$Math;

    public static void main(String[] stringArray) {
        int n = WebServer.determinePort(stringArray, 8080);
        XmlRpc.setKeepAlive(true);
        WebServer webServer = new WebServer(n);
        try {
            webServer.addDefaultHandlers();
            webServer.start();
        }
        catch (Exception exception) {
            System.err.println("Error running web server");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    protected static int determinePort(String[] stringArray, int n) {
        int n2 = n;
        if (stringArray.length > 0) {
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing port number: " + stringArray[0]);
                System.err.println("Usage: java " + (class$org$apache$xmlrpc$WebServer == null ? (class$org$apache$xmlrpc$WebServer = WebServer.class$("org.apache.xmlrpc.WebServer")) : class$org$apache$xmlrpc$WebServer).getName() + " [port]");
                System.exit(1);
            }
        }
        return n2;
    }

    public WebServer(int n) {
        this(n, null);
    }

    public WebServer(int n, InetAddress inetAddress) {
        this(n, inetAddress, new XmlRpcServer());
    }

    public WebServer(int n, InetAddress inetAddress, XmlRpcServer xmlRpcServer) {
        this.address = inetAddress;
        this.port = n;
        this.xmlrpc = xmlRpcServer;
        this.accept = new Vector();
        this.deny = new Vector();
        this.threadpool = new Stack();
        this.runners = new ThreadGroup("XML-RPC Runner");
    }

    protected static final byte[] toHTTPBytes(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException.getMessage() + ": HTTP requires US-ASCII encoding");
        }
    }

    protected ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws Exception {
        return new ServerSocket(n, n2, inetAddress);
    }

    private synchronized void setupServerSocket(int n) throws Exception {
        int n2 = 1;
        while (this.serverSocket == null) {
            try {
                this.serverSocket = this.createServerSocket(this.port, n, this.address);
            }
            catch (BindException bindException) {
                if (n2 == 10) {
                    throw bindException;
                }
                ++n2;
                Thread.sleep(1000L);
            }
        }
        if (XmlRpc.debug) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Opened XML-RPC server socket for ");
            stringBuffer.append(this.address != null ? this.address.getHostName() : "localhost");
            stringBuffer.append(':').append(this.port);
            if (n2 > 1) {
                stringBuffer.append(" after ").append(n2).append(" tries");
            }
            System.out.println(stringBuffer.toString());
        }
        if (this.serverSocket.getSoTimeout() <= 0) {
            this.serverSocket.setSoTimeout(4096);
        }
    }

    public void start() {
        if (this.listener == null) {
            this.listener = new Thread((Runnable)this, "XML-RPC Weblistener");
            this.listener.start();
        }
    }

    public void addHandler(String string, Object object) {
        this.xmlrpc.addHandler(string, object);
    }

    protected void addDefaultHandlers() throws Exception {
        this.addHandler("string", "Welcome to XML-RPC!");
        this.addHandler("math", class$java$lang$Math == null ? (class$java$lang$Math = WebServer.class$("java.lang.Math")) : class$java$lang$Math);
        this.addHandler("auth", new AuthDemo());
        this.addHandler("$default", new Echo());
        String string = "http://www.mailtothefuture.com:80/RPC2";
        this.addHandler("mttf", new XmlRpcClient(string));
        this.addHandler("system", new SystemHandler(this.xmlrpc));
    }

    public void removeHandler(String string) {
        this.xmlrpc.removeHandler(string);
    }

    public void setParanoid(boolean bl) {
        this.paranoid = bl;
    }

    public void acceptClient(String string) throws IllegalArgumentException {
        try {
            AddressMatcher addressMatcher = new AddressMatcher(string);
            this.accept.addElement(addressMatcher);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("\"" + string + "\" does not represent a valid IP address");
        }
    }

    public void denyClient(String string) throws IllegalArgumentException {
        try {
            AddressMatcher addressMatcher = new AddressMatcher(string);
            this.deny.addElement(addressMatcher);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("\"" + string + "\" does not represent a valid IP address");
        }
    }

    protected boolean allowConnection(Socket socket) {
        AddressMatcher addressMatcher;
        int n;
        if (!this.paranoid) {
            return true;
        }
        int n2 = this.deny.size();
        byte[] byArray = socket.getInetAddress().getAddress();
        for (n = 0; n < n2; ++n) {
            addressMatcher = (AddressMatcher)this.deny.elementAt(n);
            if (!addressMatcher.matches(byArray)) continue;
            return false;
        }
        n2 = this.accept.size();
        for (n = 0; n < n2; ++n) {
            addressMatcher = (AddressMatcher)this.accept.elementAt(n);
            if (!addressMatcher.matches(byArray)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkSocket(Socket socket) {
        return this.allowConnection(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block33: {
            try {
                this.setupServerSocket(50);
            }
            catch (Exception var1_1) {
                this.listener = null;
                var1_1.printStackTrace();
                throw new RuntimeException(var1_1.getMessage());
            }
            block20: while (true) {
                try {
                    try {}
                    catch (Exception var1_6) {
                        System.err.println("Error accepting XML-RPC connections (" + var1_6 + ").");
                        if (XmlRpc.debug) {
                            var1_6.printStackTrace();
                        }
                        var4_10 = null;
                        if (this.serverSocket != null) {
                            try {
                                this.serverSocket.close();
                                if (XmlRpc.debug) {
                                    System.out.print("Closed XML-RPC server socket");
                                }
                                this.serverSocket = null;
                            }
                            catch (IOException var5_13) {
                                var5_13.printStackTrace();
                            }
                        }
                        if (this.runners == null) return;
                        var5_13 = this.runners;
                        this.runners = null;
                        try {
                            var5_13.interrupt();
                            return;
                        }
                        catch (Exception var6_16) {
                            System.err.println(var6_16);
                            var6_16.printStackTrace();
                            return;
                        }
                    }
                }
                catch (Throwable var3_18) {
                    block32: {
                        var4_11 = null;
                        if (this.serverSocket != null) {
                            ** try [egrp 5[TRYBLOCK] [9 : 244->273)] { 
lbl43:
                            // 1 sources

                            this.serverSocket.close();
                            if (XmlRpc.debug) {
                                System.out.print("Closed XML-RPC server socket");
                            }
                            this.serverSocket = null;
                            break block32;
lbl48:
                            // 1 sources

                            catch (IOException var5_14) {
                                var5_14.printStackTrace();
                            }
                        }
                    }
                    if (this.runners == null) throw var3_18;
                    var5_14 = this.runners;
                    this.runners = null;
                    ** try [egrp 6[TRYBLOCK] [10 : 298->306)] { 
lbl55:
                    // 1 sources

                    var5_14.interrupt();
                    throw var3_18;
lbl57:
                    // 1 sources

                    catch (Exception var6_17) {
                        System.err.println(var6_17);
                        var6_17.printStackTrace();
                    }
                    throw var3_18;
                }
                while (this.listener != null) {
                    try {
                        var1_2 = this.serverSocket.accept();
                        try {
                            var1_2.setTcpNoDelay(true);
                        }
                        catch (SocketException var2_8) {
                            System.err.println(var2_8);
                        }
                        if (this.allowConnection(var1_2)) {
                            var2_7 = this.getRunner();
                            var2_7.handle(var1_2);
                            continue block20;
                        }
                        var1_2.close();
                    }
                    catch (InterruptedIOException var1_3) {
                    }
                    catch (Exception var1_4) {
                        System.err.println("Exception in XML-RPC listener loop (" + var1_4 + ").");
                        if (!XmlRpc.debug) continue;
                        var1_4.printStackTrace();
                    }
                    catch (Error var1_5) {
                        System.err.println("Error in XML-RPC listener loop (" + var1_5 + ").");
                        var1_5.printStackTrace();
                    }
                }
                break;
            }
            var4_9 = null;
            if (this.serverSocket != null) {
                ** try [egrp 5[TRYBLOCK] [9 : 244->273)] { 
lbl90:
                // 1 sources

                this.serverSocket.close();
                if (XmlRpc.debug) {
                    System.out.print("Closed XML-RPC server socket");
                }
                this.serverSocket = null;
                break block33;
lbl95:
                // 1 sources

                catch (IOException var5_12) {
                    var5_12.printStackTrace();
                }
            }
        }
        if (this.runners == null) return;
        var5_12 = this.runners;
        this.runners = null;
        try {}
        catch (Exception var6_15) {
            System.err.println(var6_15);
            var6_15.printStackTrace();
            return;
        }
        var5_12.interrupt();
    }

    public synchronized void shutdown() {
        if (this.listener != null) {
            Thread thread = this.listener;
            this.listener = null;
            thread.interrupt();
        }
    }

    protected Runner getRunner() {
        try {
            return (Runner)this.threadpool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            if (this.runners.activeCount() > 255) {
                throw new RuntimeException("System overload");
            }
            return new Runner();
        }
    }

    void releaseRunner(Runner runner) {
        this.threadpool.push(runner);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AddressMatcher {
        int[] pattern = new int[4];

        public AddressMatcher(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() != 4) {
                throw new Exception("\"" + string + "\" does not represent a valid IP address");
            }
            for (int i = 0; i < 4; ++i) {
                String string2 = stringTokenizer.nextToken();
                this.pattern[i] = WebServer.STAR.equals(string2) ? 256 : (int)((byte)Integer.parseInt(string2));
            }
        }

        public boolean matches(byte[] byArray) {
            for (int i = 0; i < 4; ++i) {
                if (this.pattern[i] > 255 || this.pattern[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }
    }

    class Connection
    implements Runnable {
        private Socket socket;
        private BufferedInputStream input;
        private BufferedOutputStream output;
        private String user;
        private String password;
        byte[] buffer;

        public Connection(Socket socket) throws IOException {
            socket.setSoTimeout(30000);
            this.socket = socket;
            this.input = new BufferedInputStream(socket.getInputStream());
            this.output = new BufferedOutputStream(socket.getOutputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block23: {
                boolean bl = false;
                do {
                    Object object;
                    this.user = null;
                    this.password = null;
                    String string = this.readLine();
                    if (string != null && string.length() == 0) {
                        string = this.readLine();
                    }
                    if (XmlRpc.debug) {
                        System.out.println(string);
                    }
                    int n = -1;
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    boolean bl2 = bl = XmlRpc.getKeepAlive() && WebServer.HTTP_11.equals(string4);
                    do {
                        if ((string = this.readLine()) == null) continue;
                        if (XmlRpc.debug) {
                            System.out.println(string);
                        }
                        if (((String)(object = string.toLowerCase())).startsWith("content-length:")) {
                            n = Integer.parseInt(string.substring(15).trim());
                        }
                        if (((String)object).startsWith("connection:")) {
                            boolean bl3 = bl = XmlRpc.getKeepAlive() && ((String)object).indexOf("keep-alive") > -1;
                        }
                        if (!((String)object).startsWith("authorization: basic ")) continue;
                        this.parseAuth(string);
                    } while (string != null && string.length() != 0);
                    if ("POST".equalsIgnoreCase(string2)) {
                        object = new ServerInputStream(this.input, n);
                        try {
                            byte[] byArray = WebServer.this.xmlrpc.execute((InputStream)object, this.user, this.password);
                            this.writeResponse(byArray, string4, bl);
                        }
                        catch (AuthenticationFailed authenticationFailed) {
                            bl = false;
                            this.writeUnauthorized(string4, string2);
                        }
                    } else {
                        bl = false;
                        this.writeBadRequest(string4, string2);
                    }
                    this.output.flush();
                } while (bl);
                Object var11_12 = null;
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                    break block23;
                }
                catch (IOException iOException) {}
                break block23;
                {
                    catch (Exception exception) {
                        System.err.println(exception);
                        if (XmlRpc.debug) {
                            exception.printStackTrace();
                        }
                        Object var11_13 = null;
                        try {
                            if (this.socket != null) {
                                this.socket.close();
                            }
                            break block23;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    try {
                        if (this.socket != null) {
                            this.socket.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        private String readLine() throws IOException {
            int n;
            if (this.buffer == null) {
                this.buffer = new byte[2048];
            }
            int n2 = 0;
            while ((n = this.input.read()) >= 0 && n != 10) {
                if (n != 13) {
                    this.buffer[n2++] = (byte)n;
                }
                if (n2 < this.buffer.length) continue;
                throw new IOException("HTTP Header too long");
            }
            return new String(this.buffer, 0, n2);
        }

        private void parseAuth(String string) {
            try {
                byte[] byArray = Base64.decode(WebServer.toHTTPBytes(string.substring(21)));
                String string2 = new String(byArray);
                int n = string2.indexOf(58);
                this.user = string2.substring(0, n);
                this.password = string2.substring(n + 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void writeResponse(byte[] byArray, String string, boolean bl) throws IOException {
            this.output.write(WebServer.toHTTPBytes(string));
            this.output.write(ok);
            this.output.write(server);
            this.output.write(bl ? conkeep : conclose);
            this.output.write(ctype);
            this.output.write(clength);
            this.output.write(WebServer.toHTTPBytes(Integer.toString(byArray.length)));
            this.output.write(doubleNewline);
            this.output.write(byArray);
        }

        private void writeBadRequest(String string, String string2) throws IOException {
            this.output.write(WebServer.toHTTPBytes(string));
            this.output.write(WebServer.toHTTPBytes(" 400 Bad Request"));
            this.output.write(newline);
            this.output.write(server);
            this.output.write(newline);
            this.output.write(WebServer.toHTTPBytes("Method " + string2 + " not implemented (try POST)"));
        }

        private void writeUnauthorized(String string, String string2) throws IOException {
            this.output.write(WebServer.toHTTPBytes(string));
            this.output.write(WebServer.toHTTPBytes(" 401 Unauthorized"));
            this.output.write(newline);
            this.output.write(server);
            this.output.write(wwwAuthenticate);
            this.output.write(newline);
            this.output.write(WebServer.toHTTPBytes("Method " + string2 + " requires a " + "valid user name and password"));
        }
    }

    class Runner
    implements Runnable {
        Thread thread;
        Connection con;
        int count;

        Runner() {
        }

        public synchronized void handle(Socket socket) throws IOException {
            this.con = new Connection(socket);
            this.count = 0;
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread(WebServer.this.runners, this);
                this.thread.start();
            } else {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.con != null && Thread.currentThread() == this.thread) {
                this.con.run();
                ++this.count;
                this.con = null;
                if (this.count > 200 || WebServer.this.threadpool.size() > 20) {
                    return;
                }
                Runner runner = this;
                synchronized (runner) {
                    WebServer.this.releaseRunner(this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

