<?php
require_once("class_session.inc");
require_once("class_layout.inc");

$layouts = array();

/* generate single host layouts */
if (isset($symon['host_layouts']) &&
    ($symon['host_layouts'] > 0)) {
    $layout_hosts = array();
    $host_dir = dir($symon['host_tree']);
    while ($host = $host_dir->read()) {
        if ($host != "." &&
            $host != ".." &&
            is_dir($symon['host_tree']."/".$host)) {
            $layout_hosts[] = $host;
        }
    }
    sort($layout_hosts);
    $layouts = array_merge($layouts, $layout_hosts);
}
/* layouts from disk */
if (isset($symon['layout_dir'])) {
    $layout_files = array();
    $layout_dir = dir($symon['layout_dir']);
    while ($layout = $layout_dir->read()) {
	$file_layout = $symon['layout_dir'].'/'.$layout;
	$extension = get_extension($layout);
	$layout = basename($layout, '.layout');
	if (is_file($file_layout) && $extension == 'layout') {
            $layout_files[] = $layout;
	}
    }
    sort($layout_files);
    $layouts = array_merge($layouts, $layout_files);
}

if (count($layouts) > 0) {
    foreach ($layouts as $layout) {
        $symon['defaults']['layout']['namedvalues'][$layout] = $layout;
    }

    if (isset($symon['isolate_hosts']) &&
        ($symon['isolate_hosts'] == 0))
        $symon['defaults']['layout']['namedvalues']['default'] = 'default';
    else {
        unset($symon['defaults']['layout']['namedvalues']['default']);
        $symon['defaults']['layout']['default'] = $layout_hosts[0];
    }
}

$session->load();
$layout = $session->get("layout");
$hidden = '';
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
<html>
<head>
 <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
 <title>symon statistics</title>
 <link rel="stylesheet" href="symon.css" type="text/css" />
</head>

<body bgcolor="#ffffff">
<table width="100%">
<tr>
 <td><img src="symon.png" width="149" alt="[symon]" /></td>
 <td width="100%">
  <form action="index.php" method="post">
   <input type="hidden" name="action" value="view">
   <table align="right" class="controls">
    <tr>
<?php
    if (count($layouts) > 0) {
?>
     <td class="boldright">layout</td>
     <td>
      <select size=1 name="layout">
<?php	$session->printoptions('layout',
	    $symon['defaults']['layout']['namedvalues']); ?>
      </select>
     </td>
<?php   } ?>
    <td class="boldright">timespan</td>
    <td>
     <select size=1 name="timespan">
<?php	$values = array();

	foreach ($symon['defaults']['timespan']['namedvalues'] as
	    $key => $value) {
		$values[$key] = $key;
	}

	$session->printoptions('timespan', $values); ?>
     </select>
    </td>

    <td class="boldright">size</td>
    <td>
     <select size=1 name="size">
<?php	$values = array();

	foreach ($symon['defaults']['size']['namedvalues'] as $key => $value) {
		$values[$key] = $key;
	}

	$session->printoptions('size', $values); ?>
     </select>
    </td>

    <td><input type="submit" value="redraw"></td>
  </tr>
<?php
	if ($session->get('timespan') == 'custom') { ?>
  <tr>
    <td>&nbsp;</td>
    <td class="boldright">timespan:</td>
    <td class="boldright">start</td>
    <td><input type="text" size=10 name="start" value="<?php
    		echo $session->get("start") ?>"></td>
    <td class="boldright">end</td>
    <td><input type="text" size=10 name="end" value="<?php
		echo $session->get("end") ?>"></td>
  </tr>
<?php
	} else {
		$hidden = '<input type="hidden" name="start" value="' .
		    $session->get("start") . '">' . "\n" .
		    '<input type="hidden" name="end" value="' .
		    $session->get("end") . '">';
	}

	if ($session->get('size') == 'custom') { ?>
  <tr>
    <td>&nbsp;</td>
    <td class="boldright">size:</td>
    <td class="boldright">width</td>
    <td><input type="text" size=10 name="width" value="<?php
		echo $session->get("width") ?>"></td>
    <td class="boldright">heigth</td>
    <td><input type="text" size=10 name="heigth" value="<?php
		echo $session->get("heigth") ?>"></td>
  </tr>
<?php
	} else {
		$hidden .= '<input type="hidden" name="width" value="' .
		    $session->get("width") . '">' . "\n" .
		    '<input type="hidden" name="heigth" value="' .
		    $session->get("heigth") . '">';
	}

        if ($session->get("split"))
            echo '<input type="hidden" name="split" value="'.$session->get("split").'">';
        if ($session->get("grep"))
            echo '<input type="hidden" name="grep" value="'.$session->get("grep").'">';

	if ($hidden) {
		echo $hidden;
	}
?>
   </table>
  </form>
 </td>
</tr>
</table>

<?php
   $l = new Layout($layout, $session->get('grep'));

	// get machines
	$gts = $l->getgrouptitles();

	$n = count($gts);

	if ($n > 1) {
		echo '<div class="groups" width="100%">', "\n";

		for ($i = 0; $i < $n; $i++) {
			echo '<a href="index.php#' . $gts[$i] . '">' .
			    $gts[$i] . '</a>';

			if ($i != $n - 1) {
				echo ' || ';
			}
		}

		echo "</div>\n";
	}
?>

<?php
	$l->render($session);
?>
</body>
</html>
