import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, Distribution, build_po

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)

setup(name='elisa-plugin-poblesec',
    version='0.19',
    description='Poblesec frontend',
    long_description='The poblesec frontend.',
    license='GPL3',
    author='Moovida Developers',
    author_email='elisa@lists.fluendo.com',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.conf', 'data/*.xml', 'widgets/data/*.png',
                       'widgets/piece_panels/*/*/*.png', 'widgets/piece_panels/*/*/*/*.png',
                       'widgets/player/*.png', 'widgets/keyboard/*.png', 'widgets/keyboard/*/*/*.png',
                       'theme/*.png', 'theme/*/*.png', 'theme/*/*/*.png',
                       'theme/*/*/*/*.png'],
                  'elisa.plugins.poblesec.i18n': ['*.po', '*/LC_MESSAGES/*.mo', '*.pot'],
                 },
    controller_mappings=[('/poblesec',
                          'elisa.plugins.poblesec.main:PoblesecController'),
                         ('/poblesec/browser',
                          'elisa.plugins.poblesec.poblesec_browser_controller:PoblesecBrowserController'),
                         ('/poblesec/video_player',
                          'elisa.plugins.poblesec.player_video:VideoPlayerController'),
                         ('/poblesec/music_player',
                          'elisa.plugins.poblesec.player_audio:AudioPlayerController'),
                         ('/poblesec/slideshow_player',
                          'elisa.plugins.poblesec.slideshow.player:SlideshowController'),
                         ('/poblesec/sections_menu',
                          'elisa.plugins.poblesec.sections_menu:SectionsMenuController'),

                         ('/poblesec/music_menu',
                          'elisa.plugins.poblesec.sections_menu:SectionController'),
                         ('/poblesec/movie_menu',
                          'elisa.plugins.poblesec.sections_menu:SectionController'),
                         ('/poblesec/pictures_menu',
                          'elisa.plugins.poblesec.sections_menu:SectionController'),
                         ('/poblesec/tv_menu',
                          'elisa.plugins.poblesec.sections_menu:SectionController'),
                         ('/poblesec/internet_menu',
                          'elisa.plugins.poblesec.sections_menu:SectionController'),
                         ('/poblesec/settings_menu',
                          'elisa.plugins.poblesec.sections_menu:SectionController'),
                         ('/poblesec/plugins_menu',
                          'elisa.plugins.poblesec.sections_menu:SectionController'),
                         ('/poblesec/devices_and_shares_menu',
                          'elisa.plugins.poblesec.sections_menu:SectionController'),

                         ('/poblesec/music/internet',
                          'elisa.plugins.poblesec.plugins:InternetMediaController'),
                         ('/poblesec/video/internet',
                          'elisa.plugins.poblesec.plugins:InternetMediaController'),
                         ('/poblesec/pictures/internet',
                          'elisa.plugins.poblesec.plugins:InternetMediaController'),
                         ('/poblesec/radio/internet',
                          'elisa.plugins.poblesec.plugins:InternetMediaController'),

                         ('/poblesec/devices',
                          'elisa.plugins.poblesec.section:HardwareListControllerMixin'),
                         ('/poblesec/this_computer',
                          'elisa.plugins.poblesec.directory_settings:ThisComputerPreviewListController'),
                         ('/poblesec/network/shares',
                          'elisa.plugins.poblesec.network:NetworkSharesList'),
                         ('/poblesec/media_sources',
                          'elisa.plugins.poblesec.directory_settings:MediaSourcesPreviewListController'),

                         ('/poblesec/settings/directory_settings',
                          'elisa.plugins.poblesec.directory_settings:ComputerDirectoryList'),
                         ('/poblesec/settings/plugins',
                          'elisa.plugins.poblesec.plugins_settings:PluginsMenuController'),

                         ('/poblesec/plugins/find',
                          'elisa.plugins.poblesec.plugins:FindNewPluginsController'),
                         ('/poblesec/plugins/library',
                          'elisa.plugins.poblesec.plugins:PluginLibraryController'),
                         ('/poblesec/plugins/updates',
                          'elisa.plugins.poblesec.plugins:PluginUpdatesController'),
                         ('/poblesec/plugins/information',
                          'elisa.plugins.poblesec.plugins:PluginInformationController'),

                         ('/poblesec/directory_settings',
                          'elisa.plugins.poblesec.directory_settings:DirectorySettingsPreviewListController'),
                         ('/poblesec/filesystem',
                          'elisa.plugins.poblesec.filesystem:FilesystemListSwitcherController'),
                         ('/poblesec/network',
                          'elisa.plugins.poblesec.network:NetworkListSwitcherController'),

                         ('/poblesec/modal_popup',
                          'elisa.plugins.poblesec.modal_popup:ModalPopupController'),

                         ('/poblesec/search/.*',
                          'elisa.plugins.poblesec.search_controller:SearchController'),
                         ],
    decorator_mappings=[('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.moblin:moblin_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.plugins:plugins_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.internet:internet_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.video:tv_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.pictures:pictures_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.video:movie_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.music:music_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.section:devices_and_shares_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.settings:settings_decorator'),

                        ('/poblesec/music_menu',
                         'elisa.plugins.database.playlists_controller:music_playlists_decorator'),
                        ('/poblesec/music_menu',
                         'elisa.plugins.poblesec.music:genres_decorator'),
                        ('/poblesec/music_menu',
                         'elisa.plugins.poblesec.music:tracks_decorator'),
                        ('/poblesec/music_menu',
                         'elisa.plugins.poblesec.music:artists_decorator'),
                        ('/poblesec/music_menu',
                         'elisa.plugins.poblesec.music:search_decorator'),
                        ('/poblesec/music_menu',
                         'elisa.plugins.poblesec.music:music_lib_decorator'),

                        ('/poblesec/movie_menu',
                         'elisa.plugins.poblesec.video:unclassified_videos_decorator'),
                        ('/poblesec/movie_menu',
                         'elisa.plugins.database.playlists_controller:movie_playlists_decorator'),
                        ('/poblesec/movie_menu',
                         'elisa.plugins.poblesec.video:movie_lib_decorator'),

                        ('/poblesec/pictures_menu',
                         'elisa.plugins.poblesec.pictures:photo_date_decorator'),
                        ('/poblesec/pictures_menu',
                         'elisa.plugins.poblesec.pictures:photo_albums_decorator'),
                        ('/poblesec/pictures_menu',
                         'elisa.plugins.poblesec.pictures:photo_lib_decorator'),

                        ('/poblesec/tv_menu',
                         'elisa.plugins.poblesec.video:unclassified_videos_decorator'),
                        ('/poblesec/tv_menu',
                         'elisa.plugins.database.playlists_controller:tv_playlists_decorator'),
                        ('/poblesec/tv_menu',
                         'elisa.plugins.poblesec.video:tv_lib_decorator'),

                        ('/poblesec/internet_menu',
                         'elisa.plugins.poblesec.internet:internet_radio_decorator'),
                        ('/poblesec/internet_menu',
                         'elisa.plugins.poblesec.internet:internet_images_decorator'),
                        ('/poblesec/internet_menu',
                         'elisa.plugins.poblesec.internet:internet_music_decorator'),
                        ('/poblesec/internet_menu',
                         'elisa.plugins.poblesec.internet:internet_video_decorator'),

                        ('/poblesec/settings_menu',
                         'elisa.plugins.poblesec.settings:plugins_settings_decorator'),

                        ('/poblesec/plugins_menu',
                         'elisa.plugins.poblesec.plugins:plugin_updates_decorator'),
                        ('/poblesec/plugins_menu',
                         'elisa.plugins.poblesec.plugins:find_new_plugins_decorator'),
                        ('/poblesec/plugins_menu',
                         'elisa.plugins.poblesec.plugins:plugin_library_decorator'),

                        ('/poblesec/devices_and_shares_menu',
                         'elisa.plugins.poblesec.section:media_decorator'),
                        ('/poblesec/devices_and_shares_menu',
                         'elisa.plugins.poblesec.section:network_decorator'),
                        ('/poblesec/devices_and_shares_menu',
                         'elisa.plugins.poblesec.section:filesystem_decorator'),
                        ('/poblesec/devices_and_shares_menu',
                         'elisa.plugins.poblesec.section:devices_decorator'),
                        ('/poblesec/devices',
                         'elisa.plugins.poblesec.section:hardware_decorator'),

                        ('/poblesec/slideshow_player',
                         'elisa.plugins.poblesec.slideshow.transition_slideshow:register_slideshows'),

                        # FIXME: the following decorators should not be here
                        # but in their respective plugins ; this works around
                        # an ordering issue.
                        ('/poblesec/search/music',
                         'elisa.plugins.database.music_controller:music_search_result_decorator'),

                        ('/poblesec/browser',
                         'elisa.plugins.poblesec.scanning_widget:scanning_decorator'),
                       ],
    cmdclass=cmdclass,
    distclass=Distribution)
