# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

"""
Mathematics facilities module
"""

import math

PI, PI2 = math.pi, math.pi/2.0


def clamp(x, low, high):
    """Clamp a value in the range [low, high].
    """
    return max(low, min(high, x))


def lerp(a, b, factor):
    """Linear interpolation applied on a number.
    """
    return clamp(factor, 0.0, 1.0) * (b - a) + a

def serp(a, b, factor):
    """Sinusoidal interpolation applied on a number.
    """
    return math.sin(clamp(factor, 0.0, 1.0)*PI2) * (b - a) + a

def lerp_seq(seq_a, seq_b, factor):
    """Linear interpolation applied on sequence like list or tuple.

    @param seq_a:  DOCME
    @type seq_a:   C{list} or C{tuple} of C{float}
    @param seq_b:  DOCME
    @type seq_b:   C{list} or C{tuple} of C{float}
    @param factor: DOCME
    @type factor:  C{float}

    @rtype: C{tuple} of C{float}
    """
    f = clamp(factor, 0.0, 1.0)
    return tuple([f * (b - a) + a for a, b in zip(seq_a, seq_b)])
