# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
# Authors: Alessandro Decina <alessandro@fluendo.com>

import dbus
import dbus.service

class DBusFrontend(dbus.service.Object):
    interface = 'com.fluendo.Elisa.Plugins.Pigment.Frontend'
    
    def __init__(self, frontend, *args, **kw):
        dbus.service.Object.__init__(self, *args, **kw)
        self.frontend = frontend

    @dbus.service.method(dbus_interface=interface,
            in_signature='', out_signature='') 
    def show(self):
        self.frontend.show()

    @dbus.service.method(dbus_interface=interface,
            in_signature='', out_signature='') 
    def hide(self):
        self.frontend.hide()
