# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>
#


from elisa.core.components.model import Model

class NetworkOverviewModel(Model):
    """
    This model is a container for a list of domains discovered on the
    network.

    @ivar domains: the domain names. You now can access a domain with
                    C{network://<domain_name>}
    @type domains: C{list} of C{unicode}
    """
    def __init__(self):
        super(NetworkOverviewModel, self).__init__()
        self.domains = []


class DomainModel(Model):
    """
    This is representation of what you can find on one certain domain in the
    local network. An example request is C{network://local}.

    A DomainModel is only created once for each Domain found.

    @ivar name:     the name of this domain
    @type name:     C{unicode}
    @ivar services: found in this domain (removed and appended in background)
    @type services: C{list} of L{elisa.plugins.base.models.network.NetworkServicesModel}s
    """
    def __init__(self):
        super(DomainModel, self).__init__()
        self.name = None
        self.services = []
