/*
 * Galago Person API
 *
 * Copyright (C) 2004-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_PERSON_H_
#define _GALAGO_PERSON_H_

typedef struct _GalagoPerson        GalagoPerson;
typedef struct _GalagoPersonClass   GalagoPersonClass;
typedef struct _GalagoPersonPrivate GalagoPersonPrivate;

#include <libgalago/galago-account.h>
#include <libgalago/galago-image.h>
#include <libgalago/galago-object.h>
#include <libgalago/galago-service.h>

struct _GalagoPerson
{
	GalagoObject parent_object;

	GalagoPersonPrivate *priv;

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

struct _GalagoPersonClass
{
	GalagoObjectClass parent_class;

	/* Signals */
	void (*account_added)(GalagoPerson *person, GalagoAccount *account);
	void (*account_removed)(GalagoPerson *person, GalagoAccount *account);
	void (*photo_set)(GalagoPerson *person, GalagoImage *photo);

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

#define GALAGO_TYPE_PERSON (galago_person_get_type())
#define GALAGO_PERSON(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_TYPE_PERSON, GalagoPerson))
#define GALAGO_PERSON_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_TYPE_PERSON, \
								 GalagoPersonClass))
#define GALAGO_IS_PERSON(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_TYPE_PERSON))
#define GALAGO_IS_PERSON_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_TYPE_PERSON))
#define GALAGO_PERSON_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS((obj), GALAGO_TYPE_PERSON, \
								   GalagoPersonClass))

#define GALAGO_DBUS_PERSON_INTERFACE "org.freedesktop.Galago.Person"

G_BEGIN_DECLS

/**************************************************************************/
/** Common Attribute Definitions                                          */
/**************************************************************************/

#define GALAGO_PERSON_ATTR_UID          "uid"
#define GALAGO_PERSON_ATTR_FIRST_NAME   "first-name"
#define GALAGO_PERSON_ATTR_MIDDLE_NAME  "middle-name"
#define GALAGO_PERSON_ATTR_LAST_NAME    "last-name"
#define GALAGO_PERSON_ATTR_ADDRESS      "address"
#define GALAGO_PERSON_ATTR_CITY         "city"
#define GALAGO_PERSON_ATTR_STATE        "state"
#define GALAGO_PERSON_ATTR_COUNTRY      "country"
#define GALAGO_PERSON_ATTR_ZIPCODE      "zipcode"


/**************************************************************************/
/** Person API                                                            */
/**************************************************************************/

GType galago_person_get_type(void);

void galago_person_set_me(GalagoPerson *person);
gboolean galago_person_is_me(const GalagoPerson *person);

const char *galago_person_get_id(const GalagoPerson *person);
const char *galago_person_get_session_id(const GalagoPerson *person);
const char *galago_person_get_display_name(const GalagoPerson *person);

void galago_person_set_photo(GalagoPerson *person, GalagoImage *photo);
GalagoImage *galago_person_get_photo(const GalagoPerson *person,
									 gboolean query);

gboolean galago_person_has_accounts(const GalagoPerson *person,
									gboolean query);
GList *galago_person_get_accounts(const GalagoPerson *person, gboolean query);

GalagoAccount *galago_person_get_priority_account(const GalagoPerson *person);
GalagoAccount *galago_person_get_account(const GalagoPerson *person,
										 const GalagoService *service,
										 const char *username,
										 gboolean query);

G_END_DECLS

#endif /* _GALAGO_PERSON_H_ */
