require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&IOAPIC_BASE_DEFAULT)) {
    sub IOAPIC_BASE_DEFAULT () {	0xfec00000;}
}
unless(defined(&IOAPIC_REG)) {
    sub IOAPIC_REG () {	0x;}
}
unless(defined(&IOAPIC_DATA)) {
    sub IOAPIC_DATA () {	0x10;}
}
unless(defined(&IOAPIC_ID)) {
    sub IOAPIC_ID () {	0x;}
}
unless(defined(&IOAPIC_ID_SHIFT)) {
    sub IOAPIC_ID_SHIFT () {	24;}
}
unless(defined(&IOAPIC_ID_MASK)) {
    sub IOAPIC_ID_MASK () {	0xf000000;}
}
unless(defined(&IOAPIC_VER)) {
    sub IOAPIC_VER () {	0x1;}
}
unless(defined(&IOAPIC_VER_SHIFT)) {
    sub IOAPIC_VER_SHIFT () {	0;}
}
unless(defined(&IOAPIC_VER_MASK)) {
    sub IOAPIC_VER_MASK () {	0xff;}
}
unless(defined(&IOAPIC_MAX_SHIFT)) {
    sub IOAPIC_MAX_SHIFT () {	16;}
}
unless(defined(&IOAPIC_MAX_MASK)) {
    sub IOAPIC_MAX_MASK () {	0xff0000;}
}
unless(defined(&IOAPIC_ARB)) {
    sub IOAPIC_ARB () {	0x2;}
}
unless(defined(&IOAPIC_REDHI)) {
    sub IOAPIC_REDHI {
	my($pin) = @_;
	eval q((0x11 + (($pin)<<1)));
    }
}
unless(defined(&IOAPIC_REDLO)) {
    sub IOAPIC_REDLO {
	my($pin) = @_;
	eval q((0x10 + (($pin)<<1)));
    }
}
unless(defined(&IOAPIC_REDHI_DEST_SHIFT)) {
    sub IOAPIC_REDHI_DEST_SHIFT () {	24;}
}
unless(defined(&IOAPIC_REDHI_DEST_MASK)) {
    sub IOAPIC_REDHI_DEST_MASK () {	0xff000000;}
}
unless(defined(&IOAPIC_REDLO_MASK)) {
    sub IOAPIC_REDLO_MASK () {	0x10000;}
}
unless(defined(&IOAPIC_REDLO_LEVEL)) {
    sub IOAPIC_REDLO_LEVEL () {	0x8000;}
}
unless(defined(&IOAPIC_REDLO_RIRR)) {
    sub IOAPIC_REDLO_RIRR () {	0x4000;}
}
unless(defined(&IOAPIC_REDLO_ACTLO)) {
    sub IOAPIC_REDLO_ACTLO () {	0x2000;}
}
unless(defined(&IOAPIC_REDLO_DELSTS)) {
    sub IOAPIC_REDLO_DELSTS () {	0x1000;}
}
unless(defined(&IOAPIC_REDLO_DSTMOD)) {
    sub IOAPIC_REDLO_DSTMOD () {	0x800;}
}
unless(defined(&IOAPIC_REDLO_DEL_MASK)) {
    sub IOAPIC_REDLO_DEL_MASK () {	0x700;}
}
unless(defined(&IOAPIC_REDLO_DEL_SHIFT)) {
    sub IOAPIC_REDLO_DEL_SHIFT () {	8;}
}
unless(defined(&IOAPIC_REDLO_DEL_FIXED)) {
    sub IOAPIC_REDLO_DEL_FIXED () {	0;}
}
unless(defined(&IOAPIC_REDLO_DEL_LOPRI)) {
    sub IOAPIC_REDLO_DEL_LOPRI () {	1;}
}
unless(defined(&IOAPIC_REDLO_DEL_SMI)) {
    sub IOAPIC_REDLO_DEL_SMI () {	2;}
}
unless(defined(&IOAPIC_REDLO_DEL_NMI)) {
    sub IOAPIC_REDLO_DEL_NMI () {	4;}
}
unless(defined(&IOAPIC_REDLO_DEL_INIT)) {
    sub IOAPIC_REDLO_DEL_INIT () {	5;}
}
unless(defined(&IOAPIC_REDLO_DEL_EXTINT)) {
    sub IOAPIC_REDLO_DEL_EXTINT () {	7;}
}
unless(defined(&IOAPIC_REDLO_VECTOR_MASK)) {
    sub IOAPIC_REDLO_VECTOR_MASK () {	0xff;}
}
unless(defined(&IMCR_ADDR)) {
    sub IMCR_ADDR () {	0x22;}
}
unless(defined(&IMCR_DATA)) {
    sub IMCR_DATA () {	0x23;}
}
unless(defined(&IMCR_REGISTER)) {
    sub IMCR_REGISTER () {	0x70;}
}
unless(defined(&IMCR_PIC)) {
    sub IMCR_PIC () {	0x;}
}
unless(defined(&IMCR_APIC)) {
    sub IMCR_APIC () {	0x1;}
}
if(defined(&_KERNEL)) {
    eval 'sub ioapic_asm_ack {
        my($num) = @_;
	    eval q( &movl $0,( &_C_LABEL( &local_apic)+ &LAPIC_EOI)(% &rip));
    }' unless defined(&ioapic_asm_ack);
    if(defined(&MULTIPROCESSOR)) {
	if(defined(&notyet)) {
	    eval 'sub ioapic_asm_lock {
	        my($num) = @_;
    		eval q( &movl $1,% &esi ;77:  &xchgl % &esi, &PIC_LOCK(% &rdi) ;  &testl % &esi,% &esi ;  &jne 77 &b);
	    }' unless defined(&ioapic_asm_lock);
	    eval 'sub ioapic_asm_unlock {
	        my($num) = @_;
    		eval q( &movl $0, &PIC_LOCK(% &rdi));
	    }' unless defined(&ioapic_asm_unlock);
	} else {
	    eval 'sub ioapic_asm_lock {
	        my($num) = @_;
    		eval q();
	    }' unless defined(&ioapic_asm_lock);
	    eval 'sub ioapic_asm_unlock {
	        my($num) = @_;
    		eval q();
	    }' unless defined(&ioapic_asm_unlock);
	}
    } else {
	eval 'sub ioapic_asm_lock {
	    my($num) = @_;
    	    eval q();
	}' unless defined(&ioapic_asm_lock);
	eval 'sub ioapic_asm_unlock {
	    my($num) = @_;
    	    eval q();
	}' unless defined(&ioapic_asm_unlock);
    }
    eval 'sub ioapic_mask {
        my($num) = @_;
	    eval q( &movq  &IS_PIC(% &r14),% &rdi ;  &ioapic_asm_lock($num) ;  &movl  &IS_PIN(% &r14),% &esi ;  &leaq 0x10(% &rsi,% &rsi,1),% &rsi ;  &movq  &IOAPIC_SC_REG(% &rdi),% &r15 ;  &movl % &esi, (% &r15) ;  &movq  &IOAPIC_SC_DATA(% &rdi),% &r15 ;  &movl (% &r15),% &esi ;  &orl $ &IOAPIC_REDLO_MASK,% &esi ;  &movl % &esi,(% &r15) ;  &ioapic_asm_unlock($num));
    }' unless defined(&ioapic_mask);
    eval 'sub ioapic_unmask {
        my($num) = @_;
	    eval q( &cmpq $ &IREENT_MAGIC,( &TF_ERR+8)(% &rsp) ;  &jne 79 &f ;  &movq  &IS_PIC(% &r14),% &rdi ;  &ioapic_asm_lock($num) ;  &movl  &IS_PIN(% &r14),% &esi ;  &leaq 0x10(% &rsi,% &rsi,1),% &rsi ;  &movq  &IOAPIC_SC_REG(% &rdi),% &r15 ;  &movq  &IOAPIC_SC_DATA(% &rdi),% &r13 ;  &movl % &esi, (% &r15) ;  &movl (% &r13),% &r12d ;  &andl $~ &IOAPIC_REDLO_MASK,% &r12d ;  &movl % &esi,(% &r15) ;  &movl % &r12d,(% &r13) ;  &ioapic_asm_unlock($num) ;79:);
    }' unless defined(&ioapic_unmask);
}
1;
