/*	$OpenBSD: athnreg.h,v 1.6 2010/02/24 19:39:43 damien Exp $	*/

/*-
 * Copyright (c) 2009 Damien Bergamini <damien.bergamini@free.fr>
 * Copyright (c) 2008-2009 Atheros Communications Inc.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#define AR_CR				0x0008
#define AR_RXDP				0x000c
#define AR_CFG				0x0014
#define AR_MIRT				0x0020
#define AR_IER				0x0024
#define AR_TIMT				0x0028
#define AR_RIMT				0x002c
#define AR_TXCFG			0x0030
#define AR_RXCFG			0x0034
#define AR_MIBC				0x0040
#define AR_TOPS				0x0044
#define AR_RXNPTO			0x0048
#define AR_TXNPTO			0x004c
#define AR_RPGTO			0x0050
#define AR_RPCNT			0x0054
#define AR_MACMISC			0x0058
#define AR_GTXTO			0x0064
#define AR_GTTM				0x0068
#define AR_CST				0x006c
#define AR_ISR				0x0080
#define AR_ISR_S0			0x0084
#define AR_ISR_S1			0x0088
#define AR_ISR_S2			0x008c
#define AR_ISR_S3			0x0090
#define AR_ISR_S4			0x0094
#define AR_ISR_S5			0x0098
#define AR_IMR				0x00a0
#define AR_IMR_S0			0x00a4
#define AR_IMR_S1			0x00a8
#define AR_IMR_S2			0x00ac
#define AR_IMR_S3			0x00b0
#define AR_IMR_S4			0x00b4
#define AR_IMR_S5			0x00b8
#define AR_ISR_RAC			0x00c0
#define AR_ISR_S0_S			0x00c4
#define AR_ISR_S1_S			0x00c8
#define AR_ISR_S2_S			0x00cc
#define AR_ISR_S3_S			0x00d0
#define AR_ISR_S4_S			0x00d4
#define AR_ISR_S5_S			0x00d8
#define AR_DMADBG(i)			(0x00e0 + (i) * 4)
#define AR_QTXDP(i)			(0x0800 + (i) * 4)
#define AR_Q_TXE			0x0840
#define AR_Q_TXD			0x0880
#define AR_QCBRCFG(i)			(0x08c0 + (i) * 4)
#define AR_QRDYTIMECFG(i)		(0x0900 + (i) * 4)
#define AR_Q_ONESHOTARM_SC		0x0940
#define AR_Q_ONESHOTARM_CC		0x0980
#define AR_QMISC(i)			(0x09c0 + (i) * 4)
#define AR_QSTS(i)			(0x0a00 + (i) * 4)
#define AR_Q_RDYTIMESHDN		0x0a40
#define AR_DQCUMASK(i)			(0x1000 + (i) * 4)
#define AR_D_GBL_IFS_SIFS		0x1030
#define AR_D_TXBLK_CMD			0x1038
#define AR_DLCL_IFS(i)			(0x1040 + (i) * 4)
#define AR_D_GBL_IFS_SLOT		0x1070
#define AR_DRETRY_LIMIT(i)		(0x1080 + (i) * 4)
#define AR_D_GBL_IFS_EIFS		0x10b0
#define AR_DCHNTIME(i)			(0x10c0 + (i) * 4)
#define AR_D_GBL_IFS_MISC		0x10f0
#define AR_DMISC(i)			(0x1100 + (i) * 4)
#define AR_D_SEQNUM			0x1140
#define AR_D_FPCTL			0x1230
#define AR_D_TXPSE			0x1270
#define AR_D_TXSLOTMASK			0x12f0
#define AR_MAC_SLEEP			0x1f00
#define AR_CFG_LED			0x1f04
#define AR_EEPROM_OFFSET(i)		(0x2000 + (i) * 4)
#define AR_RC				0x4000
#define AR_WA				0x4004
#define AR_PM_STATE			0x4008
#define AR_PCIE_PM_CTRL			0x4014
#define AR_HOST_TIMEOUT			0x4018
#define AR_EEPROM			0x401c
#define AR_SREV				0x4020
#define AR_AHB_MODE			0x4024
#define AR_INTR_SYNC_CAUSE		0x4028
#define AR_INTR_SYNC_ENABLE		0x402c
#define AR_INTR_ASYNC_MASK		0x4030
#define AR_INTR_SYNC_MASK		0x4034
#define AR_INTR_ASYNC_CAUSE		0x4038
#define AR_INTR_ASYNC_ENABLE		0x403c
#define AR_PCIE_SERDES			0x4040
#define AR_PCIE_SERDES2			0x4044
#define AR_GPIO_IN_OUT			0x4048
#define AR_GPIO_OE_OUT			0x404c
#define AR_GPIO_INTR_POL		0x4050
#define AR_GPIO_INPUT_EN_VAL		0x4054
#define AR_GPIO_INPUT_MUX1		0x4058
#define AR_GPIO_INPUT_MUX2		0x405c
#define AR_GPIO_OUTPUT_MUX(i)		(0x4060 + (i) * 4)
#define AR_INPUT_STATE			0x406c
#define AR_EEPROM_STATUS_DATA		0x407c
#define AR_OBS				0x4080
#define AR_GPIO_PDPU			0x4088
#define AR_PCIE_MSI			0x4094
#define AR_RTC_RC			0x7000
#define AR_RTC_PLL_CONTROL		0x7014
#define AR_RTC_RESET			0x7040
#define AR_RTC_STATUS 			0x7044
#define AR_RTC_SLEEP_CLK		0x7048
#define AR_RTC_FORCE_WAKE		0x704c
#define AR_RTC_INTR_CAUSE		0x7050
#define AR_RTC_INTR_ENABLE		0x7054
#define AR_RTC_INTR_MASK		0x7058
#define AR_IS_ANALOG_REG(reg)		((reg) >= 0x7800 && (reg) <= 0x78b4)
#define AR_AN_RF2G1_CH0			0x7810
#define AR_AN_RF5G1_CH0			0x7818
#define AR_AN_RF2G1_CH1			0x7834
#define AR_AN_RF5G1_CH1			0x783c
#define AR_AN_SYNTH9			0x7868
#define AR_AN_TOP1			0x7890
#define AR_AN_TOP2			0x7894
#define AR_STA_ID0			0x8000
#define AR_STA_ID1			0x8004
#define AR_BSS_ID0			0x8008
#define AR_BSS_ID1			0x800c
#define AR_BCN_RSSI_AVE			0x8010
#define AR_TIME_OUT			0x8014
#define AR_RSSI_THR			0x8018
#define AR_USEC				0x801c
#define AR_RESET_TSF			0x8020
#define AR_MAX_CFP_DUR			0x8038
#define AR_RX_FILTER			0x803c
#define AR_MCAST_FIL0			0x8040
#define AR_MCAST_FIL1			0x8044
#define AR_DIAG_SW			0x8048
#define AR_TSF_L32			0x804c
#define AR_TSF_U32			0x8050
#define AR_TST_ADDAC			0x8054
#define AR_DEF_ANTENNA			0x8058
#define AR_AES_MUTE_MASK0		0x805c
#define AR_AES_MUTE_MASK1		0x8060
#define AR_GATED_CLKS			0x8064
#define AR_OBS_BUS_CTRL			0x8068
#define AR_OBS_BUS_1			0x806c
#define AR_LAST_TSTP			0x8080
#define AR_NAV				0x8084
#define AR_RTS_OK			0x8088
#define AR_RTS_FAIL			0x808c
#define AR_ACK_FAIL			0x8090
#define AR_FCS_FAIL			0x8094
#define AR_BEACON_CNT			0x8098
#define AR_SLEEP1			0x80d4
#define AR_SLEEP2			0x80d8
#define AR_BSSMSKL			0x80e0
#define AR_BSSMSKU			0x80e4
#define AR_TPC				0x80e8
#define AR_TFCNT			0x80ec
#define AR_RFCNT			0x80f0
#define AR_RCCNT			0x80f4
#define AR_CCCNT			0x80f8
#define AR_QUIET1			0x80fc
#define AR_QUIET2			0x8100
#define AR_TSF_PARM			0x8104
#define AR_QOS_NO_ACK			0x8108
#define AR_PHY_ERR			0x810c
#define AR_RXFIFO_CFG			0x8114
#define AR_MIC_QOS_CONTROL		0x8118
#define AR_MIC_QOS_SELECT		0x811c
#define AR_PCU_MISC			0x8120
#define AR_FILT_OFDM			0x8124
#define AR_FILT_CCK			0x8128
#define AR_PHY_ERR_1			0x812c
#define AR_PHY_ERR_MASK_1		0x8130
#define AR_PHY_ERR_2			0x8134
#define AR_PHY_ERR_MASK_2		0x8138
#define AR_TSFOOR_THRESHOLD		0x813c
#define AR_PHY_ERR_3			0x8168
#define AR_PHY_ERR_MASK_3		0x816c
#define AR_BT_COEX_MODE			0x8170
#define AR_BT_COEX_WEIGHT		0x8174
#define AR_BT_COEX_MODE2		0x817c
#define AR_NEXT_NDP2_TIMER(i)		(0x8180 + (i) * 4)
#define AR_NDP2_PERIOD(i)		(0x81a0 + (i) * 4)
#define AR_NDP2_TIMER_MODE		0x81c0
#define AR_TXSIFS			0x81d0
#define AR_TXOP_X			0x81ec
#define AR_TXOP_0_3			0x81f0
#define AR_TXOP_4_7			0x81f4
#define AR_TXOP_8_11			0x81f8
#define AR_TXOP_12_15			0x81fc
#define AR_NEXT_TBTT_TIMER		0x8200
#define AR_NEXT_DMA_BEACON_ALERT	0x8204
#define AR_NEXT_CFP			0x8208
#define AR_NEXT_HCF			0x820c
#define AR_NEXT_TIM			0x8210
#define AR_NEXT_DTIM			0x8214
#define AR_NEXT_QUIET_TIMER		0x8218
#define AR_NEXT_NDP_TIMER		0x821c
#define AR_BEACON_PERIOD		0x8220
#define AR_DMA_BEACON_PERIOD		0x8224
#define AR_SWBA_PERIOD			0x8228
#define AR_HCF_PERIOD			0x822c
#define AR_TIM_PERIOD			0x8230
#define AR_DTIM_PERIOD			0x8234
#define AR_QUIET_PERIOD			0x8238
#define AR_NDP_PERIOD			0x823c
#define AR_TIMER_MODE			0x8240
#define AR_SLP32_MODE			0x8244
#define AR_SLP32_WAKE			0x8248
#define AR_SLP32_INC			0x824c
#define AR_SLP_CNT			0x8250
#define AR_SLP_CYCLE_CNT		0x8254
#define AR_SLP_MIB_CTRL			0x8258
#define AR_WOW_PATTERN_REG		0x825c
#define AR_WOW_COUNT_REG		0x8260
#define AR_MAC_PCU_LOGIC_ANALYZER	0x8264
#define AR_WOW_BCN_EN_REG		0x8270
#define AR_WOW_BCN_TIMO_REG		0x8274
#define AR_WOW_KEEP_ALIVE_TIMO_REG	0x8278
#define AR_WOW_KEEP_ALIVE_REG		0x827c
#define AR_WOW_US_SCALAR_REG		0x8284
#define AR_WOW_KEEP_ALIVE_DELAY_REG	0x8288
#define AR_WOW_PATTERN_MATCH_REG	0x828c
#define AR_WOW_PATTERN_OFF1_REG		0x8290
#define AR_WOW_PATTERN_OFF2_REG		0x8294
#define AR_WOW_EXACT_REG		0x829c
#define AR_2040_MODE			0x8318
#define AR_EXTRCCNT			0x8328
#define AR_SELFGEN_MASK			0x832c
#define AR_PCU_TXBUF_CTRL		0x8340
#define AR_PCU_MISC_MODE2		0x8344
#define AR_MAC_PCU_ASYNC_FIFO_REG3	0x8358
#define AR_WOW_LENGTH1_REG		0x8360
#define AR_WOW_LENGTH2_REG		0x8364
#define AR_WOW_PATTERN_MATCH_LT_256B	0x8368
#define AR_RATE_DURATION(i)		(0x8700 + (i) * 4)
#define AR_KEYTABLE(i)			(0x8800 + (i) * 32)
#define AR_KEYTABLE_KEY0(i)		(AR_KEYTABLE(i) +  0)
#define AR_KEYTABLE_KEY1(i)		(AR_KEYTABLE(i) +  4)
#define AR_KEYTABLE_KEY2(i)		(AR_KEYTABLE(i) +  8)
#define AR_KEYTABLE_KEY3(i)		(AR_KEYTABLE(i) + 12)
#define AR_KEYTABLE_KEY4(i)		(AR_KEYTABLE(i) + 16)
#define AR_KEYTABLE_TYPE(i)		(AR_KEYTABLE(i) + 20)
#define AR_KEYTABLE_MAC0(i)		(AR_KEYTABLE(i) + 24)
#define AR_KEYTABLE_MAC1(i)		(AR_KEYTABLE(i) + 28)

/*
 * PHY registers.
 */
#define AR_PHY_BASE			0x9800
#define AR_PHY(i)			(AR_PHY_BASE + (i) * 4)
#define AR_PHY_TEST			0x9800
#define AR_PHY_TURBO			0x9804
#define AR_PHY_TEST2			0x9808
#define AR_PHY_TIMING2			0x9810
#define AR_PHY_TIMING3			0x9814
#define AR_PHY_CHIP_ID			0x9818
#define AR_PHY_ACTIVE			0x981c
#define AR_PHY_RF_CTL2			0x9824
#define AR_PHY_RF_CTL3			0x9828
#define AR_PHY_ADC_CTL			0x982c
#define AR_PHY_ADC_SERIAL_CTL		0x9830
#define AR_PHY_RF_CTL4			0x9834
#define AR_PHY_TSTDAC_CONST		0x983c
#define AR_PHY_SETTLING			0x9844
#define AR_PHY_RXGAIN			0x9848
#define AR_PHY_DESIRED_SZ		0x9850
#define AR_PHY_FIND_SIG			0x9858
#define AR_PHY_AGC_CTL1			0x985c
#define AR_PHY_AGC_CONTROL		0x9860
#define AR_PHY_CCA(i)			(0x9864 + (i) * 0x1000)
#define AR_PHY_SFCORR			0x9868
#define AR_PHY_SFCORR_LOW		0x986c
#define AR_PHY_SLEEP_CTR_CONTROL	0x9870
#define AR_PHY_SLEEP_CTR_LIMIT		0x9874
#define AR_PHY_SLEEP_SCAL		0x9878
#define AR_PHY_PLL_CTL			0x987c
#define	AR_PHY_BIN_MASK_1		0x9900
#define	AR_PHY_BIN_MASK_2		0x9904
#define	AR_PHY_BIN_MASK_3		0x9908
#define	AR_PHY_MASK_CTL			0x990c
#define AR_PHY_RX_DELAY			0x9914
#define AR_PHY_SEARCH_START_DELAY	0x9918
#define AR_PHY_TIMING_CTRL4_0		0x9920
#define AR_PHY_TIMING_CTRL4(i)		(0x9920 + (i) * 0x1000)
#define AR_PHY_TIMING5			0x9924
#define AR_PHY_POWER_TX_RATE1		0x9934
#define AR_PHY_POWER_TX_RATE2		0x9938
#define AR_PHY_POWER_TX_RATE_MAX	0x993c
#define AR_PHY_RADAR_EXT		0x9940
#define AR_PHY_FRAME_CTL		0x9944
#define AR_PHY_SPUR_REG			0x994c
#define AR_PHY_RADAR_0			0x9954
#define AR_PHY_RADAR_1			0x9958
#define AR_PHY_SWITCH_CHAIN_0		0x9960
#define AR_PHY_SWITCH_COM		0x9964
#define AR_PHY_SIGMA_DELTA		0x996c
#define AR_PHY_RESTART			0x9970
#define AR_PHY_RFBUS_REQ		0x997c
#define	AR_PHY_TIMING7			0x9980
#define	AR_PHY_TIMING8			0x9984
#define	AR_PHY_BIN_MASK2_1		0x9988
#define	AR_PHY_BIN_MASK2_2		0x998c
#define	AR_PHY_BIN_MASK2_3		0x9990
#define	AR_PHY_BIN_MASK2_4		0x9994
#define	AR_PHY_TIMING9			0x9998
#define	AR_PHY_TIMING10			0x999c
#define	AR_PHY_TIMING11			0x99a0
#define AR_PHY_RX_CHAINMASK		0x99a4
#define AR_PHY_MULTICHAIN_GAIN_CTL	0x99ac
#define AR_PHY_NEW_ADC_DC_GAIN_CORR(i)	(0x99b4 + (i) * 0x1000)
#define AR_PHY_EXT_CCA0			0x99b8
#define AR_PHY_EXT_CCA(i)		(0x99bc + (i) * 0x1000)
#define AR_PHY_SFCORR_EXT		0x99c0
#define AR_PHY_HALFGI			0x99d0
#define AR_PHY_CHANNEL_MASK_01_30	0x99d4
#define AR_PHY_CHANNEL_MASK_31_60	0x99d8
#define AR_PHY_CHAN_INFO_MEMORY		0x99dc
#define AR_PHY_HEAVY_CLIP_ENABLE	0x99e0
#define AR_PHY_HEAVY_CLIP_FACTOR_RIFS	0x99ec
#define AR_PHY_CALMODE			0x99f0
#define AR_PHY_REFCLKDLY		0x99f4
#define AR_PHY_REFCLKPD			0x99f8
#define AR_PHY_BB_RFGAIN(i)		(0x9a00 + (i) * 4)
#define AR_PHY_CAL_MEAS_0(i)		(0x9c10 + (i) * 0x1000)
#define AR_PHY_CAL_MEAS_1(i)		(0x9c14 + (i) * 0x1000)
#define AR_PHY_CAL_MEAS_2(i)		(0x9c18 + (i) * 0x1000)
#define AR_PHY_CAL_MEAS_3(i)		(0x9c1c + (i) * 0x1000)
#define AR_PHY_CURRENT_RSSI		0x9c1c
#define AR_PHY_RFBUS_GRANT		0x9c20
#define AR9280_PHY_CURRENT_RSSI		0x9c3c
#define AR_PHY_CHAN_INFO_GAIN_DIFF	0x9cf4
#define AR_PHY_CHAN_INFO_GAIN		0x9cfc
#define AR_PHY_MODE			0xa200
#define AR_PHY_CCK_TX_CTRL		0xa204
#define AR_PHY_CCK_DETECT		0xa208
#define AR_PHY_GAIN_2GHZ		0xa20c
#define AR_PHY_CCK_RXCTRL4		0xa21c
#define AR_PHY_DAG_CTRLCCK		0xa228
#define AR_PHY_FORCE_CLKEN_CCK		0xa22c
#define AR_PHY_POWER_TX_RATE3		0xa234
#define AR_PHY_POWER_TX_RATE4		0xa238
#define AR_PHY_SCRM_SEQ_XR		0xa23c
#define AR_PHY_HEADER_DETECT_XR		0xa240
#define AR_PHY_CHIRP_DETECTED_XR	0xa244
#define AR_PHY_BLUETOOTH		0xa254
#define AR_PHY_TPCRG1			0xa258
#define AR_PHY_TX_PWRCTRL4		0xa264
#define AR_PHY_ANALOG_SWAP		0xa268
#define AR_PHY_TPCRG5			0xa26c
#define AR_PHY_TX_PWRCTRL6_0		0xa270
#define AR_PHY_TX_PWRCTRL7		0xa274
#define AR_PHY_TX_PWRCTRL9		0xa27c
#define AR_PHY_PDADC_TBL_BASE		0xa280
#define AR_PHY_TX_GAIN_TBL(i)		(0xa300 + (i) * 4)
#define AR_PHY_CL_CAL_CTL		0xa358
#define AR_PHY_POWER_TX_RATE5		0xa38c
#define AR_PHY_POWER_TX_RATE6		0xa390
#define AR_PHY_CH0_TX_PWRCTRL11		0xa398
#define AR_PHY_CAL_CHAINMASK		0xa39c
#define AR_PHY_VIT_MASK2_M_46_61	0xa3a0
#define AR_PHY_VIT_MASK2_M_31_45	0xa3a4
#define AR_PHY_VIT_MASK2_M_16_30	0xa3a8
#define AR_PHY_VIT_MASK2_M_00_15	0xa3ac
#define AR_PHY_PILOT_MASK_01_30		0xa3b0
#define AR_PHY_PILOT_MASK_31_60		0xa3b4
#define AR_PHY_VIT_MASK2_P_15_01	0xa3b8
#define AR_PHY_VIT_MASK2_P_30_16	0xa3bc
#define AR_PHY_VIT_MASK2_P_45_31	0xa3c0
#define AR_PHY_VIT_MASK2_P_61_46	0xa3c4
#define AR_PHY_POWER_TX_SUB		0xa3c8
#define AR_PHY_POWER_TX_RATE7		0xa3cc
#define AR_PHY_POWER_TX_RATE8		0xa3d0
#define AR_PHY_POWER_TX_RATE9		0xa3d4
#define AR_PHY_XPA_CFG			0xa3d8
#define AR_PHY_TX_PWRCTRL6_1		0xb270
#define AR_PHY_CH1_TX_PWRCTRL11		0xb398

/* Bits for AR_CR. */
#define AR_CR_RXE	0x00000004
#define AR_CR_RXD	0x00000020
#define AR_CR_SWI	0x00000040

/* Bits for AR_CFG. */
#define AR_CFG_SWTD				0x00000001
#define AR_CFG_SWTB				0x00000002
#define AR_CFG_SWRD				0x00000004
#define AR_CFG_SWRB				0x00000008
#define AR_CFG_SWRG				0x00000010
#define AR_CFG_AP_ADHOC_INDICATION		0x00000020
#define AR_CFG_PHOK				0x00000100
#define AR_CFG_EEBS				0x00000200
#define AR_CFG_CLK_GATE_DIS			0x00000400
#define AR_CFG_PCI_MASTER_REQ_Q_THRESH_M	0x00060000
#define AR_CFG_PCI_MASTER_REQ_Q_THRESH_S	17

/* Bits for AR_IER. */
#define AR_IER_ENABLE	0x00000001

/* Bits for AR_TIMT. */
#define AR_TIMT_LAST_M	0x0000ffff
#define AR_TIMT_LAST_S	0
#define AR_TIMT_FIRST_M	0xffff0000
#define AR_TIMT_FIRST_S	16

/* Bits for AR_RIMT. */
#define AR_RIMT_LAST_M	0x0000ffff
#define AR_RIMT_LAST_S	0
#define AR_RIMT_FIRST_M	0xffff0000
#define AR_RIMT_FIRST_S	16

/* Bits for AR_[TR]XCFG_DMASZ fields. */
#define AR_DMASZ_4B	0
#define AR_DMASZ_8B	1
#define AR_DMASZ_16B	2
#define AR_DMASZ_32B	3
#define AR_DMASZ_64B	4
#define AR_DMASZ_128B	5
#define AR_DMASZ_256B	6
#define AR_DMASZ_512B	7

/* Bits for AR_TXCFG. */
#define AR_TXCFG_DMASZ_M			0x00000007
#define AR_TXCFG_DMASZ_S			0
#define AR_TXCFG_FTRIG_M			0x000003f0
#define AR_TXCFG_FTRIG_S			4
#define AR_TXCFG_FTRIG_IMMED			(  0 / 64)
#define AR_TXCFG_FTRIG_64B			( 64 / 64)
#define AR_TXCFG_FTRIG_128B			(128 / 64)
#define AR_TXCFG_FTRIG_192B			(192 / 64)
#define AR_TXCFG_FTRIG_256B			(256 / 64)
#define AR_TXCFG_FTRIG_512B			(512 / 64)
#define AR_TXCFG_ADHOC_BEACON_ATIM_TX_POLICY	0x00000800

/* Bits for AR_RXCFG. */
#define AR_RXCFG_DMASZ_M	0x00000007
#define AR_RXCFG_DMASZ_S	0
#define AR_RXCFG_CHIRP		0x00000008
#define AR_RXCFG_ZLFDMA		0x00000010

/* Bits for AR_MIBC. */
#define AR_MIBC_COW	0x00000001
#define AR_MIBC_FMC	0x00000002
#define AR_MIBC_CMC	0x00000004
#define AR_MIBC_MCS	0x00000008

/* Bits for AR_TOPS. */
#define AR_TOPS_MASK	0x0000ffff

/* Bits for AR_RXNPTO. */
#define AR_RXNPTO_MASK	0x000003ff

/* Bits for AR_TXNPTO. */
#define AR_TXNPTO_MASK		0x000003ff
#define AR_TXNPTO_QCU_MASK	0x000ffc00

/* Bits for AR_RPGTO. */
#define AR_RPGTO_MASK	0x000003ff

/* Bits for AR_RPCNT. */
#define AR_RPCNT_MASK	0x0000001f

/* Bits for AR_MACMISC. */
#define AR_MACMISC_PCI_EXT_FORCE	0x00000010
#define AR_MACMISC_DMA_OBS_M		0x000001e0
#define AR_MACMISC_DMA_OBS_S		5
#define AR_MACMISC_MISC_OBS_M		0x00000e00
#define AR_MACMISC_MISC_OBS_S		9
#define AR_MACMISC_MISC_OBS_BUS_LSB_M	0x00007000
#define AR_MACMISC_MISC_OBS_BUS_LSB_S	12
#define AR_MACMISC_MISC_OBS_BUS_MSB_M	0x00038000
#define AR_MACMISC_MISC_OBS_BUS_MSB_S	15

/* Bits for AR_GTXTO. */
#define AR_GTXTO_TIMEOUT_COUNTER_M	0x0000ffff
#define AR_GTXTO_TIMEOUT_COUNTER_S	0
#define AR_GTXTO_TIMEOUT_LIMIT_M	0xffff0000
#define AR_GTXTO_TIMEOUT_LIMIT_S	16

/* Bits for AR_GTTM. */
#define AR_GTTM_USEC		0x00000001
#define AR_GTTM_IGNORE_IDLE	0x00000002
#define AR_GTTM_RESET_IDLE	0x00000004
#define AR_GTTM_CST_USEC	0x00000008

/* Bits for AR_CST. */
#define AR_CST_TIMEOUT_COUNTER_M	0x0000ffff
#define AR_CST_TIMEOUT_COUNTER_S	0
#define AR_CST_TIMEOUT_LIMIT_M		0xffff0000
#define AR_CST_TIMEOUT_LIMIT_S		16

/* Bits for AR_ISR. */
#define AR_ISR_RXOK	0x00000001
#define AR_ISR_RXDESC	0x00000002
#define AR_ISR_RXERR	0x00000004
#define AR_ISR_RXNOPKT	0x00000008
#define AR_ISR_RXEOL	0x00000010
#define AR_ISR_RXORN	0x00000020
#define AR_ISR_TXOK	0x00000040
#define AR_ISR_TXDESC	0x00000080
#define AR_ISR_TXERR	0x00000100
#define AR_ISR_TXNOPKT	0x00000200
#define AR_ISR_TXEOL	0x00000400
#define AR_ISR_TXURN	0x00000800
#define AR_ISR_MIB	0x00001000
#define AR_ISR_SWI	0x00002000
#define AR_ISR_RXPHY	0x00004000
#define AR_ISR_RXKCM	0x00008000
#define AR_ISR_SWBA	0x00010000
#define AR_ISR_BRSSI	0x00020000
#define AR_ISR_BMISS	0x00040000
#define AR_ISR_TXMINTR	0x00080000
#define AR_ISR_BNR	0x00100000
#define AR_ISR_RXCHIRP	0x00200000
#define AR_ISR_BCNMISC	0x00800000
#define AR_ISR_TIM	0x00800000
#define AR_ISR_RXMINTR	0x01000000
#define AR_ISR_QCBROVF	0x02000000
#define AR_ISR_QCBRURN	0x04000000
#define AR_ISR_QTRIG	0x08000000
#define AR_ISR_GENTMR	0x10000000
#define AR_ISR_TXINTM	0x40000000
#define AR_ISR_RXINTM	0x80000000

/* Bits for AR_ISR_S0. */
#define AR_ISR_S0_QCU_TXOK_M	0x000003ff
#define AR_ISR_S0_QCU_TXOK_S	0
#define AR_ISR_S0_QCU_TXDESC_M	0x03ff0000
#define AR_ISR_S0_QCU_TXDESC_S	16

/* Bits for AR_ISR_S1. */
#define AR_ISR_S1_QCU_TXERR_M	0x000003ff
#define AR_ISR_S1_QCU_TXERR_S	0
#define AR_ISR_S1_QCU_TXEOL_M	0x03ff0000
#define AR_ISR_S1_QCU_TXEOL_S	16

/* Bits for AR_ISR_S2. */
#define AR_ISR_S2_QCU_TXURN_M		0x000003ff
#define AR_ISR_S2_QCU_TXURN_S		0
#define AR_ISR_S2_CST			0x00400000
#define AR_ISR_S2_GTT			0x00800000
#define AR_ISR_S2_TIM			0x01000000
#define AR_ISR_S2_CABEND		0x02000000
#define AR_ISR_S2_DTIMSYNC		0x04000000
#define AR_ISR_S2_BCNTO			0x08000000
#define AR_ISR_S2_CABTO			0x10000000
#define AR_ISR_S2_DTIM			0x20000000
#define AR_ISR_S2_TSFOOR		0x40000000
#define AR_ISR_S2_TBTT_TIME		0x80000000

/* Bits for AR_ISR_S3. */
#define AR_ISR_S3_QCU_QCBROVF_M	0x000003ff
#define AR_ISR_S3_QCU_QCBROVF_S	0
#define AR_ISR_S3_QCU_QCBRURN_M	0x03ff0000
#define AR_ISR_S3_QCU_QCBRURN_S	0

/* Bits for  AR_ISR_S4. */
#define AR_ISR_S4_QCU_QTRIG_M	0x000003ff
#define AR_ISR_S4_QCU_QTRIG_S	0

/* Bits for AR_ISR_S5. */
#define AR_ISR_S5_TIMER_TRIG_M		0x000000ff
#define AR_ISR_S5_TIMER_TRIG_S		0
#define AR_ISR_S5_TIMER_THRESH_M	0x0007fe00
#define AR_ISR_S5_TIMER_THRESH_S	9
#define AR_ISR_S5_TIM_TIMER		0x00000010
#define AR_ISR_S5_DTIM_TIMER		0x00000020
#define AR_ISR_S5_GENTIMER_TRIG_M	0x0000ff80
#define AR_ISR_S5_GENTIMER_TRIG_S	0
#define AR_ISR_S5_GENTIMER_THRESH_M	0xff800000
#define AR_ISR_S5_GENTIMER_THRESH_S	16

/* Bits for AR_IMR. */
#define AR_IMR_RXOK	0x00000001
#define AR_IMR_RXDESC	0x00000002
#define AR_IMR_RXERR	0x00000004
#define AR_IMR_RXNOPKT	0x00000008
#define AR_IMR_RXEOL	0x00000010
#define AR_IMR_RXORN	0x00000020
#define AR_IMR_TXOK	0x00000040
#define AR_IMR_TXDESC	0x00000080
#define AR_IMR_TXERR	0x00000100
#define AR_IMR_TXNOPKT	0x00000200
#define AR_IMR_TXEOL	0x00000400
#define AR_IMR_TXURN	0x00000800
#define AR_IMR_MIB	0x00001000
#define AR_IMR_SWI	0x00002000
#define AR_IMR_RXPHY	0x00004000
#define AR_IMR_RXKCM	0x00008000
#define AR_IMR_SWBA	0x00010000
#define AR_IMR_BRSSI	0x00020000
#define AR_IMR_BMISS	0x00040000
#define AR_IMR_TXMINTR	0x00080000
#define AR_IMR_BNR	0x00100000
#define AR_IMR_RXCHIRP	0x00200000
#define AR_IMR_BCNMISC	0x00800000
#define AR_IMR_TIM	0x00800000
#define AR_IMR_RXMINTR	0x01000000
#define AR_IMR_QCBROVF	0x02000000
#define AR_IMR_QCBRURN	0x04000000
#define AR_IMR_QTRIG	0x08000000
#define AR_IMR_GENTMR	0x10000000
#define AR_IMR_TXINTM	0x40000000
#define AR_IMR_RXINTM	0x80000000

#define AR_IMR_DEFAULT	\
	(AR_IMR_TXERR | AR_IMR_TXURN | AR_IMR_RXERR |	\
	 AR_IMR_RXORN | AR_IMR_BCNMISC | AR_IMR_RXINTM |	\
	 AR_IMR_RXMINTR | AR_IMR_TXOK)
#define AR_IMR_HOSTAP	(AR_IMR_DEFAULT | AR_IMR_MIB)

/* Bits for AR_IMR_S0. */
#define AR_IMR_S0_QCU_TXOK(qid)		(1 << (qid))
#define AR_IMR_S0_QCU_TXDESC(qid)	(1 << (16 + (qid)))

/* Bits for AR_IMR_S1. */
#define AR_IMR_S1_QCU_TXERR(qid)	(1 << (qid))
#define AR_IMR_S1_QCU_TXEOL(qid)	(1 << (16 + (qid)))

/* Bits for AR_IMR_S2. */
#define AR_IMR_S2_QCU_TXURN(qid)	(1 << (qid))
#define AR_IMR_S2_CST			0x00400000
#define AR_IMR_S2_GTT			0x00800000
#define AR_IMR_S2_TIM			0x01000000
#define AR_IMR_S2_CABEND		0x02000000
#define AR_IMR_S2_DTIMSYNC		0x04000000
#define AR_IMR_S2_BCNTO			0x08000000
#define AR_IMR_S2_CABTO			0x10000000
#define AR_IMR_S2_DTIM			0x20000000
#define AR_IMR_S2_TSFOOR		0x40000000

/* Bits for AR_IMR_S3. */
#define AR_IMR_S3_QCU_QCBROVF(qid)	(1 << (qid))
#define AR_IMR_S3_QCU_QCBRURN(qid)	(1 << (16 + (qid)))

/* Bits for AR_IMR_S4. */
#define AR_IMR_S4_QCU_QTRIG(qid)	(1 << (qid))

/* Bits for AR_IMR_S5. */
#define AR_IMR_S5_TIM_TIMER		0x00000010
#define AR_IMR_S5_DTIM_TIMER		0x00000020
#define AR_IMR_S5_TIMER_TRIG_M		0x000000ff
#define AR_IMR_S5_TIMER_TRIG_S		0
#define AR_IMR_S5_TIMER_THRESH_M	0x0000ff00
#define AR_IMR_S5_TIMER_THRESH_S	0

#define AR_NUM_QCU	10
#define AR_QCU(x)	(1 << (x))

/* Bits for AR_Q_TXE. */
#define AR_Q_TXE_M	0x000003ff
#define AR_Q_TXE_S	0

/* Bits for AR_Q_TXD. */
#define AR_Q_TXD_M	0x000003ff
#define AR_Q_TXD_S	0

/* Bits for AR_QCBRCFG_*. */
#define AR_Q_CBRCFG_INTERVAL_M		0x00ffffff
#define AR_Q_CBRCFG_INTERVAL_S		0
#define AR_Q_CBRCFG_OVF_THRESH_M	0xff000000
#define AR_Q_CBRCFG_OVF_THRESH_S	24

/* Bits for AR_Q_RDYTIMECFG_*. */
#define AR_Q_RDYTIMECFG_DURATION_M	0x00ffffff
#define AR_Q_RDYTIMECFG_DURATION_S	0
#define AR_Q_RDYTIMECFG_EN		0x01000000

/* Bits for AR_Q_MISC_*. */
#define AR_Q_MISC_FSP_M			0x0000000f
#define AR_Q_MISC_FSP_S			0
#define AR_Q_MISC_FSP_ASAP		0
#define AR_Q_MISC_FSP_CBR		1
#define AR_Q_MISC_FSP_DBA_GATED		2
#define AR_Q_MISC_FSP_TIM_GATED		3
#define AR_Q_MISC_FSP_BEACON_SENT_GATED	4
#define AR_Q_MISC_FSP_BEACON_RCVD_GATED	5
#define AR_Q_MISC_ONE_SHOT_EN		0x00000010
#define AR_Q_MISC_CBR_INCR_DIS1		0x00000020
#define AR_Q_MISC_CBR_INCR_DIS0		0x00000040
#define AR_Q_MISC_BEACON_USE		0x00000080
#define AR_Q_MISC_CBR_EXP_CNTR_LIMIT_EN	0x00000100
#define AR_Q_MISC_RDYTIME_EXP_POLICY	0x00000200
#define AR_Q_MISC_RESET_CBR_EXP_CTR	0x00000400
#define AR_Q_MISC_DCU_EARLY_TERM_REQ	0x00000800

/* Bits for AR_Q_STS_*. */
#define AR_Q_STS_PEND_FR_CNT_M	0x00000003
#define AR_Q_STS_PEND_FR_CNT_S	0
#define AR_Q_STS_CBR_EXP_CNT_M	0x0000ff00
#define AR_Q_STS_CBR_EXP_CNT_S	8

#define AR_NUM_DCU	10
#define AR_DCU(x)	(1 << (x))

/* Bits for AR_D_QCUMASK_*. */
#define AR_D_QCUMASK_M	0x000003ff
#define AR_D_QCUMASK_S	0

/* Bits for AR_D_GBL_IFS_SIFS. */
#define AR_D_GBL_IFS_SIFS_ASYNC_FIFO_DUR	0x000003ab

/* Bits for AR_D_TXBLK_CMD. */
#define AR_D_TXBLK_WRITE_BITMASK_M	0x0000ffff
#define AR_D_TXBLK_WRITE_BITMASK_S	0
#define AR_D_TXBLK_WRITE_SLICE_M	0x000f0000
#define AR_D_TXBLK_WRITE_SLICE_S	16
#define AR_D_TXBLK_WRITE_DCU_M		0x00f00000
#define AR_D_TXBLK_WRITE_DCU_S		20
#define AR_D_TXBLK_WRITE_COMMAND_M	0x0f000000
#define AR_D_TXBLK_WRITE_COMMAND_S	24

/* Bits for AR_DLCL_IFS. */
#define AR_D_LCL_IFS_CWMIN_M	0x000003ff
#define AR_D_LCL_IFS_CWMIN_S	0
#define AR_D_LCL_IFS_CWMAX_M	0x000ffc00
#define AR_D_LCL_IFS_CWMAX_S	10
#define AR_D_LCL_IFS_AIFS_M	0x0ff00000
#define AR_D_LCL_IFS_AIFS_S	20

/* Bits for AR_D_GBL_IFS_SLOT. */
#define AR_D_GBL_IFS_SLOT_M			0x0000ffff
#define AR_D_GBL_IFS_SLOT_S			0
#define AR_D_GBL_IFS_SLOT_ASYNC_FIFO_DUR	0x00000420

/* Bits for AR_DRETRY_LIMIT_*. */
#define AR_D_RETRY_LIMIT_FR_SH_M	0x0000000f
#define AR_D_RETRY_LIMIT_FR_SH_S	0
#define AR_D_RETRY_LIMIT_STA_SH_M	0x00003f00
#define AR_D_RETRY_LIMIT_STA_SH_S	8
#define AR_D_RETRY_LIMIT_STA_LG_M	0x000fc000
#define AR_D_RETRY_LIMIT_STA_LG_S	14

/* Bits for AR_D_GBL_IFS_EIFS. */
#define AR_D_GBL_IFS_EIFS_M			0x0000ffff
#define AR_D_GBL_IFS_EIFS_S			0
#define AR_D_GBL_IFS_EIFS_ASYNC_FIFO_DUR	0x0000a5eb

/* Bits for AR_DCHNTIME_*. */
#define AR_D_CHNTIME_DUR_M	0x000fffff
#define AR_D_CHNTIME_DUR_S	0
#define AR_D_CHNTIME_EN		0x00100000

/* Bits for AR_D_GBL_IFS_MISC. */
#define AR_D_GBL_IFS_MISC_LFSR_SLICE_SEL	0x00000007
#define AR_D_GBL_IFS_MISC_TURBO_MODE		0x00000008
#define AR_D_GBL_IFS_MISC_USEC_DURATION		0x000ffc00
#define AR_D_GBL_IFS_MISC_DCU_ARBITER_DLY	0x00300000
#define AR_D_GBL_IFS_MISC_RANDOM_LFSR_SLICE_DIS	0x01000000
#define AR_D_GBL_IFS_MISC_SLOT_XMIT_WIND_LEN	0x06000000
#define AR_D_GBL_IFS_MISC_FORCE_XMIT_SLOT_BOUND	0x08000000
#define AR_D_GBL_IFS_MISC_IGNORE_BACKOFF	0x10000000

/* Bits for AR_DMISC_*. */
#define AR_D_MISC_BKOFF_THRESH_M		0x0000003f
#define AR_D_MISC_BKOFF_THRESH_S		0
#define AR_D_MISC_RETRY_CNT_RESET_EN		0x00000040
#define AR_D_MISC_CW_RESET_EN			0x00000080
#define AR_D_MISC_FRAG_WAIT_EN			0x00000100
#define AR_D_MISC_FRAG_BKOFF_EN			0x00000200
#define AR_D_MISC_CW_BKOFF_EN			0x00001000
#define AR_D_MISC_VIR_COL_HANDLING_M		0x0000c000
#define AR_D_MISC_VIR_COL_HANDLING_S		14
#define AR_D_MISC_VIR_COL_HANDLING_DEFAULT	0
#define AR_D_MISC_VIR_COL_HANDLING_IGNORE	1
#define AR_D_MISC_BEACON_USE			0x00010000
#define AR_D_MISC_ARB_LOCKOUT_CNTRL_M		0x00060000
#define AR_D_MISC_ARB_LOCKOUT_CNTRL_S		17
#define AR_D_MISC_ARB_LOCKOUT_CNTRL_NONE	0
#define AR_D_MISC_ARB_LOCKOUT_CNTRL_INTRA_FR	1
#define AR_D_MISC_ARB_LOCKOUT_CNTRL_GLOBAL	2
#define AR_D_MISC_ARB_LOCKOUT_IGNORE		0x00080000
#define AR_D_MISC_SEQ_NUM_INCR_DIS		0x00100000
#define AR_D_MISC_POST_FR_BKOFF_DIS		0x00200000
#define AR_D_MISC_VIT_COL_CW_BKOFF_EN		0x00400000
#define AR_D_MISC_BLOWN_IFS_RETRY_EN		0x00800000

/* Bits for AR_D_FPCTL. */
#define AR_D_FPCTL_DCU_M		0x0000000f
#define AR_D_FPCTL_DCU_S		0
#define AR_D_FPCTL_PREFETCH_EN		0x00000010
#define AR_D_FPCTL_BURST_PREFETCH_M	0x00007fe0
#define AR_D_FPCTL_BURST_PREFETCH_S	5

/* Bits for AR_D_TXPSE. */
#define AR_D_TXPSE_CTRL_M	0x000003ff
#define AR_D_TXPSE_CTRL_S	0
#define AR_D_TXPSE_STATUS	0x00010000

/* Bits for AR_D_TXSLOTMASK. */
#define AR_D_TXSLOTMASK_NUM	0x0000000f

/* Bits for AR_MAC_SLEEP. */
#define AR_MAC_SLEEP_MAC_ASLEEP	0x00000001

/* Bits for AR_CFG_LED. */
#define AR_CFG_SCLK_RATE_IND_M		0x00000003
#define AR_CFG_SCLK_RATE_IND_S		0
#define AR_CFG_SCLK_32MHZ		0
#define AR_CFG_SCLK_4MHZ		1
#define AR_CFG_SCLK_1MHZ		2
#define AR_CFG_SCLK_32KHZ		3
#define AR_CFG_LED_BLINK_SLOW		0x00000008
#define AR_CFG_LED_BLINK_THRESH_SEL_M	0x00000070
#define AR_CFG_LED_BLINK_THRESH_SEL_S	4
#define AR_CFG_LED_MODE_SEL_M		0x00000380
#define AR_CFG_LED_MODE_SEL_S		7
#define AR_CFG_LED_POWER_M		0x00000280
#define AR_CFG_LED_POWER_S		7
#define AR_CFG_LED_NETWORK_M		0x00000300
#define AR_CFG_LED_NETWORK_S		7
#define AR_CFG_LED_MODE_PROP		0
#define AR_CFG_LED_MODE_RPROP		1
#define AR_CFG_LED_MODE_SPLIT		2
#define AR_CFG_LED_MODE_RAND		3
#define AR_CFG_LED_MODE_POWER_OFF	4
#define AR_CFG_LED_MODE_POWER_ON	5
#define AR_CFG_LED_MODE_NETWORK_OFF	4
#define AR_CFG_LED_MODE_NETWORK_ON	6
#define AR_CFG_LED_ASSOC_CTL_M		0x00000c00
#define AR_CFG_LED_ASSOC_CTL_S		10
#define AR_CFG_LED_ASSOC_NONE		0
#define AR_CFG_LED_ASSOC_ACTIVE		1
#define AR_CFG_LED_ASSOC_PENDING	2

/* Bit for AR_RC. */
#define AR_RC_AHB	0x00000001
#define AR_RC_APB	0x00000002
#define AR_RC_HOSTIF	0x00000100

/* Bits for AR_WA. */
#define AR5416_WA_DEFAULT	0x0000073f
#define AR9280_WA_DEFAULT	0x0040073b
#define AR9285_WA_DEFAULT	0x004a05cb
#define AR_WA_UNTIE_RESET_EN	0x00008000
#define AR_WA_RESET_EN		0x00040000
#define AR_WA_ANALOG_SHIFT	0x00100000
#define AR_WA_POR_SHORT		0x00200000

/* Bits for AR_PM_STATE. */
#define AR_PM_STATE_PME_D3COLD_VAUX	0x00100000

/* Bits for AR_PCIE_PM_CTRL. */
#define AR_PCIE_PM_CTRL_ENA	0x00080000

/* Bits for AR_HOST_TIMEOUT. */
#define AR_HOST_TIMEOUT_APB_CNTR_M	0x0000ffff
#define AR_HOST_TIMEOUT_APB_CNTR_S	0
#define AR_HOST_TIMEOUT_LCL_CNTR_M	0xffff0000
#define AR_HOST_TIMEOUT_LCL_CNTR_S	16

/* Bits for AR_EEPROM. */
#define AR_EEPROM_ABSENT	0x00000100
#define AR_EEPROM_CORRUPT	0x00000200
#define AR_EEPROM_PROT_MASK_M	0x03fffc00
#define AR_EEPROM_PROT_MASK_S	10

/* Bits for AR_SREV. */
#define AR_SREV_ID_M			0x000000ff
#define AR_SREV_ID_S			0
#define AR_SREV_REVISION_M		0x00000007
#define AR_SREV_REVISION_S		0
#define AR_SREV_VERSION_M		0x000000f0
#define AR_SREV_VERSION_S		4
#define AR_SREV_VERSION2_M		0xfffc0000
#define AR_SREV_VERSION2_S		12		/* XXX Hack. */
#define AR_SREV_TYPE2_M			0x0003f000
#define AR_SREV_TYPE2_S			12
#define AR_SREV_TYPE2_CHAIN		0x00001000
#define AR_SREV_TYPE2_HOST_MODE		0x00002000
#define AR_SREV_REVISION2_M		0x00000f00
#define AR_SREV_REVISION2_S		8
#define AR_SREV_VERSION_5416_PCI	0x00d
#define AR_SREV_VERSION_5416_PCIE	0x00c
#define AR_SREV_REVISION_5416_10	0
#define AR_SREV_REVISION_5416_20	1
#define AR_SREV_REVISION_5416_22	2
#define AR_SREV_VERSION_9100		0x014
#define AR_SREV_VERSION_9160		0x040
#define AR_SREV_REVISION_9160_10	0
#define AR_SREV_REVISION_9160_11	1
#define AR_SREV_VERSION_9280		0x080
#define AR_SREV_REVISION_9280_10	0
#define AR_SREV_REVISION_9280_20	1
#define AR_SREV_REVISION_9280_21	2
#define AR_SREV_VERSION_9285		0x0c0
#define AR_SREV_REVISION_9285_10	0
#define AR_SREV_REVISION_9285_11	1
#define AR_SREV_REVISION_9285_12	2
#define AR_SREV_VERSION_9287		0x180
#define AR_SREV_REVISION_9287_10	0
#define AR_SREV_REVISION_9287_11	1
#define AR_SREV_REVISION_9287_12	2

/* Bits for AR_AHB_MODE. */
#define AR_AHB_EXACT_WR_EN			0x00000000
#define AR_AHB_BUF_WR_EN			0x00000001
#define AR_AHB_EXACT_RD_EN			0x00000000
#define AR_AHB_CACHELINE_RD_EN			0x00000002
#define AR_AHB_PREFETCH_RD_EN			0x00000004
#define AR_AHB_PAGE_SIZE_1K			0x00000000
#define AR_AHB_PAGE_SIZE_2K			0x00000008
#define AR_AHB_PAGE_SIZE_4K			0x00000010
#define AR_AHB_CUSTOM_BURST_M			0x000000c0
#define AR_AHB_CUSTOM_BURST_S			6
#define AR_AHB_CUSTOM_BURST_ASYNC_FIFO_VAL	3

/* Bits for AR_INTR_SYNC_CAUSE. */
#define AR_INTR_SYNC_RTC_IRQ			0x00000001
#define AR_INTR_SYNC_MAC_IRQ			0x00000002
#define AR_INTR_SYNC_EEPROM_ILLEGAL_ACCESS	0x00000004
#define AR_INTR_SYNC_APB_TIMEOUT		0x00000008
#define AR_INTR_SYNC_PCI_MODE_CONFLICT		0x00000010
#define AR_INTR_SYNC_HOST1_FATAL		0x00000020
#define AR_INTR_SYNC_HOST1_PERR			0x00000040
#define AR_INTR_SYNC_TRCV_FIFO_PERR		0x00000080
#define AR_INTR_SYNC_RADM_CPL_EP		0x00000100
#define AR_INTR_SYNC_RADM_CPL_DLLP_ABORT	0x00000200
#define AR_INTR_SYNC_RADM_CPL_TLP_ABORT		0x00000400
#define AR_INTR_SYNC_RADM_CPL_ECRC_ERR		0x00000800
#define AR_INTR_SYNC_RADM_CPL_TIMEOUT		0x00001000
#define AR_INTR_SYNC_LOCAL_TIMEOUT		0x00002000
#define AR_INTR_SYNC_PM_ACCESS			0x00004000
#define AR_INTR_SYNC_MAC_AWAKE			0x00008000
#define AR_INTR_SYNC_MAC_ASLEEP			0x00010000
#define AR_INTR_SYNC_MAC_SLEEP_ACCESS		0x00020000
#define AR_INTR_SYNC_ALL			0x0003ffff
#define AR_INTR_SYNC_GPIO_PIN(i)		(1 << (18 + (i)))

#define AR_INTR_SYNC_DEFAULT			\
	(AR_INTR_SYNC_HOST1_FATAL |		\
	 AR_INTR_SYNC_HOST1_PERR |		\
	 AR_INTR_SYNC_RADM_CPL_EP |		\
	 AR_INTR_SYNC_RADM_CPL_DLLP_ABORT |	\
	 AR_INTR_SYNC_RADM_CPL_TLP_ABORT |	\
	 AR_INTR_SYNC_RADM_CPL_ECRC_ERR |	\
	 AR_INTR_SYNC_RADM_CPL_TIMEOUT |	\
	 AR_INTR_SYNC_LOCAL_TIMEOUT |		\
	 AR_INTR_SYNC_MAC_SLEEP_ACCESS)

/* Bits for AR_INTR_ASYNC_CAUSE. */
#define AR_INTR_RTC_IRQ		0x00000001
#define AR_INTR_MAC_IRQ		0x00000002
#define AR_INTR_EEP_PROT_ACCESS	0x00000004
#define AR_INTR_MAC_AWAKE	0x00020000
#define AR_INTR_MAC_ASLEEP	0x00040000
#define AR_INTR_GPIO_PIN(i)	(1 << (18 + (i)))
#define AR_INTR_SPURIOUS	0xffffffff

/* Bits for AR_GPIO_OE_OUT. */
#define AR_GPIO_OE_OUT_DRV_M	0x00000003
#define AR_GPIO_OE_OUT_DRV_S	0
#define AR_GPIO_OE_OUT_DRV_NO	0
#define AR_GPIO_OE_OUT_DRV_LOW	1
#define AR_GPIO_OE_OUT_DRV_HI	2
#define AR_GPIO_OE_OUT_DRV_ALL	3

/* Bits for AR_GPIO_INTR_POL. */
#define AR_GPIO_INTR_POL_PIN(i)		(1 << (i))

/* Bits for AR_GPIO_INPUT_EN_VAL. */
#define AR_GPIO_INPUT_EN_VAL_BT_PRIORITY_DEF	0x00000004
#define AR_GPIO_INPUT_EN_VAL_BT_FREQUENCY_DEF	0x00000008
#define AR_GPIO_INPUT_EN_VAL_BT_ACTIVE_DEF	0x00000010
#define AR_GPIO_INPUT_EN_VAL_RFSILENT_DEF	0x00000080
#define AR_GPIO_INPUT_EN_VAL_BT_PRIORITY_BB	0x00000400
#define AR_GPIO_INPUT_EN_VAL_BT_ACTIVE_BB	0x00001000
#define AR_GPIO_INPUT_EN_VAL_RFSILENT_BB	0x00008000
#define AR_GPIO_RTC_RESET_OVERRIDE_ENABLE	0x00010000
#define AR_GPIO_JTAG_DISABLE			0x00020000

/* Bits for AR_GPIO_INPUT_MUX1. */
#define AR_GPIO_INPUT_MUX1_BT_PRIORITY_M	0x00000f00
#define AR_GPIO_INPUT_MUX1_BT_PRIORITY_S	8
#define AR_GPIO_INPUT_MUX1_BT_ACTIVE_M		0x000f0000
#define AR_GPIO_INPUT_MUX1_BT_ACTIVE_S		16

/* Bits for AR_GPIO_INPUT_MUX2. */
#define AR_GPIO_INPUT_MUX2_CLK25_M		0x0000000f
#define AR_GPIO_INPUT_MUX2_CLK25_S		0
#define AR_GPIO_INPUT_MUX2_RFSILENT_M		0x000000f0
#define AR_GPIO_INPUT_MUX2_RFSILENT_S		4
#define AR_GPIO_INPUT_MUX2_RTC_RESET_M		0x00000f00
#define AR_GPIO_INPUT_MUX2_RTC_RESET_S		8

/* Bits for AR_GPIO_OUTPUT_MUX[1-3]. */
#define AR_GPIO_OUTPUT_MUX_AS_OUTPUT			0
#define AR_GPIO_OUTPUT_MUX_AS_PCIE_ATTENTION_LED	1
#define AR_GPIO_OUTPUT_MUX_AS_PCIE_POWER_LED		2
#define AR_GPIO_OUTPUT_MUX_AS_TX_FRAME			3
#define AR_GPIO_OUTPUT_MUX_AS_RX_CLEAR_EXTERNAL		4
#define AR_GPIO_OUTPUT_MUX_AS_MAC_NETWORK_LED		5
#define AR_GPIO_OUTPUT_MUX_AS_MAC_POWER_LED		6

/* Bits for AR_EEPROM_STATUS_DATA. */
#define AR_EEPROM_STATUS_DATA_VAL_M		0x0000ffff
#define AR_EEPROM_STATUS_DATA_VAL_S		0
#define AR_EEPROM_STATUS_DATA_BUSY		0x00010000
#define AR_EEPROM_STATUS_DATA_BUSY_ACCESS	0x00020000
#define AR_EEPROM_STATUS_DATA_PROT_ACCESS	0x00040000
#define AR_EEPROM_STATUS_DATA_ABSENT_ACCESS	0x00080000

/* Bits for AR_PCIE_MSI. */
#define AR_PCIE_MSI_ENABLE	0x00000001

/* Bits for AR_RTC_RC. */
#define AR_RTC_RC_MAC_WARM	0x00000001
#define AR_RTC_RC_MAC_COLD	0x00000002
#define AR_RTC_RC_COLD_RESET	0x00000004
#define AR_RTC_RC_WARM_RESET	0x00000008

/* Bits for AR_RTC_PLL_CONTROL. */
#define AR_RTC_PLL_DIV_M		0x0000001f
#define AR_RTC_PLL_DIV_S		0
#define AR_RTC_PLL_DIV2			0x00000020
#define AR_RTC_PLL_REFDIV_5		0x000000c0
#define AR_RTC_PLL_CLKSEL_M		0x00000300
#define AR_RTC_PLL_CLKSEL_S		8
#define AR_RTC_9160_PLL_DIV_M		0x000003ff
#define AR_RTC_9160_PLL_DIV_S		0
#define AR_RTC_9160_PLL_REFDIV_M	0x00003c00
#define AR_RTC_9160_PLL_REFDIV_S	10
#define AR_RTC_9160_PLL_CLKSEL_M	0x0000c000
#define AR_RTC_9160_PLL_CLKSEL_S	14

/* Bits for AR_RTC_RESET. */
#define AR_RTC_RESET_EN		0x00000001

/* Bits for AR_RTC_STATUS. */
#define AR_RTC_STATUS_M		0x0000000f
#define AR_RTC_STATUS_S		0
#define AR_RTC_STATUS_SHUTDOWN	0x00000001
#define AR_RTC_STATUS_ON	0x00000002
#define AR_RTC_STATUS_SLEEP	0x00000004
#define AR_RTC_STATUS_WAKEUP	0x00000008

/* Bits for AR_RTC_SLEEP_CLK. */
#define AR_RTC_FORCE_DERIVED_CLK	0x00000002

/* Bits for AR_RTC_FORCE_WAKE. */
#define AR_RTC_FORCE_WAKE_EN		0x00000001
#define AR_RTC_FORCE_WAKE_ON_INT	0x00000002

/*
 * Analog registers.
 */
/* Bits for AR_AN_RF2G1_CH0. */
#define AR_AN_RF2G1_CH0_OB_M	0x03800000
#define AR_AN_RF2G1_CH0_OB_S	23
#define AR_AN_RF2G1_CH0_DB_M	0x1c000000
#define AR_AN_RF2G1_CH0_DB_S	26

/* Bits for AR_AN_RF5G1_CH0. */
#define AR_AN_RF5G1_CH0_OB5_M	0x00070000
#define AR_AN_RF5G1_CH0_OB5_S	16
#define AR_AN_RF5G1_CH0_DB5_M	0x00380000
#define AR_AN_RF5G1_CH0_DB5_S	19

/* Bits for AR_AN_RF2G1_CH1. */
#define AR_AN_RF2G1_CH1_OB_M	0x03800000
#define AR_AN_RF2G1_CH1_OB_S	23
#define AR_AN_RF2G1_CH1_DB_M	0x1c000000
#define AR_AN_RF2G1_CH1_DB_S	26

/* Bits for AR_AN_RF5G1_CH1. */
#define AR_AN_RF5G1_CH1_OB5_M	0x00070000
#define AR_AN_RF5G1_CH1_OB5_S	16
#define AR_AN_RF5G1_CH1_DB5_M	0x00380000
#define AR_AN_RF5G1_CH1_DB5_S	19

/* Bits for AR_AN_SYNTH9. */
#define AR_AN_SYNTH9_REFDIVA_M	0xf8000000
#define AR_AN_SYNTH9_REFDIVA_S	27

/* Bits for AR_AN_TOP1. */
#define AR_AN_TOP1_DACLPMODE	0x00040000

/* Bits for AR_AN_TOP2. */
#define AR_AN_TOP2_XPABIAS_LVL_M	0xc0000000
#define AR_AN_TOP2_XPABIAS_LVL_S	30
#define AR_AN_TOP2_LOCALBIAS		0x00200000
#define AR_AN_TOP2_PWDCLKIND		0x00400000


/* Bits for AR_STA_ID1. */
#define AR_STA_ID1_SADH_M		0x0000ffff
#define AR_STA_ID1_SADH_S		0
#define AR_STA_ID1_STA_AP		0x00010000
#define AR_STA_ID1_ADHOC		0x00020000
#define AR_STA_ID1_PWR_SAV		0x00040000
#define AR_STA_ID1_KSRCHDIS		0x00080000
#define AR_STA_ID1_PCF			0x00100000
#define AR_STA_ID1_USE_DEFANT		0x00200000
#define AR_STA_ID1_DEFANT_UPDATE	0x00400000
#define AR_STA_ID1_RTS_USE_DEF		0x00800000
#define AR_STA_ID1_ACKCTS_6MB		0x01000000
#define AR_STA_ID1_BASE_RATE_11B	0x02000000
#define AR_STA_ID1_SECTOR_SELF_GEN	0x04000000
#define AR_STA_ID1_CRPT_MIC_ENABLE	0x08000000
#define AR_STA_ID1_KSRCH_MODE		0x10000000
#define AR_STA_ID1_PRESERVE_SEQNUM	0x20000000
#define AR_STA_ID1_CBCIV_ENDIAN		0x40000000
#define AR_STA_ID1_MCAST_KSRCH		0x80000000

/* Bits for AR_BSS_ID1. */
#define AR_BSS_ID1_U16_M	0x0000ffff
#define AR_BSS_ID1_U16_S	0
#define AR_BSS_ID1_AID_M	0x07ff0000
#define AR_BSS_ID1_AID_S	16

/* Bits for AR_TIME_OUT. */
#define AR_TIME_OUT_ACK_M			0x00003fff
#define AR_TIME_OUT_ACK_S			0
#define AR_TIME_OUT_CTS_M			0x3fff0000
#define AR_TIME_OUT_CTS_S			16
#define AR_TIME_OUT_ACK_CTS_ASYNC_FIFO_DUR	0x16001d56

/* Bits for AR_RSSI_THR. */
#define AR_RSSI_THR_M		0x000000ff
#define AR_RSSI_THR_S		0
#define AR_RSSI_THR_BM_THR_M	0x0000ff00
#define AR_RSSI_THR_BM_THR_S	8
#define AR_RSSI_BCN_WEIGHT_M	0x1f000000
#define AR_RSSI_BCN_WEIGHT_S	24
#define AR_RSSI_BCN_RSSI_RST	0x20000000

/* Bits for AR_USEC. */
#define AR_USEC_USEC_M		0x0000007f
#define AR_USEC_USEC_S		0
#define AR_USEC_TX_LAT_M	0x007fc000
#define AR_USEC_TX_LAT_S	14
#define AR_USEC_RX_LAT_M	0x1f800000
#define AR_USEC_RX_LAT_S	23
#define AR_USEC_ASYNC_FIFO_DUR	0x12e00074

/* Bits for AR_RESET_TSF. */
#define AR_RESET_TSF_ONCE	0x01000000

/* Bits for AR_RX_FILTER. */
#define AR_RX_FILTER_UCAST	0x00000001
#define AR_RX_FILTER_MCAST	0x00000002
#define AR_RX_FILTER_BCAST	0x00000004
#define AR_RX_FILTER_CONTROL	0x00000008
#define AR_RX_FILTER_BEACON	0x00000010
#define AR_RX_FILTER_PROM	0x00000020
#define AR_RX_FILTER_PROBEREQ	0x00000080
#define AR_RX_FILTER_MYBEACON	0x00000200
#define AR_RX_FILTER_COMPR_BAR	0x00000400
#define AR_RX_FILTER_PSPOLL	0x00004000

/* Bits for AR_DIAG_SW. */
#define AR_DIAG_CACHE_ACK		0x00000001
#define AR_DIAG_ACK_DIS			0x00000002
#define AR_DIAG_CTS_DIS			0x00000004
#define AR_DIAG_ENCRYPT_DIS		0x00000008
#define AR_DIAG_DECRYPT_DIS		0x00000010
#define AR_DIAG_RX_DIS			0x00000020
#define AR_DIAG_LOOP_BACK		0x00000040
#define AR_DIAG_CORR_FCS		0x00000080
#define AR_DIAG_CHAN_INFO		0x00000100
#define AR_DIAG_SCRAM_SEED_M		0x0001fe00
#define AR_DIAG_SCRAM_SEED_S		8	/* XXX should be 9? */
#define AR_DIAG_FRAME_NV0		0x00020000
#define AR_DIAG_OBS_PT_SEL1_M		0x000c0000
#define AR_DIAG_OBS_PT_SEL1_S		18
#define AR_DIAG_FORCE_RX_CLEAR		0x00100000
#define AR_DIAG_IGNORE_VIRT_CS		0x00200000
#define AR_DIAG_FORCE_CH_IDLE_HIGH	0x00400000
#define AR_DIAG_EIFS_CTRL_ENA		0x00800000
#define AR_DIAG_DUAL_CHAIN_INFO		0x01000000
#define AR_DIAG_RX_ABORT		0x02000000
#define AR_DIAG_SATURATE_CYCLE_CNT	0x04000000
#define AR_DIAG_OBS_PT_SEL2		0x08000000
#define AR_DIAG_RX_CLEAR_CTL_LOW	0x10000000
#define AR_DIAG_RX_CLEAR_EXT_LOW	0x20000000

/* Bits for AR_AES_MUTE_MASK0. */
#define AR_AES_MUTE_MASK0_FC_M	0x0000ffff
#define AR_AES_MUTE_MASK0_FC_S	0
#define AR_AES_MUTE_MASK0_QOS_M	0xffff0000
#define AR_AES_MUTE_MASK0_QOS_S	16

/* Bits for AR_AES_MUTE_MASK1. */
#define AR_AES_MUTE_MASK1_SEQ_M		0x0000ffff
#define AR_AES_MUTE_MASK1_SEQ_S		0
#define AR_AES_MUTE_MASK1_FC_MGMT_M	0xffff0000
#define AR_AES_MUTE_MASK1_FC_MGMT_S	16
#define AR_AES_MUTE_MASK1_FC0_MGMT_M	0x00ff0000
#define AR_AES_MUTE_MASK1_FC0_MGMT_S	16
#define AR_AES_MUTE_MASK1_FC1_MGMT_M	0xff000000
#define AR_AES_MUTE_MASK1_FC1_MGMT_S	24

/* Bits for AR_GATED_CLKS. */
#define AR_GATED_CLKS_TX	0x00000002
#define AR_GATED_CLKS_RX	0x00000004
#define AR_GATED_CLKS_REG	0x00000008

/* Bits for AR_OBS_BUS_CTRL. */
#define AR_OBS_BUS_SEL_1	0x00040000
#define AR_OBS_BUS_SEL_2	0x00080000
#define AR_OBS_BUS_SEL_3	0x000c0000
#define AR_OBS_BUS_SEL_4	0x08040000
#define AR_OBS_BUS_SEL_5	0x08080000

/* Bits for AR_OBS_BUS_1. */
#define AR_OBS_BUS_1_PCU		0x00000001
#define AR_OBS_BUS_1_RX_END		0x00000002
#define AR_OBS_BUS_1_RX_WEP		0x00000004
#define AR_OBS_BUS_1_RX_BEACON		0x00000008
#define AR_OBS_BUS_1_RX_FILTER		0x00000010
#define AR_OBS_BUS_1_TX_HCF		0x00000020
#define AR_OBS_BUS_1_QUIET_TIME		0x00000040
#define AR_OBS_BUS_1_CHAN_IDLE		0x00000080
#define AR_OBS_BUS_1_TX_HOLD		0x00000100
#define AR_OBS_BUS_1_TX_FRAME		0x00000200
#define AR_OBS_BUS_1_RX_FRAME		0x00000400
#define AR_OBS_BUS_1_RX_CLEAR		0x00000800
#define AR_OBS_BUS_1_WEP_STATE_M	0x0003f000
#define AR_OBS_BUS_1_WEP_STATE_S	12
#define AR_OBS_BUS_1_RX_STATE_M		0x01f00000
#define AR_OBS_BUS_1_RX_STATE_S		20
#define AR_OBS_BUS_1_TX_STATE_M		0x7e000000
#define AR_OBS_BUS_1_TX_STATE_S		25

/* Bits for AR_SLEEP1. */
#define AR_SLEEP1_ASSUME_DTIM		0x00080000
#define AR_SLEEP1_CAB_TIMEOUT_M		0xffe00000
#define AR_SLEEP1_CAB_TIMEOUT_S		21
/* Default value. */
#define AR_CAB_TIMEOUT_VAL		10

/* Bits for AR_SLEEP2. */
#define AR_SLEEP2_BEACON_TIMEOUT_M	0xffe00000
#define AR_SLEEP2_BEACON_TIMEOUT_S	21

/* Bits for AR_TPC. */
#define AR_TPC_ACK_M	0x0000003f
#define AR_TPC_ACK_S	0
#define AR_TPC_CTS_M	0x00003f00
#define AR_TPC_CTS_S	8
#define AR_TPC_CHIRP_M	0x003f0000
#define AR_TPC_CHIRP_S	16

/* Bits for AR_QUIET1. */
#define AR_QUIET1_NEXT_QUIET_M		0x0000ffff
#define AR_QUIET1_NEXT_QUIET_S		0
#define AR_QUIET1_QUIET_ENABLE		0x00010000
#define AR_QUIET1_QUIET_ACK_CTS_ENABLE	0x00020000

/* Bits for AR_QUIET2. */
#define AR_QUIET2_QUIET_PERIOD_M	0x0000ffff
#define AR_QUIET2_QUIET_PERIOD_S	0
#define AR_QUIET2_QUIET_DUR_M		0xffff0000
#define AR_QUIET2_QUIET_DUR_S		16

/* Bits for AR_TSF_PARM. */
#define AR_TSF_INCREMENT_M	0x000000ff
#define AR_TSF_INCREMENT_S	0

/* Bits for AR_QOS_NO_ACK. */
#define AR_QOS_NO_ACK_TWO_BIT_M		0x0000000f
#define AR_QOS_NO_ACK_TWO_BIT_S		0
#define AR_QOS_NO_ACK_BIT_OFF_M		0x0000007f
#define AR_QOS_NO_ACK_BIT_OFF_S		4
#define AR_QOS_NO_ACK_BYTE_OFF_M	0x00000180
#define AR_QOS_NO_ACK_BYTE_OFF_S	7

/* Bits for AR_PHY_ERR. */
#define AR_PHY_ERR_DCHIRP	0x00000008
#define AR_PHY_ERR_RADAR	0x00000020
#define AR_PHY_ERR_OFDM_TIMING	0x00020000
#define AR_PHY_ERR_CCK_TIMING	0x02000000

/* Bits for AR_PCU_MISC. */
#define AR_PCU_FORCE_BSSID_MATCH	0x00000001
#define AR_PCU_MIC_NEW_LOC_ENA		0x00000004
#define AR_PCU_TX_ADD_TSF		0x00000008
#define AR_PCU_CCK_SIFS_MODE		0x00000010
#define AR_PCU_RX_ANT_UPDT		0x00000800
#define AR_PCU_TXOP_TBTT_LIMIT_ENA	0x00001000
#define AR_PCU_MISS_BCN_IN_SLEEP	0x00004000
#define AR_PCU_BUG_12306_FIX_ENA	0x00020000
#define AR_PCU_FORCE_QUIET_COLL		0x00040000
#define AR_PCU_BT_ANT_PREVENT_RX	0x00100000
#define AR_PCU_TBTT_PROTECT		0x00200000
#define AR_PCU_CLEAR_VMF		0x01000000
#define AR_PCU_CLEAR_BA_VALID		0x04000000

/* Bits for AR_BT_COEX_MODE. */
#define AR_BT_TIME_EXTEND_M	0x000000ff
#define AR_BT_TIME_EXTEND_S	0
#define AR_BT_TXSTATE_EXTEND	0x00000100
#define AR_BT_TX_FRAME_EXTEND	0x00000200
#define AR_BT_MODE_M		0x00000c00
#define AR_BT_MODE_S		10
#define AR_BT_MODE_LEGACY	0
#define AR_BT_MODE_UNSLOTTED	1
#define AR_BT_MODE_SLOTTED	2
#define AR_BT_MODE_DISABLED	3
#define AR_BT_QUIET		0x00001000
#define AR_BT_QCU_THRESH_M	0x0001e000
#define AR_BT_QCU_THRESH_S	13
#define AR_BT_RX_CLEAR_POLARITY	0x00020000
#define AR_BT_PRIORITY_TIME_M	0x00fc0000
#define AR_BT_PRIORITY_TIME_S	18
#define AR_BT_FIRST_SLOT_TIME_M	0xff000000
#define AR_BT_FIRST_SLOT_TIME_S	24

/* Bits for AR_BT_COEX_WEIGHT. */
#define AR_BTCOEX_BT_WGHT_M	0x0000ffff
#define AR_BTCOEX_BT_WGHT_S	0
#define AR_STOMP_LOW_BT_WGHT	0xff55
#define AR_BTCOEX_WL_WGHT_M	0xffff0000
#define AR_BTCOEX_WL_WGHT_S	16
#define AR_STOMP_LOW_WL_WGHT	0xaaa8

/* Bits for AR_BT_COEX_MODE2. */
#define AR_BT_BCN_MISS_THRESH_M	0x000000ff
#define AR_BT_BCN_MISS_THRESH_S	0
#define AR_BT_BCN_MISS_CNT_M	0x0000ff00
#define AR_BT_BCN_MISS_CNT_S	8
#define AR_BT_HOLD_RX_CLEAR	0x00010000
#define AR_BT_DISABLE_BT_ANT	0x00100000

/* Bits for AR_PCU_TXBUF_CTRL. */
#define AR_PCU_TXBUF_CTRL_SIZE_M		0x000007ff
#define AR_PCU_TXBUF_CTRL_SIZE_S		0
#define AR_PCU_TXBUF_CTRL_USABLE_SIZE		1792
#define AR9285_PCU_TXBUF_CTRL_USABLE_SIZE	(1792 / 2)

/* Bits for AR_PCU_MISC_MODE2. */
#define AR_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE		0x00000002
#define AR_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT	0x00000004
#define AR_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE	0x00000040
#define AR_PCU_MISC_MODE2_CFP_IGNORE			0x00000080
#define AR_PCU_MISC_MODE2_MGMT_QOS_M			0x0000ff00
#define AR_PCU_MISC_MODE2_MGMT_QOS_S			8
#define AR_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DUR	0x00010000
#define AR_PCU_MISC_MODE2_ENABLE_AGGWEP			0x00020000
#define AR_PCU_MISC_MODE2_HWWAR1			0x00100000
#define AR_PCU_MISC_MODE2_HWWAR2			0x02000000

/* Bits for AR_MAC_PCU_LOGIC_ANALYZER. */
#define AR_MAC_PCU_LOGIC_ANALYZER_DISBUG20768	0x20000000

/* Bits for AR_MAC_PCU_ASYNC_FIFO_REG3. */
#define AR_MAC_PCU_ASYNC_FIFO_REG3_DATAPATH_SEL	0x00000400
#define AR_MAC_PCU_ASYNC_FIFO_REG3_SOFT_RESET	0x80000000

/* Bits for AR_PHY_ERR_[123]. */
#define AR_PHY_ERR_COUNT_M	0x00ffffff
#define AR_PHY_ERR_COUNT_S	0

/* Bits for AR_TSFOOR_THRESHOLD. */
#define AR_TSFOOR_THRESHOLD_VAL_M	0x0000ffff
#define AR_TSFOOR_THRESHOLD_VAL_S	0

/* Bit for AR_TXSIFS. */
#define AR_TXSIFS_TIME_M	0x000000ff
#define AR_TXSIFS_TIME_S	0
#define AR_TXSIFS_TX_LATENCY_M	0x00000f00
#define AR_TXSIFS_TX_LATENCY_S	8
#define AR_TXSIFS_ACK_SHIFT_M	0x00007000
#define AR_TXSIFS_ACK_SHIFT_S	12

/* Bits for AR_TXOP_X. */
#define AR_TXOP_X_VAL	0x000000ff

/* Bits for AR_TIMER_MODE. */
#define AR_TBTT_TIMER_EN		0x00000001
#define AR_DBA_TIMER_EN			0x00000002
#define AR_SWBA_TIMER_EN		0x00000004
#define AR_HCF_TIMER_EN			0x00000008
#define AR_TIM_TIMER_EN			0x00000010
#define AR_DTIM_TIMER_EN		0x00000020
#define AR_QUIET_TIMER_EN		0x00000040
#define AR_NDP_TIMER_EN			0x00000080
#define AR_TIMER_OVERFLOW_INDEX_M	0x00000700
#define AR_TIMER_OVERFLOW_INDEX_S	8
#define AR_TIMER_THRESH_M		0xfffff000
#define AR_TIMER_THRESH_S		12

/* Bits for AR_SLP32_MODE. */
#define AR_SLP32_HALF_CLK_LATENCY_M	0x000fffff
#define AR_SLP32_HALF_CLK_LATENCY_S	0
#define AR_SLP32_ENA			0x00100000
#define AR_SLP32_TSF_WRITE_STATUS	0x00200000

/* Bits for AR_SLP32_WAKE. */
#define AR_SLP32_WAKE_XTL_TIME_M	0x0000ffff
#define AR_SLP32_WAKE_XTL_TIME_S	0

/* Bits for AR_SLP_MIB_CTRL. */
#define AR_SLP_MIB_CLEAR	0x00000001
#define AR_SLP_MIB_PENDING	0x00000002

/* Bits for AR_2040_MODE. */
#define AR_2040_JOINED_RX_CLEAR	0x00000001

/* Bits for AR_KEYTABLE_TYPE. */
#define AR_KEYTABLE_TYPE_M	0x00000007
#define AR_KEYTABLE_TYPE_S	0
#define AR_KEYTABLE_TYPE_40	0
#define AR_KEYTABLE_TYPE_104	1
#define AR_KEYTABLE_TYPE_128	3
#define AR_KEYTABLE_TYPE_TKIP	4
#define AR_KEYTABLE_TYPE_AES	5
#define AR_KEYTABLE_TYPE_CCM	6
#define AR_KEYTABLE_TYPE_CLR	7
#define AR_KEYTABLE_ANT		0x00000008
#define AR_KEYTABLE_VALID	0x00008000



/* Bits for AR_PHY_TEST. */
#define AR_PHY_TEST_RFSILENT_BB	0x00002000
#define AR_PHY_TEST_AGC_CLR	0x10000000

/* Bits for AR_PHY_TURBO. */
#define AR_PHY_FC_TURBO_MODE		0x00000001
#define AR_PHY_FC_TURBO_SHORT		0x00000002
#define AR_PHY_FC_DYN2040_EN		0x00000004
#define AR_PHY_FC_DYN2040_PRI_ONLY	0x00000008
#define AR_PHY_FC_DYN2040_PRI_CH	0x00000010
#define AR_PHY_FC_DYN2040_EXT_CH	0x00000020
#define AR_PHY_FC_HT_EN			0x00000040
#define AR_PHY_FC_SHORT_GI_40		0x00000080
#define AR_PHY_FC_WALSH			0x00000100
#define AR_PHY_FC_SINGLE_HT_LTF1	0x00000200
#define AR_PHY_FC_ENABLE_DAC_FIFO	0x00000800

/* Bits for AR_PHY_TIMING3. */
#define AR_PHY_TIMING3_DSC_MAN_M	0xfffe0000
#define AR_PHY_TIMING3_DSC_MAN_S	17
#define AR_PHY_TIMING3_DSC_EXP_M	0x0001e000
#define AR_PHY_TIMING3_DSC_EXP_S	13

/* Bits for AR_PHY_CHIP_ID. */
#define AR_PHY_CHIP_ID_REV_0		0x80
#define AR_PHY_CHIP_ID_REV_1		0x81
#define AR_PHY_CHIP_ID_9160_REV_0	0xb0

/* Bits for AR_PHY_ACTIVE. */
#define AR_PHY_ACTIVE_EN	0x00000001
#define AR_PHY_ACTIVE_DIS	0x00000000

/* Bits for AR_PHY_RF_CTL2. */
#define AR_PHY_TX_END_DATA_START_M	0x000000ff
#define AR_PHY_TX_END_DATA_START_S	0
#define AR_PHY_TX_END_PA_ON_M		0x0000ff00
#define AR_PHY_TX_END_PA_ON_S		8

/* Bits for AR_PHY_RF_CTL3. */
#define AR_PHY_TX_END_TO_A2_RX_ON_M	0x00ff0000
#define AR_PHY_TX_END_TO_A2_RX_ON_S	16

/* Bits for AR_PHY_ADC_CTL. */
#define AR_PHY_ADC_CTL_OFF_INBUFGAIN_M	0x00000003
#define AR_PHY_ADC_CTL_OFF_INBUFGAIN_S	0
#define AR_PHY_ADC_CTL_OFF_PWDDAC	0x00002000
#define AR_PHY_ADC_CTL_OFF_PWDBANDGAP	0x00004000
#define AR_PHY_ADC_CTL_OFF_PWDADC	0x00008000
#define AR_PHY_ADC_CTL_ON_INBUFGAIN_M	0x00030000
#define AR_PHY_ADC_CTL_ON_INBUFGAIN_S	16

/* Bits for AR_PHY_ADC_SERIAL_CTL. */
#define AR_PHY_SEL_INTERNAL_ADDAC	0x00000000
#define AR_PHY_SEL_EXTERNAL_RADIO	0x00000001

/* Bits for AR_PHY_RF_CTL4. */
#define AR_PHY_RF_CTL4_TX_END_XPAB_OFF_M	0xff000000
#define AR_PHY_RF_CTL4_TX_END_XPAB_OFF_S	24
#define AR_PHY_RF_CTL4_TX_END_XPAA_OFF_M	0x00ff0000
#define AR_PHY_RF_CTL4_TX_END_XPAA_OFF_S	16
#define AR_PHY_RF_CTL4_FRAME_XPAB_ON_M		0x0000ff00
#define AR_PHY_RF_CTL4_FRAME_XPAB_ON_S		8
#define AR_PHY_RF_CTL4_FRAME_XPAA_ON_M		0x000000ff
#define AR_PHY_RF_CTL4_FRAME_XPAA_ON_S		0

/* Bits for AR_PHY_SETTLING. */
#define AR_PHY_SETTLING_SWITCH_M	0x00003f80
#define AR_PHY_SETTLING_SWITCH_S	7

/* Bits for AR_PHY_RXGAIN. */
#define AR_PHY_RXGAIN_TXRX_ATTEN_M	0x0003f000
#define AR_PHY_RXGAIN_TXRX_ATTEN_S	12
#define AR_PHY_RXGAIN_TXRX_RF_MAX_M	0x007c0000
#define AR_PHY_RXGAIN_TXRX_RF_MAX_S	18
#define AR9280_PHY_RXGAIN_TXRX_ATTEN_M	0x00003f80
#define AR9280_PHY_RXGAIN_TXRX_ATTEN_S	7
#define AR9280_PHY_RXGAIN_TXRX_MARGIN_M	0x001fc000
#define AR9280_PHY_RXGAIN_TXRX_MARGIN_S	14

/* Bits for AR_PHY_DESIRED_SZ. */
#define AR_PHY_DESIRED_SZ_ADC_M		0x000000ff
#define AR_PHY_DESIRED_SZ_ADC_S		0
#define AR_PHY_DESIRED_SZ_PGA_M		0x0000ff00
#define AR_PHY_DESIRED_SZ_PGA_S		8
#define AR_PHY_DESIRED_SZ_TOT_DES_M	0x0ff00000
#define AR_PHY_DESIRED_SZ_TOT_DES_S	20

/* Bits for AR_PHY_FIND_SIG. */
#define AR_PHY_FIND_SIG_FIRSTEP_M	0x0003f000
#define AR_PHY_FIND_SIG_FIRSTEP_S	12
#define AR_PHY_FIND_SIG_FIRPWR_M	0x03fc0000
#define AR_PHY_FIND_SIG_FIRPWR_S	18

/* Bits for AR_PHY_AGC_CTL1. */
#define AR_PHY_AGC_CTL1_COARSE_LOW_M	0x00007f80
#define AR_PHY_AGC_CTL1_COARSE_LOW_S	7
#define AR_PHY_AGC_CTL1_COARSE_HIGH_M	0x003f8000
#define AR_PHY_AGC_CTL1_COARSE_HIGH_S	15

/* Bits for AR_PHY_AGC_CONTROL. */
#define AR_PHY_AGC_CONTROL_CAL		0x00000001
#define AR_PHY_AGC_CONTROL_NF		0x00000002
#define AR_PHY_AGC_CONTROL_ENABLE_NF	0x00008000
#define AR_PHY_AGC_CONTROL_FLTR_CAL	0x00010000
#define AR_PHY_AGC_CONTROL_NO_UPDATE_NF	0x00020000

/* Bits for AR_PHY_CCA. */
#define AR_PHY_MAXCCA_PWR_M		0x000001ff
#define AR_PHY_MAXCCA_PWR_S		0
#define AR_PHY_MINCCA_PWR_M		0x0ff80000
#define AR_PHY_MINCCA_PWR_S		19
#define AR_PHY_CCA_THRESH62_M		0x0007f000
#define AR_PHY_CCA_THRESH62_S		12
#define AR9280_PHY_MINCCA_PWR_M		0x1ff00000
#define AR9280_PHY_MINCCA_PWR_S		20
#define AR9280_PHY_CCA_THRESH62_M	0x000ff000
#define AR9280_PHY_CCA_THRESH62_S	12

/* Bits for AR_PHY_SFCORR_LOW. */
#define AR_PHY_SFCORR_LOW_USE_SELF_CORR_LOW	0x00000001
#define AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_M	0x00003f00
#define AR_PHY_SFCORR_LOW_M2COUNT_THR_LOW_S	8
#define AR_PHY_SFCORR_LOW_M1_THRESH_LOW_M	0x001fc000
#define AR_PHY_SFCORR_LOW_M1_THRESH_LOW_S	14
#define AR_PHY_SFCORR_LOW_M2_THRESH_LOW_M	0x0fe00000
#define AR_PHY_SFCORR_LOW_M2_THRESH_LOW_S	21

/* Bits for AR_PHY_SFCORR. */
#define AR_PHY_SFCORR_M2COUNT_THR_M	0x0000001f
#define AR_PHY_SFCORR_M2COUNT_THR_S	0
#define AR_PHY_SFCORR_M1_THRESH_M	0x00fe0000
#define AR_PHY_SFCORR_M1_THRESH_S	17
#define AR_PHY_SFCORR_M2_THRESH_M	0x7f000000
#define AR_PHY_SFCORR_M2_THRESH_S	24

/* Bits for AR_PHY_PLL_CTL. */
#define AR_PHY_PLL_CTL_40	0xaa
#define AR_PHY_PLL_CTL_40_5413	0x04
#define AR_PHY_PLL_CTL_44	0xab
#define AR_PHY_PLL_CTL_44_2133	0xeb
#define AR_PHY_PLL_CTL_40_2133	0xea

/* Bits for AR_PHY_RX_DELAY. */
#define AR_PHY_RX_DELAY_DELAY_M	0x00003fff
#define AR_PHY_RX_DELAY_DELAY_S	0

/* Bits for AR_PHY_TIMING_CTRL4_0. */
#define AR_PHY_TIMING_CTRL4_IQCORR_Q_Q_COFF_M		0x0000001f
#define AR_PHY_TIMING_CTRL4_IQCORR_Q_Q_COFF_S		0
#define AR_PHY_TIMING_CTRL4_IQCORR_Q_I_COFF_M		0x000007e0
#define AR_PHY_TIMING_CTRL4_IQCORR_Q_I_COFF_S		5
#define AR_PHY_TIMING_CTRL4_IQCORR_ENABLE		0x00000800
#define AR_PHY_TIMING_CTRL4_IQCAL_LOG_COUNT_MAX_M	0x0000f000
#define AR_PHY_TIMING_CTRL4_IQCAL_LOG_COUNT_MAX_S	12
#define AR_PHY_TIMING_CTRL4_DO_CAL			0x00010000
#define AR_PHY_TIMING_CTRL4_ENABLE_SPUR_RSSI		0x80000000
#define	AR_PHY_TIMING_CTRL4_ENABLE_SPUR_FILTER		0x40000000
#define	AR_PHY_TIMING_CTRL4_ENABLE_CHAN_MASK		0x20000000
#define	AR_PHY_TIMING_CTRL4_ENABLE_PILOT_MASK		0x10000000

/* Bits for AR_PHY_TIMING5. */
#define AR_PHY_TIMING5_CYCPWR_THR1_M	0x000000fe
#define AR_PHY_TIMING5_CYCPWR_THR1_S	1

/* Bits for AR_PHY_POWER_TX_RATE_MAX. */
#define AR_PHY_POWER_TX_RATE_MAX_TPC_ENABLE	0x00000040

/* Bits for AR_PHY_FRAME_CTL. */
#define AR_PHY_FRAME_CTL_TX_CLIP_M	0x00000038
#define AR_PHY_FRAME_CTL_TX_CLIP_S	3

/* Bits for AR_PHY_TXPWRADJ. */
#define AR_PHY_TXPWRADJ_CCK_GAIN_DELTA_M	0x00000fc0
#define AR_PHY_TXPWRADJ_CCK_GAIN_DELTA_S	6
#define AR_PHY_TXPWRADJ_CCK_PCDAC_INDEX_M	0x00fc0000
#define AR_PHY_TXPWRADJ_CCK_PCDAC_INDEX_S	18

/* Bits for AR_PHY_RADAR_EXT. */
#define AR_PHY_RADAR_EXT_ENA		0x00004000

/* Bits for AR_PHY_RADAR_0. */
#define AR_PHY_RADAR_0_ENA		0x00000001
#define AR_PHY_RADAR_0_FFT_ENA		0x80000000
#define AR_PHY_RADAR_0_INBAND_M		0x0000003e
#define AR_PHY_RADAR_0_INBAND_S		1
#define AR_PHY_RADAR_0_PRSSI_M		0x00000fc0
#define AR_PHY_RADAR_0_PRSSI_S		6
#define AR_PHY_RADAR_0_HEIGHT_M		0x0003f000
#define AR_PHY_RADAR_0_HEIGHT_S		12
#define AR_PHY_RADAR_0_RRSSI_M		0x00fc0000
#define AR_PHY_RADAR_0_RRSSI_S		18
#define AR_PHY_RADAR_0_FIRPWR_M		0x7f000000
#define AR_PHY_RADAR_0_FIRPWR_S		24

/* Bits for AR_PHY_RADAR_1. */
#define AR_PHY_RADAR_1_RELPWR_ENA	0x00800000
#define AR_PHY_RADAR_1_USE_FIR128	0x00400000
#define AR_PHY_RADAR_1_RELPWR_THRESH_M	0x003f0000
#define AR_PHY_RADAR_1_RELPWR_THRESH_S	16
#define AR_PHY_RADAR_1_BLOCK_CHECK	0x00008000
#define AR_PHY_RADAR_1_MAX_RRSSI	0x00004000
#define AR_PHY_RADAR_1_RELSTEP_CHECK	0x00002000
#define AR_PHY_RADAR_1_RELSTEP_THRESH_M	0x00001f00
#define AR_PHY_RADAR_1_RELSTEP_THRESH_S	8
#define AR_PHY_RADAR_1_MAXLEN_M		0x000000ff
#define AR_PHY_RADAR_1_MAXLEN_S		0

/* Bits for AR_PHY_SIGMA_DELTA. */
#define AR_PHY_SIGMA_DELTA_ADC_SEL_M	0x00000003
#define AR_PHY_SIGMA_DELTA_ADC_SEL_S	0
#define AR_PHY_SIGMA_DELTA_FILT2_M	0x000000f8
#define AR_PHY_SIGMA_DELTA_FILT2_S	3
#define AR_PHY_SIGMA_DELTA_FILT1_M	0x00001f00
#define AR_PHY_SIGMA_DELTA_FILT1_S	8
#define AR_PHY_SIGMA_DELTA_ADC_CLIP_M	0x01ffe000
#define AR_PHY_SIGMA_DELTA_ADC_CLIP_S	13

/* Bits for AR_PHY_RESTART. */
#define AR_PHY_RESTART_DIV_GC_M	0x001c0000
#define AR_PHY_RESTART_DIV_GC_S	18

/* Bits for AR_PHY_RFBUS_REQ. */
#define AR_PHY_RFBUS_REQ_EN	0x00000001

/* Bits for AR_PHY_TIMING11. */
#define	AR_PHY_TIMING11_SPUR_DELTA_PHASE_M	0x000fffff
#define	AR_PHY_TIMING11_SPUR_DELTA_PHASE_S	0
#define	AR_PHY_TIMING11_SPUR_FREQ_SD_M		0x3ff00000
#define	AR_PHY_TIMING11_SPUR_FREQ_SD_S		20
#define AR_PHY_TIMING11_USE_SPUR_IN_AGC		0x40000000
#define AR_PHY_TIMING11_USE_SPUR_IN_SELFCOR	0x80000000

/* Bits for AR_PHY_NEW_ADC_DC_GAIN_CORR(). */
#define AR_PHY_NEW_ADC_GAIN_CORR_ENABLE		0x40000000
#define AR_PHY_NEW_ADC_DC_OFFSET_CORR_ENABLE	0x80000000

/* Bits for AR_PHY_EXT_CCA0. */
#define AR_PHY_EXT_CCA0_THRESH62_M	0x000000ff
#define AR_PHY_EXT_CCA0_THRESH62_S	0

/* Bits for AR_PHY_EXT_CCA. */
#define AR_PHY_EXT_MAXCCA_PWR_M		0x000001ff
#define AR_PHY_EXT_MAXCCA_PWR_S		0
#define AR_PHY_EXT_CCA_CYCPWR_THR1_M	0x0000fe00
#define AR_PHY_EXT_CCA_CYCPWR_THR1_S	9
#define AR_PHY_EXT_CCA_THRESH62_M	0x007f0000
#define AR_PHY_EXT_CCA_THRESH62_S	16
#define AR_PHY_EXT_MINCCA_PWR_M		0xff800000
#define AR_PHY_EXT_MINCCA_PWR_S		23
#define AR9280_PHY_EXT_MINCCA_PWR_M	0x01ff0000
#define AR9280_PHY_EXT_MINCCA_PWR_S	16

/* Bits for AR_PHY_SFCORR_EXT. */
#define AR_PHY_SFCORR_EXT_M1_THRESH_M		0x0000007f
#define AR_PHY_SFCORR_EXT_M1_THRESH_S		0
#define AR_PHY_SFCORR_EXT_M2_THRESH_M		0x00003f80
#define AR_PHY_SFCORR_EXT_M2_THRESH_S		7
#define AR_PHY_SFCORR_EXT_M1_THRESH_LOW_M	0x001fc000
#define AR_PHY_SFCORR_EXT_M1_THRESH_LOW_S	14
#define AR_PHY_SFCORR_EXT_M2_THRESH_LOW_M	0x0fe00000
#define AR_PHY_SFCORR_EXT_M2_THRESH_LOW_S	21
#define AR_PHY_SFCORR_SPUR_SUBCHNL_SD_M		0xf0000000
#define AR_PHY_SFCORR_SPUR_SUBCHNL_SD_S		28

/* Bits for AR_PHY_HALFGI. */
#define AR_PHY_HALFGI_DSC_EXP_M	0x0000000f
#define AR_PHY_HALFGI_DSC_EXP_S	0
#define AR_PHY_HALFGI_DSC_MAN_M	0x0007fff0
#define AR_PHY_HALFGI_DSC_MAN_S	4

/* Bits for AR_PHY_CHAN_INFO_MEMORY. */
#define AR_PHY_CHAN_INFO_MEMORY_CAPTURE_MASK	0x0001

/* Bits for AR_PHY_HEAVY_CLIP_FACTOR_RIFS. */
#define AR_PHY_RIFS_INIT_DELAY_M	0x03ff0000
#define AR_PHY_RIFS_INIT_DELAY_S	16

/* Bits for AR_PHY_CALMODE. */
#define AR_PHY_CALMODE_IQ		0x00000000
#define AR_PHY_CALMODE_ADC_GAIN		0x00000001
#define AR_PHY_CALMODE_ADC_DC_PER	0x00000002
#define AR_PHY_CALMODE_ADC_DC_INIT	0x00000003

/* Bits for AR_PHY_RFBUS_GRANT. */
#define AR_PHY_RFBUS_GRANT_EN	0x00000001

/* Bits for AR_PHY_CHAN_INFO_GAIN_DIFF. */
#define AR_PHY_CHAN_INFO_GAIN_DIFF_UPPER_LIMIT	320

/* Bits for AR_PHY_MODE. */
#define AR_PHY_MODE_ASYNCFIFO		0x00000080
#define AR_PHY_MODE_AR2133		0x00000008
#define AR_PHY_MODE_AR5111		0x00000000
#define AR_PHY_MODE_AR5112		0x00000008
#define AR_PHY_MODE_DYNAMIC		0x00000004
#define AR_PHY_MODE_RF2GHZ		0x00000002
#define AR_PHY_MODE_RF5GHZ		0x00000000
#define AR_PHY_MODE_CCK			0x00000001
#define AR_PHY_MODE_OFDM		0x00000000
#define AR_PHY_MODE_DYN_CCK_DISABLE	0x00000100

/* Bits for AR_PHY_CCK_TX_CTRL. */
#define AR_PHY_CCK_TX_CTRL_JAPAN		0x00000010
#define AR_PHY_CCK_TX_CTRL_TX_DAC_SCALE_CCK_M	0x0000000c
#define AR_PHY_CCK_TX_CTRL_TX_DAC_SCALE_CCK_S	2

/* Bits for AR_PHY_CCK_DETECT. */
#define AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_M		0x0000003f
#define AR_PHY_CCK_DETECT_WEAK_SIG_THR_CCK_S		0
#define AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_M		0x00001fc0
#define AR_PHY_CCK_DETECT_ANT_SWITCH_TIME_S		6
#define AR_PHY_CCK_DETECT_BB_ENABLE_ANT_FAST_DIV	0x00002000

/* Bits for AR_PHY_GAIN_2GHZ. */
#define AR_PHY_GAIN_2GHZ_RXTX_MARGIN_M		0x00fc0000
#define AR_PHY_GAIN_2GHZ_RXTX_MARGIN_S		18
#define AR_PHY_GAIN_2GHZ_BSW_MARGIN_M		0x00003c00
#define AR_PHY_GAIN_2GHZ_BSW_MARGIN_S		10
#define AR_PHY_GAIN_2GHZ_BSW_ATTEN_M		0x0000001f
#define AR_PHY_GAIN_2GHZ_BSW_ATTEN_S		0
#define AR_PHY_GAIN_2GHZ_XATTEN2_MARGIN_M	0x003e0000
#define AR_PHY_GAIN_2GHZ_XATTEN2_MARGIN_S	17
#define AR_PHY_GAIN_2GHZ_XATTEN1_MARGIN_M	0x0001f000
#define AR_PHY_GAIN_2GHZ_XATTEN1_MARGIN_S	12
#define AR_PHY_GAIN_2GHZ_XATTEN2_DB_M		0x00000fc0
#define AR_PHY_GAIN_2GHZ_XATTEN2_DB_S		6
#define AR_PHY_GAIN_2GHZ_XATTEN1_DB_M		0x0000003f
#define AR_PHY_GAIN_2GHZ_XATTEN1_DB_S		0

/* Bit for AR_PHY_CCK_RXCTRL4. */
#define AR_PHY_CCK_RXCTRL4_FREQ_EST_SHORT_M	0x01f80000
#define AR_PHY_CCK_RXCTRL4_FREQ_EST_SHORT_S	19

/* Bits for AR_PHY_DAG_CTRLCCK. */
#define AR_PHY_DAG_CTRLCCK_EN_RSSI_THR	0x00000200
#define AR_PHY_DAG_CTRLCCK_RSSI_THR_M	0x0001fc00
#define AR_PHY_DAG_CTRLCCK_RSSI_THR_S	10

/* Bits for AR_PHY_FORCE_CLKEN_CCK. */
#define AR_PHY_FORCE_CLKEN_CCK_MRC_MUX	0x00000040

/* Bits for AR_PHY_TPCRG1. */
#define AR_PHY_TPCRG1_NUM_PD_GAIN_M	0x0000c000
#define AR_PHY_TPCRG1_NUM_PD_GAIN_S	14
#define AR_PHY_TPCRG1_PD_GAIN_1_M	0x00030000
#define AR_PHY_TPCRG1_PD_GAIN_1_S	16
#define AR_PHY_TPCRG1_PD_GAIN_2_M	0x000c0000
#define AR_PHY_TPCRG1_PD_GAIN_2_S	18
#define AR_PHY_TPCRG1_PD_GAIN_3_M	0x00300000
#define AR_PHY_TPCRG1_PD_GAIN_3_S	20
#define AR_PHY_TPCRG1_PD_CAL_ENABLE	0x00400000

/* Bits for AR_PHY_TX_PWRCTRL4. */
#define AR_PHY_TX_PWRCTRL_PD_AVG_VALID	0x00000001
#define AR_PHY_TX_PWRCTRL_PD_AVG_OUT_M	0x000001fe
#define AR_PHY_TX_PWRCTRL_PD_AVG_OUT_S	1

/* Bits for AR_PHY_TX_PWRCTRL6_[01]. */
#define AR_PHY_TX_PWRCTRL_ERR_EST_MODE_M	0x03000000
#define AR_PHY_TX_PWRCTRL_ERR_EST_MODE_S	24

/* Bits for AR_PHY_TX_PWRCTRL7. */
#define AR_PHY_TX_PWRCTRL_INIT_TX_GAIN_M	0x01f80000
#define AR_PHY_TX_PWRCTRL_INIT_TX_GAIN_S	19

/* Bits for AR_PHY_TX_PWRCTRL9. */
#define AR_PHY_TX_DESIRED_SCALE_CCK_M		0x00007c00
#define AR_PHY_TX_DESIRED_SCALE_CCK_S		10	/* XXX should be 9? */
#define AR_PHY_TX_PWRCTRL9_RES_DC_REMOVAL	0x80000000

/* Bits for AR_PHY_TX_GAIN_TBL. */
#define AR_PHY_TX_GAIN_M	0x0007f000
#define AR_PHY_TX_GAIN_S	12

/* Bits for AR_PHY_SPUR_REG. */
#define AR_PHY_SPUR_REG_MASK_RATE_CNTL		0x03fc0000
#define AR_PHY_SPUR_REG_ENABLE_MASK_PPM		0x00020000
#define AR_PHY_SPUR_REG_MASK_RATE_SELECT	0x0001fe00
#define AR_PHY_SPUR_REG_ENABLE_VIT_SPUR_RSSI	0x00000100
#define AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_M	0x0000007f
#define AR_PHY_SPUR_REG_SPUR_RSSI_THRESH_S	0
#define AR_SPUR_RSSI_THRESH			40

/* Bits for AR_PHY_ANALOG_SWAP. */
#define AR_PHY_SWAP_ALT_CHAIN	0x00000040

/* Bits for AR_PHY_TPCRG5. */
#define AR_PHY_TPCRG5_PD_GAIN_OVERLAP_M		0x0000000f
#define AR_PHY_TPCRG5_PD_GAIN_OVERLAP_S		0
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_1_M	0x000003f0
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_1_S	4
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_2_M	0x0000fc00
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_2_S	10
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_3_M	0x003f0000
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_3_S	16
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_4_M	0x0fc00000
#define AR_PHY_TPCRG5_PD_GAIN_BOUNDARY_4_S	22

/* Bits for AR_PHY_CL_CAL_CTL. */
#define AR_PHY_PARALLEL_CAL_ENABLE	0x00000001
#define AR_PHY_CL_CAL_ENABLE		0x00000002

/* Bits for AR_PHY_XPA_CFG. */
#define AR_PHY_FORCE_XPA_CFG	0x000000001

/* Bits for AR_PHY_CH[01]_TX_PWRCTRL11. */
#define AR_PHY_TX_PWRCTRL_OLPC_TEMP_COMP_M	0x0000fc00
#define AR_PHY_TX_PWRCTRL_OLPC_TEMP_COMP_S	10
#define AR_PHY_TX_PWRCTRL_OLPC_PWR_M		0x00ff0000
#define AR_PHY_TX_PWRCTRL_OLPC_PWR_S		16

/* Bits for AR_PHY_NEW_ADC_DC_GAIN_CORR. */
#define AR_PHY_NEW_ADC_DC_GAIN_QGAIN_M	0x0000003f
#define AR_PHY_NEW_ADC_DC_GAIN_QGAIN_S	0
#define AR_PHY_NEW_ADC_DC_GAIN_IGAIN_M	0x00000fc0
#define AR_PHY_NEW_ADC_DC_GAIN_IGAIN_S	6
#define AR_PHY_NEW_ADC_DC_GAIN_QDC_M	0x001ff000
#define AR_PHY_NEW_ADC_DC_GAIN_QDC_S	12
#define AR_PHY_NEW_ADC_DC_GAIN_IDC_M	0x3fe00000
#define AR_PHY_NEW_ADC_DC_GAIN_IDC_S	21

#define AR_BASE_PHY_ACTIVE_DELAY	100

#define AR_CLOCK_RATE_CCK	22
#define AR_CLOCK_RATE_5GHZ_OFDM	40
#define AR_CLOCK_RATE_2GHZ_OFDM	44

#define AR_PWR_DECREASE_FOR_2_CHAIN	6	/* 10 * log10(2) * 2 */
#define AR_PWR_DECREASE_FOR_3_CHAIN	9	/* 10 * log10(3) * 2 */

#define AR_SLEEP_SLOP	3	/* TUs */

#define AR_MIN_BEACON_TIMEOUT_VAL	1
#define AR_FUDGE			2
/* Divides by 1024 (usecs to TU) without doing 64-bit arithmetic. */
#define AR_TSF_TO_TU(hi, lo)	((hi) << 22 | (lo) >> 10)

#define AR_KEY_CACHE_SIZE		128
#define AR_RSVD_KEYTABLE_ENTRIES	4

#define AR_CAL_SAMPLES	64	/* XXX AR9280? */
#define AR_MAX_LOG_CAL	2	/* XXX AR9280? */

/*
 * Tx DMA descriptor.
 */
struct ar_tx_desc {
	uint32_t	ds_link;
	uint32_t	ds_data;
	uint32_t	ds_ctl0;
	uint32_t	ds_ctl1;
	uint32_t	ds_ctl2;
	uint32_t	ds_ctl3;
	uint32_t	ds_ctl4;
	uint32_t	ds_ctl5;
	uint32_t	ds_ctl6;
	uint32_t	ds_ctl7;
	uint32_t	ds_ctl8;
	uint32_t	ds_ctl9;
	uint32_t	ds_ctl10;
	uint32_t	ds_ctl11;
	uint32_t	ds_status0;
	uint32_t	ds_status1;
	uint32_t	ds_tstamp;
	uint32_t	ds_ba_bitmap_lo;
	uint32_t	ds_ba_bitmap_hi;
	uint32_t	ds_evm0;
	uint32_t	ds_evm1;
	uint32_t	ds_evm2;
	uint32_t	ds_status8;
	uint32_t	ds_status9;
	/*
	 * Padding to make Tx descriptors 128 bytes such that they will
	 * not cross a 4KB boundary.
	 */
	uint32_t	pad[8];
} __packed;

/* Bits for ds_ctl0. */
#define AR_TXC0_FRAME_LEN_M		0x00000fff
#define AR_TXC0_FRAME_LEN_S		0
#define AR_TXC0_VIRT_MORE_FRAG		0x00001000
#define AR_TXC0_XMIT_POWER_M		0x003f0000
#define AR_TXC0_XMIT_POWER_S		16
#define AR_TXC0_RTS_ENABLE		0x00400000
#define AR_TXC0_VEOL			0x00800000
#define AR_TXC0_CLR_DEST_MASK		0x01000000
#define AR_TXC0_INTR_REQ		0x20000000
#define AR_TXC0_DEST_IDX_VALID		0x40000000
#define AR_TXC0_CTS_ENABLE		0x80000000

/* Bits for ds_ctl1. */
#define AR_TXC1_BUF_LEN_M		0x00000fff
#define AR_TXC1_BUF_LEN_S		0
#define AR_TXC1_MORE			0x00001000
#define AR_TXC1_DEST_IDX_M		0x000fe000
#define AR_TXC1_DEST_IDX_S		13
#define AR_TXC1_FRAME_TYPE_M		0x00f00000
#define AR_TXC1_FRAME_TYPE_S		20
#define AR_FRAME_TYPE_NORMAL		0
#define AR_FRAME_TYPE_ATIM		1
#define AR_FRAME_TYPE_PSPOLL		2
#define AR_FRAME_TYPE_BEACON		3
#define AR_FRAME_TYPE_PROBE_RESP	4
#define AR_TXC1_NO_ACK			0x01000000
#define AR_TXC1_INSERT_TS		0x02000000
#define AR_TXC1_EXT_ONLY		0x08000000
#define AR_TXC1_EXT_AND_CTL		0x10000000
#define AR_TXC1_MORE_AGGR		0x20000000
#define AR_TXC1_IS_AGGR			0x40000000

/* Bits for ds_ctl2. */
#define AR_TXC2_BURST_DUR_M		0x00007fff
#define AR_TXC2_BURST_DUR_S		0
#define AR_TXC2_DUR_UPDATE_ENA		0x00008000
#define AR_TXC2_XMIT_DATA_TRIES0_M	0x000f0000
#define AR_TXC2_XMIT_DATA_TRIES0_S	16
#define AR_TXC2_XMIT_DATA_TRIES1_M	0x00f00000
#define AR_TXC2_XMIT_DATA_TRIES1_S	20
#define AR_TXC2_XMIT_DATA_TRIES2_M	0x0f000000
#define AR_TXC2_XMIT_DATA_TRIES2_S	24
#define AR_TXC2_XMIT_DATA_TRIES3_M	0xf0000000
#define AR_TXC2_XMIT_DATA_TRIES3_S	28

/* Bits for ds_ctl3. */
#define AR_TXC3_XMIT_RATE0_M		0x000000ff
#define AR_TXC3_XMIT_RATE0_S		0
#define AR_TXC3_XMIT_RATE1_M		0x0000ff00
#define AR_TXC3_XMIT_RATE1_S		8
#define AR_TXC3_XMIT_RATE2_M		0x00ff0000
#define AR_TXC3_XMIT_RATE2_S		16
#define AR_TXC3_XMIT_RATE3_M		0xff000000
#define AR_TXC3_XMIT_RATE3_S		24

/* Bits for ds_ctl4. */
#define AR_TXC4_PACKET_DUR0_M		0x00007fff
#define AR_TXC4_PACKET_DUR0_S		0
#define AR_TXC4_RTSCTS_QUAL0		0x00008000
#define AR_TXC4_PACKET_DUR1_M		0x7fff0000
#define AR_TXC4_PACKET_DUR1_S		16
#define AR_TXC4_RTSCTS_QUAL1		0x80000000
/* Shortcut. */
#define AR_TXC4_RTSCTS_QUAL01	\
	(AR_TXC4_RTSCTS_QUAL0 | AR_TXC4_RTSCTS_QUAL1)

/* Bits for ds_ctl5. */
#define AR_TXC5_PACKET_DUR2_M		0x00007fff
#define AR_TXC5_PACKET_DUR2_S		0
#define AR_TXC5_RTSCTS_QUAL2		0x00008000
#define AR_TXC5_PACKET_DUR3_M		0x7fff0000
#define AR_TXC5_PACKET_DUR3_S		16
#define AR_TXC5_RTSCTS_QUAL3		0x80000000
/* Shortcut. */
#define AR_TXC5_RTSCTS_QUAL23	\
	(AR_TXC5_RTSCTS_QUAL2 | AR_TXC5_RTSCTS_QUAL3)

/* Bits for ds_ctl6. */
#define AR_TXC6_AGGR_LEN_M		0x0000ffff
#define AR_TXC6_AGGR_LEN_S		0
#define AR_TXC6_PAD_DELIM_M		0x03fc0000
#define AR_TXC6_PAD_DELIM_S		18
#define AR_TXC6_ENCR_TYPE_M		0x0c000000
#define AR_TXC6_ENCR_TYPE_S		26
#define AR_ENCR_TYPE_CLEAR		0
#define AR_ENCR_TYPE_WEP		1
#define AR_ENCR_TYPE_AES		2
#define AR_ENCR_TYPE_TKIP		3

/* Bits for ds_ctl7. */
#define AR_TXC7_2040_0			0x00000001
#define AR_TXC7_GI0			0x00000002
#define AR_TXC7_CHAIN_SEL0_M		0x0000001c
#define AR_TXC7_CHAIN_SEL0_S		2
#define AR_TXC7_2040_1			0x00000020
#define AR_TXC7_GI1			0x00000040
#define AR_TXC7_CHAIN_SEL1_M		0x00000380
#define AR_TXC7_CHAIN_SEL1_S		7
#define AR_TXC7_2040_2			0x00000400
#define AR_TXC7_GI2			0x00000800
#define AR_TXC7_CHAIN_SEL2_M		0x00007000
#define AR_TXC7_CHAIN_SEL2_S		12
#define AR_TXC7_2040_3			0x00008000
#define AR_TXC7_GI3			0x00010000
#define AR_TXC7_CHAIN_SEL3_M		0x000e0000
#define AR_TXC7_CHAIN_SEL3_S		17
#define AR_TXC7_RTSCTS_RATE_M		0x0ff00000
#define AR_TXC7_RTSCTS_RATE_S		20
/* Shortcuts. */
#define AR_TXC7_2040_0123	\
	(AR_TXC7_2040_0 | AR_TXC7_2040_1 | AR_TXC7_2040_2 | AR_TXC7_2040_3)
#define AR_TXC7_GI0123		\
	(AR_TXC7_GI0 | AR_TXC7_GI1 | AR_TXC7_GI2 | AR_TXC7_GI3)

/* Bits for ds_status0. */
#define AR_TXS0_RSSI_ANT0(i)		(((x) >> ((i) * 8)) & 0xff)
#define AR_TXS0_BA_STATUS		0x40000000

/* Bits for ds_status1. */
#define AR_TXS1_FRM_XMIT_OK		0x00000001
#define AR_TXS1_EXCESSIVE_RETRIES	0x00000002
#define AR_TXS1_FIFO_UNDERRUN		0x00000004
#define AR_TXS1_FILTERED		0x00000008
#define AR_TXS1_RTS_FAIL_CNT_M		0x000000f0
#define AR_TXS1_RTS_FAIL_CNT_S		4
#define AR_TXS1_DATA_FAIL_CNT_M		0x00000f00
#define AR_TXS1_DATA_FAIL_CNT_S		8
#define AR_TXS1_VIRT_RETRY_CNT_M	0x0000f000
#define AR_TXS1_VIRT_RETRY_CNT_S	12
#define AR_TXS1_TX_DELIM_UNDERRUN	0x00010000
#define AR_TXS1_TX_DATA_UNDERRUN	0x00020000
#define AR_TXS1_DESC_CFG_ERR		0x00040000
#define AR_TXS1_TX_TIMER_EXPIRED	0x00080000
/* Shortcuts. */
#define AR_TXS1_UNDERRUN		\
	(AR_TXS1_FIFO_UNDERRUN |	\
	 AR_TXS1_TX_DELIM_UNDERRUN |	\
	 AR_TXS1_TX_DATA_UNDERRUN)

/* Bits for ds_status9. */
#define AR_TXS9_DONE			0x00000001
#define AR_TXS9_SEQNUM_M		0x00001ffe
#define AR_TXS9_SEQNUM_S		1
#define AR_TXS9_TXOP_EXCEEDED		0x00020000
#define AR_TXS9_FINAL_IDX_M		0x00600000
#define AR_TXS9_FINAL_IDX_S		21
#define AR_TXS9_POWER_MGMT		0x02000000

/*
 * Rx DMA descriptor.
 */
struct ar_rx_desc {
	uint32_t	ds_link;
	uint32_t	ds_data;
	uint32_t	ds_ctl0;
	uint32_t	ds_ctl1;
	uint32_t	ds_status0;
	uint32_t	ds_status1;
	uint32_t	ds_status2;
	uint32_t	ds_status3;
	uint32_t	ds_status4;
	uint32_t	ds_status5;
	uint32_t	ds_status6;
	uint32_t	ds_status7;
	uint32_t	ds_status8;
	/*
	 * Padding to make Rx descriptors 64 bytes such that they will
	 * not cross a 4KB boundary.
	 */
	uint32_t	pad[3];
} __packed;

/* Bits for ds_ctl1. */
#define AR_RXC1_BUF_LEN_M		0x00000fff
#define AR_RXC1_BUF_LEN_S		0
#define AR_RXC1_INTR_REQ		0x00002000

/* Bits for ds_ctl2. */
#define AR_RXS0_RSSI_ANT00(x)		(((x) >>  0) & 0xff)
#define AR_RXS0_RSSI_ANT01(x)		(((x) >>  8) & 0xff)
#define AR_RXS0_RSSI_ANT02(x)		(((x) >> 16) & 0xff)
#define AR_RXS0_RATE_M			0xff000000
#define AR_RXS0_RATE_S			24

/* Bits for ds_status1. */
#define AR_RXS1_DATA_LEN_M		0x00000fff
#define AR_RXS1_DATA_LEN_S		0
#define AR_RXS1_MORE			0x00001000

/* Bits for ds_status3. */
#define AR_RXS3_GI			0x00000001
#define AR_RXS3_2040			0x00000002
#define AR_RXS3_PARALLEL_40		0x00000004
#define AR_RXS3_ANTENNA_M		0xffffff00
#define AR_RXS3_ANTENNA_S		8
#define AR_RXS3_RATE_M			0x000003fc
#define AR_RXS3_RATE_S			2

/* Bits for ds_status4. */
#define AR_RXS4_RSSI_COMBINED_M		0xff000000
#define AR_RXS4_RSSI_COMBINED_S		24

/* Bits for ds_status8. */
#define AR_RXS8_DONE			0x00000001
#define AR_RXS8_FRAME_OK		0x00000002
#define AR_RXS8_CRC_ERR			0x00000004
#define AR_RXS8_DECRYPT_CRC_ERR		0x00000008
#define AR_RXS8_PHY_ERR			0x00000010
#define AR_RXS8_MICHAEL_ERR		0x00000020
#define AR_RXS8_PRE_DELIM_CRC_ERR	0x00000040
#define AR_RXS8_PHY_ERR_CODE_M		0x0000ff00
#define AR_RXS8_PHY_ERR_CODE_S		8
#define AR_RXS8_KEY_IDX_VALID		0x00000100
#define AR_RXS8_KEY_IDX_M		0x0000fe00
#define AR_RXS8_KEY_IDX_S		9
#define AR_RXS8_POST_DELIM_CRC_ERR	0x00040000
#define AR_RXS8_DECRYPT_BUSY_ERR	0x40000000


/* Maximum number of chains supported by any chipset. */
#define AR_MAX_CHAINS	3

/* Default number of key cache entries. */
#define AR_KEYTABLE_SIZE	128

/* GPIO pins. */
#define AR_GPIO_WLANACTIVE_PIN	5
#define AR_GPIO_BTACTIVE_PIN	6
#define AR_GPIO_BTPRIORITY_PIN	7

/* XXX need to cleanup that mess. */
#define AR_SREV_5416(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_5416_PCI || \
	 (sc)->mac_ver == AR_SREV_VERSION_5416_PCIE)
#define AR_SREV_5416_20_OR_LATER(sc) \
	((AR_SREV_5416(sc) && \
	  (sc)->mac_rev >= AR_SREV_REVISION_5416_20) || \
	 (sc)->mac_ver >= AR_SREV_VERSION_9100)
#define AR_SREV_5416_22_OR_LATER(sc) \
	((AR_SREV_5416(sc) && \
	  (sc)->mac_rev >= AR_SREV_REVISION_5416_22) || \
	 (sc)->mac_ver >= AR_SREV_VERSION_9100)

#define AR_SREV_9160(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9160)
#define AR_SREV_9160_10_OR_LATER(sc) \
	((sc)->mac_ver >= AR_SREV_VERSION_9160)
#define AR_SREV_9160_11(sc) \
	(AR_SREV_9160(sc) && \
	 (sc)->mac_rev == AR_SREV_REVISION_9160_11)

#define AR_SREV_9280(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9280)
#define AR_SREV_9280_10_OR_LATER(sc) \
	((sc)->mac_ver >= AR_SREV_VERSION_9280)
#define AR_SREV_9280_10(sc) \
	(AR_SREV_9280(sc) && \
	 (sc)->mac_rev == AR_SREV_REVISION_9280_10)
#define AR_SREV_9280_20(sc) \
	(AR_SREV_9280(sc) && \
	 (sc)->mac_rev >= AR_SREV_REVISION_9280_20)
#define AR_SREV_9280_20_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9280 || \
	 (AR_SREV_9280(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9280_20))

#define AR_SREV_9285(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9285)
#define AR_SREV_9285_10_OR_LATER(sc) \
	((sc)->mac_ver >= AR_SREV_VERSION_9285)
#define AR_SREV_9285_11(sc) \
	(AR_SREV_9285(sc) && \
	 (sc)->mac_rev == AR_SREV_REVISION_9285_11)
#define AR_SREV_9285_11_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9285 || \
	 (AR_SREV_9285(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9285_11))
#define AR_SREV_9285_12(sc) \
	(AR_SREV_9285(sc) && \
	 ((sc)->mac_rev == AR_SREV_REVISION_9285_12))
#define AR_SREV_9285_12_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9285 || \
	 (AR_SREV_9285(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9285_12))

#define AR_SREV_9287(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9287)
#define AR_SREV_9287_10_OR_LATER(sc) \
	((sc)->mac_ver >= AR_SREV_VERSION_9287)
#define AR_SREV_9287_10(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9287 && \
	 (sc)->mac_rev == AR_SREV_REVISION_9287_10)
#define AR_SREV_9287_11(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9287 && \
	 (sc)->mac_rev == AR_SREV_REVISION_9287_11)
#define AR_SREV_9287_11_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9287 || \
	 (AR_SREV_9287(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9287_11))
#define AR_SREV_9287_12(sc) \
	((sc)->mac_ver == AR_SREV_VERSION_9287 && \
	 (sc)->mac_rev == AR_SREV_REVISION_9287_12)
#define AR_SREV_9287_12_OR_LATER(sc) \
	((sc)->mac_ver > AR_SREV_VERSION_9287 || \
	 (AR_SREV_9287(sc) && (sc)->mac_rev >= AR_SREV_REVISION_9287_12))

#define AR_SINGLE_CHIP(sc)	AR_SREV_9280_10_OR_LATER(sc)

#define AR_RADIO_SREV_MAJOR	0xf0
#define AR_RAD5133_SREV_MAJOR	0xc0
#define AR_RAD2133_SREV_MAJOR	0xd0
#define AR_RAD5122_SREV_MAJOR	0xe0
#define AR_RAD2122_SREV_MAJOR	0xf0

/*
 * Common ROM structures.
 */
#define AR_EEPROM_MAGIC_OFFSET	0x0000
#if BYTE_ORDER == BIG_ENDIAN
#define AR_EEPROM_MAGIC		0x5aa5
#else
#define AR_EEPROM_MAGIC		0xa55a
#endif

#define AR_BCHAN_UNUSED		0xff
#define AR_NO_SPUR		0x8000

#define AR_NUM_PDADC_VALUES	128
#define AR_PD_GAINS_IN_MASK	4	/* NB: Max for all chips. */

#define AR_MAX_PWR_RANGE_IN_HALF_DB	64

#define AR_MAX_RATE_POWER	63

#define AR_HT40_POWER_INC_FOR_PDADC	2

#define AR_EEPROM_MODAL_SPURS	5

#define AR_BASE_FREQ_2GHZ	2300
#define AR_BASE_FREQ_5GHZ	4900

#define AR_PWR_TABLE_OFFSET_DB		(-5)

/* XXX does not belong here!!! */
#define AR9285_PD_GAIN_BOUNDARY_DEFAULT	58
#define AR9280_TX_GAIN_TABLE_SIZE	22

#define AR_EEP_TXGAIN_ORIGINAL		0
#define AR_EEP_TXGAIN_HIGH_POWER	1

/*
 * ROM header that is common to all existing ROM layouts.
 */
struct ar_base_eep_header {
	uint16_t	length;
	uint16_t	checksum;
	uint16_t	version;
#define AR_EEP_VER			0xe
#define AR_EEP_VER_MINOR_MASK		0x0fff
#define AR_EEP_MINOR_VER_2		2
#define AR_EEP_MINOR_VER_3		3
#define AR_EEP_MINOR_VER_7		7
#define AR_EEP_MINOR_VER_9		9
#define AR_EEP_MINOR_VER_10		10
#define AR_EEP_MINOR_VER_16		16
#define AR_EEP_MINOR_VER_17		17
#define AR_EEP_MINOR_VER_19		19
#define AR_EEP_MINOR_VER_20		20
#define AR_EEP_MINOR_VER_21		21
#define AR_EEP_MINOR_VER_22		22

	uint8_t		opCapFlags;
#define AR_OPFLAGS_11A			0x01
#define AR_OPFLAGS_11G			0x02
#define AR_OPFLAGS_11N_5G40		0x04
#define AR_OPFLAGS_11N_2G40		0x08
#define AR_OPFLAGS_11N_5G20		0x10
#define AR_OPFLAGS_11N_2G20		0x20
/* Shortcut. */
#define AR_OPFLAGS_11N			0x3c

	uint8_t		eepMisc;
	uint16_t	regDmn[2];
	uint8_t		macAddr[6];
	uint8_t		rxMask;
	uint8_t		txMask;
	uint16_t	rfSilent;
#define AR_EEP_RFSILENT_ENABLED		0x0001
#define AR_EEP_RFSILENT_GPIO_SEL_M	0x001c
#define AR_EEP_RFSILENT_GPIO_SEL_S	2
#define AR_EEP_RFSILENT_POLARITY	0x0002

	uint16_t	blueToothOptions;
	uint16_t	deviceCap;
#define AR_EEP_DEVCAP_COMPRESS_DIS	0x0001
#define AR_EEP_DEVCAP_AES_DIS		0x0002
#define AR_EEP_DEVCAP_FASTFRAME_DIS	0x0004
#define AR_EEP_DEVCAP_BURST_DIS		0x0008
#define AR_EEP_DEVCAP_MAXQCU_M		0x01f0
#define AR_EEP_DEVCAP_MAXQCU_S		4
#define AR_EEP_DEVCAP_HEAVY_CLIP_EN	0x0200
#define AR_EEP_DEVCAP_KC_ENTRIES_M	0xf000
#define AR_EEP_DEVCAP_KC_ENTRIES_S	12

	uint32_t	binBuildNumber;
	uint8_t		deviceType;
} __packed;

struct ar_spur_chan {
	uint16_t	spurChan;
	uint8_t		spurRangeLow;
	uint8_t		spurRangeHigh;
} __packed;

struct ar_cal_data_per_freq_olpc {
	uint8_t	pwrPdg[2][5];
	uint8_t	vpdPdg[2][5];
	uint8_t	pcdac[2][5];
	uint8_t	empty[2][5];
} __packed;

struct ar_cal_target_power_leg {
	uint8_t	bChannel;
	uint8_t	tPow2x[4];
} __packed;

struct ar_cal_target_power_ht {
	uint8_t	bChannel;
	uint8_t	tPow2x[8];
} __packed;

struct ar_cal_ctl_edges {
	uint8_t	bChannel;
	uint8_t	tPowerFlag;
#define AR_CAL_CTL_EDGES_POWER_M	0x3f
#define AR_CAL_CTL_EDGES_POWER_S	0
#define AR_CAL_CTL_EDGES_FLAG_M		0xc0
#define AR_CAL_CTL_EDGES_FLAG_S		6
} __packed;

#define AR_SD_NO_CTL	0xe0
#define AR_NO_CTL	0xff
#define AR_CTL_MODE_M	0x07
#define AR_CTL_MODE_S	0
#define AR_CTL_11A	0
#define AR_CTL_11B	1
#define AR_CTL_11G	2
#define AR_CTL_2GHT20	5
#define AR_CTL_5GHT20	6
#define AR_CTL_2GHT40	7
#define AR_CTL_5GHT40	8

/*
 * Serializer/Deserializer programming for non-PCIe devices.
 */
static const uint32_t ar_nonpcie_serdes[] = {
	0x9248fc00,
	0x24924924,
	0x28000029,
	0x57160824,
	0x25980579,
	0x00000000,
	0x1aaabe40,
	0xbe105554,
	0x000e1007
};

/*
 * Macros to access registers.
 */
#define AR_READ(sc, reg)						\
	bus_space_read_4((sc)->sc_st, (sc)->sc_sh, (reg))

#define AR_WRITE(sc, reg, val)						\
	bus_space_write_4((sc)->sc_st, (sc)->sc_sh, (reg), (val))

#define AR_SETBITS(sc, reg, mask)					\
	AR_WRITE(sc, reg, AR_READ(sc, reg) | (mask))

#define AR_CLRBITS(sc, reg, mask)					\
	AR_WRITE(sc, reg, AR_READ(sc, reg) & ~(mask))

/*
 * Macros to access subfields in registers.
 */
/* Mask and Shift (getter). */
#define MS(val, field)							\
	(((val) & field##_M) >> field##_S)

/* Shift and Mask (setter). */
#define SM(field, val)							\
	(((val) << field##_S) & field##_M)

/* Rewrite. */
#define RW(var, field, val)						\
	(((var) & ~field##_M) | SM(field, val))
