require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&LOFN_BAR0)) {
    sub LOFN_BAR0 () {	0x10;}
}
unless(defined(&LOFN_WIN_0)) {
    sub LOFN_WIN_0 () {	0x;}
}
unless(defined(&LOFN_WIN_1)) {
    sub LOFN_WIN_1 () {	0x2000;}
}
unless(defined(&LOFN_WIN_2)) {
    sub LOFN_WIN_2 () {	0x4000;}
}
unless(defined(&LOFN_WIN_3)) {
    sub LOFN_WIN_3 () {	0x6000;}
}
unless(defined(&LOFN_REL_DATA)) {
    sub LOFN_REL_DATA () {	0x;}
}
unless(defined(&LOFN_REL_DATA_END)) {
    sub LOFN_REL_DATA_END () {	0x7ff;}
}
unless(defined(&LOFN_REL_LEN)) {
    sub LOFN_REL_LEN () {	0x1000;}
}
unless(defined(&LOFN_REL_LEN_REGS)) {
    sub LOFN_REL_LEN_REGS () {	0x103f;}
}
unless(defined(&LOFN_REL_RNG)) {
    sub LOFN_REL_RNG () {	0x1080;}
}
unless(defined(&LOFN_REL_RNG_END)) {
    sub LOFN_REL_RNG_END () {	0x10bf;}
}
unless(defined(&LOFN_REL_INSTR)) {
    sub LOFN_REL_INSTR () {	0x1100;}
}
unless(defined(&LOFN_REL_INSTR_END)) {
    sub LOFN_REL_INSTR_END () {	0x117f;}
}
unless(defined(&LOFN_REL_CR)) {
    sub LOFN_REL_CR () {	0x1fd4;}
}
unless(defined(&LOFN_REL_SR)) {
    sub LOFN_REL_SR () {	0x1fd8;}
}
unless(defined(&LOFN_REL_IER)) {
    sub LOFN_REL_IER () {	0x1fdc;}
}
unless(defined(&LOFN_REL_RNC)) {
    sub LOFN_REL_RNC () {	0x1fe0;}
}
unless(defined(&LOFN_REL_CFG1)) {
    sub LOFN_REL_CFG1 () {	0x1fe4;}
}
unless(defined(&LOFN_REL_CFG2)) {
    sub LOFN_REL_CFG2 () {	0x1fe8;}
}
unless(defined(&LOFN_REL_CHIPID)) {
    sub LOFN_REL_CHIPID () {	0x1fec;}
}
unless(defined(&LOFN_REG_MASK)) {
    sub LOFN_REG_MASK () {	0xf80;}
}
unless(defined(&LOFN_REG_SHIFT)) {
    sub LOFN_REG_SHIFT () {	7;}
}
unless(defined(&LOFN_WORD_MASK)) {
    sub LOFN_WORD_MASK () {	0x7c;}
}
unless(defined(&LOFN_WORD_SHIFT)) {
    sub LOFN_WORD_SHIFT () {	2;}
}
unless(defined(&LOFN_CR_ADDR_MASK)) {
    sub LOFN_CR_ADDR_MASK () {	0x3f;}
}
unless(defined(&LOFN_SR_CARRY)) {
    sub LOFN_SR_CARRY () {	0x8;}
}
unless(defined(&LOFN_SR_RNG_UF)) {
    sub LOFN_SR_RNG_UF () {	0x1000;}
}
unless(defined(&LOFN_SR_RNG_RDY)) {
    sub LOFN_SR_RNG_RDY () {	0x4000;}
}
unless(defined(&LOFN_SR_DONE)) {
    sub LOFN_SR_DONE () {	0x8000;}
}
unless(defined(&LOFN_IER_RDY)) {
    sub LOFN_IER_RDY () {	0x4000;}
}
unless(defined(&LOFN_IER_DONE)) {
    sub LOFN_IER_DONE () {	0x8000;}
}
unless(defined(&LOFN_RNC_OUTSCALE)) {
    sub LOFN_RNC_OUTSCALE () {	0x80;}
}
unless(defined(&LOFN_RNC_1STSCALE)) {
    sub LOFN_RNC_1STSCALE () {	0xf00;}
}
unless(defined(&LOFN_CFG1_RESET)) {
    sub LOFN_CFG1_RESET () {	0x1;}
}
unless(defined(&LOFN_CFG1_MULTI)) {
    sub LOFN_CFG1_MULTI () {	0x38;}
}
unless(defined(&LOFN_CFG1_MULTI_BYP)) {
    sub LOFN_CFG1_MULTI_BYP () {	0x;}
}
unless(defined(&LOFN_CFG1_MULTI_1X)) {
    sub LOFN_CFG1_MULTI_1X () {	0x8;}
}
unless(defined(&LOFN_CFG1_MULTI_15X)) {
    sub LOFN_CFG1_MULTI_15X () {	0x10;}
}
unless(defined(&LOFN_CFG1_MULTI_2X)) {
    sub LOFN_CFG1_MULTI_2X () {	0x18;}
}
unless(defined(&LOFN_CFG1_MULTI_25X)) {
    sub LOFN_CFG1_MULTI_25X () {	0x20;}
}
unless(defined(&LOFN_CFG1_MULTI_3X)) {
    sub LOFN_CFG1_MULTI_3X () {	0x28;}
}
unless(defined(&LOFN_CFG1_MULTI_4X)) {
    sub LOFN_CFG1_MULTI_4X () {	0x30;}
}
unless(defined(&LOFN_CFG1_CLOCK)) {
    sub LOFN_CFG1_CLOCK () {	0x40;}
}
unless(defined(&LOFN_CFG2_RNGENA)) {
    sub LOFN_CFG2_RNGENA () {	0x1;}
}
unless(defined(&LOFN_CFG2_PRCENA)) {
    sub LOFN_CFG2_PRCENA () {	0x2;}
}
unless(defined(&LOFN_CHIPID_MASK)) {
    sub LOFN_CHIPID_MASK () {	0xffff;}
}
unless(defined(&LOFN_REGADDR)) {
    sub LOFN_REGADDR {
	my($win,$r,$idx) = @_;
	eval q((($win) | ((($r) <<  &LOFN_REG_SHIFT) &  &LOFN_REG_MASK) | ((($idx) <<  &LOFN_WORD_SHIFT) &  &LOFN_WORD_MASK)));
    }
}
unless(defined(&LOFN_LENADDR)) {
    sub LOFN_LENADDR {
	my($win,$r) = @_;
	eval q((($win) | ((($r) << 2) +  &LOFN_REL_LEN)));
    }
}
unless(defined(&LOFN_LENMASK)) {
    sub LOFN_LENMASK () {	0x7ff;}
}
unless(defined(&OP_DONE)) {
    sub OP_DONE () {	0x80000000;}
}
unless(defined(&OP_CODE_MASK)) {
    sub OP_CODE_MASK () {	0x7c000000;}
}
unless(defined(&OP_CODE_MODEXP)) {
    sub OP_CODE_MODEXP () {	0x;}
}
unless(defined(&OP_CODE_MODMUL)) {
    sub OP_CODE_MODMUL () {	0x4000000;}
}
unless(defined(&OP_CODE_MODRED)) {
    sub OP_CODE_MODRED () {	0x8000000;}
}
unless(defined(&OP_CODE_MODADD)) {
    sub OP_CODE_MODADD () {	0xc000000;}
}
unless(defined(&OP_CODE_MODSUB)) {
    sub OP_CODE_MODSUB () {	0x10000000;}
}
unless(defined(&OP_CODE_ADD)) {
    sub OP_CODE_ADD () {	0x14000000;}
}
unless(defined(&OP_CODE_SUB)) {
    sub OP_CODE_SUB () {	0x18000000;}
}
unless(defined(&OP_CODE_ADDC)) {
    sub OP_CODE_ADDC () {	0x1c000000;}
}
unless(defined(&OP_CODE_SUBC)) {
    sub OP_CODE_SUBC () {	0x20000000;}
}
unless(defined(&OP_CODE_MULT)) {
    sub OP_CODE_MULT () {	0x24000000;}
}
unless(defined(&OP_CODE_SR)) {
    sub OP_CODE_SR () {	0x28000000;}
}
unless(defined(&OP_CODE_SL)) {
    sub OP_CODE_SL () {	0x2c000000;}
}
unless(defined(&OP_CODE_INC)) {
    sub OP_CODE_INC () {	0x30000000;}
}
unless(defined(&OP_CODE_DEC)) {
    sub OP_CODE_DEC () {	0x34000000;}
}
unless(defined(&OP_CODE_TAG)) {
    sub OP_CODE_TAG () {	0x38000000;}
}
unless(defined(&OP_CODE_NOP)) {
    sub OP_CODE_NOP () {	0x7c000000;}
}
unless(defined(&OP_RD_SHIFT)) {
    sub OP_RD_SHIFT () {	21;}
}
unless(defined(&OP_RA_SHIFT)) {
    sub OP_RA_SHIFT () {	16;}
}
unless(defined(&OP_RB_SHIFT)) {
    sub OP_RB_SHIFT () {	11;}
}
unless(defined(&OP_RM_SHIFT)) {
    sub OP_RM_SHIFT () {	6;}
}
unless(defined(&OP_R_MASK)) {
    sub OP_R_MASK () {	0x1f;}
}
unless(defined(&OP_LEN_MASK)) {
    sub OP_LEN_MASK () {	0xffff;}
}
unless(defined(&LOFN_INSTR)) {
    sub LOFN_INSTR {
	my($done,$op,$rd,$ra,$rb,$rm) = @_;
	eval q((($done) | ($op) | ((($rd) &  &OP_R_MASK) <<  &OP_RD_SHIFT) | ((($ra) &  &OP_R_MASK) <<  &OP_RA_SHIFT) | ((($rb) &  &OP_R_MASK) <<  &OP_RB_SHIFT) | ((($rm) &  &OP_R_MASK) <<  &OP_RM_SHIFT)));
    }
}
unless(defined(&LOFN_INSTR2)) {
    sub LOFN_INSTR2 {
	my($done,$op,$rd,$ra,$len) = @_;
	eval q((($done) | ($op) | ((($rd) &  &OP_R_MASK) <<  &OP_RD_SHIFT) | ((($ra) &  &OP_R_MASK) <<  &OP_RA_SHIFT) | (($len) &  &OP_LEN_MASK)));
    }
}
1;
