require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&TULIP_CSR_READ)) {
    sub TULIP_CSR_READ {
	my($sc, $csr) = @_;
	eval q( &bus_space_read_4(($sc)-> &tulip_bustag, ($sc)-> &tulip_bushandle, ($sc)-> ($tulip_csrs->{csr})));
    }
}
unless(defined(&TULIP_CSR_WRITE)) {
    sub TULIP_CSR_WRITE {
	my($sc, $csr, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &tulip_bustag, ($sc)-> &tulip_bushandle, ($sc)-> ($tulip_csrs->{csr}), ($val)));
    }
}
unless(defined(&TULIP_CSR_READBYTE)) {
    sub TULIP_CSR_READBYTE {
	my($sc, $csr) = @_;
	eval q( &bus_space_read_1(($sc)-> &tulip_bustag, ($sc)-> &tulip_bushandle, ($sc)-> ($tulip_csrs->{csr})));
    }
}
unless(defined(&TULIP_CSR_WRITEBYTE)) {
    sub TULIP_CSR_WRITEBYTE {
	my($sc, $csr, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &tulip_bustag, ($sc)-> &tulip_bushandle, ($sc)-> ($tulip_csrs->{csr}), ($val)));
    }
}
if(defined(&TULIP_IOMAPPED)) {
    eval 'sub TULIP_PCI_CSRSIZE () {8;}' unless defined(&TULIP_PCI_CSRSIZE);
    eval 'sub TULIP_PCI_CSROFFSET () {0;}' unless defined(&TULIP_PCI_CSROFFSET);
} else {
    eval 'sub TULIP_PCI_CSRSIZE () {8;}' unless defined(&TULIP_PCI_CSRSIZE);
    eval 'sub TULIP_PCI_CSROFFSET () {0;}' unless defined(&TULIP_PCI_CSROFFSET);
}
unless(defined(&csr_enetrom)) {
    sub csr_enetrom () {	 &csr_9;}
}
unless(defined(&csr_reserved)) {
    sub csr_reserved () {	 &csr_10;}
}
unless(defined(&csr_full_duplex)) {
    sub csr_full_duplex () {	 &csr_11;}
}
unless(defined(&csr_bootrom)) {
    sub csr_bootrom () {	 &csr_10;}
}
unless(defined(&csr_gp)) {
    sub csr_gp () {	 &csr_12;}
}
unless(defined(&csr_watchdog)) {
    sub csr_watchdog () {	 &csr_15;}
}
unless(defined(&csr_gp_timer)) {
    sub csr_gp_timer () {	 &csr_11;}
}
unless(defined(&csr_srom_mii)) {
    sub csr_srom_mii () {	 &csr_9;}
}
unless(defined(&csr_sia_status)) {
    sub csr_sia_status () {	 &csr_12;}
}
unless(defined(&csr_sia_connectivity)) {
    sub csr_sia_connectivity () {	 &csr_13;}
}
unless(defined(&csr_sia_tx_rx)) {
    sub csr_sia_tx_rx () {	 &csr_14;}
}
unless(defined(&csr_sia_general)) {
    sub csr_sia_general () {	 &csr_15;}
}
if(defined(&__STRICT_ALIGNMENT)) {
    eval 'sub TULIP_COPY_RXDATA () {1;}' unless defined(&TULIP_COPY_RXDATA);
}
unless(defined(&TULIP_DATA_PER_DESC)) {
    sub TULIP_DATA_PER_DESC () {	2032;}
}
unless(defined(&TULIP_TXTIMER)) {
    sub TULIP_TXTIMER () {	4;}
}
unless(defined(&TULIP_RXDESCS)) {
    sub TULIP_RXDESCS () {	48;}
}
unless(defined(&TULIP_TXDESCS)) {
    sub TULIP_TXDESCS () {	32;}
}
unless(defined(&TULIP_RXQ_TARGET)) {
    sub TULIP_RXQ_TARGET () {	32;}
}
if((defined(&TULIP_RXQ_TARGET) ? &TULIP_RXQ_TARGET : undef) >= (defined(&TULIP_RXDESCS) ? &TULIP_RXDESCS : undef)) {
    die("TULIP_RXQ_TARGET\ must\ be\ less\ than\ TULIP_RXDESCS");
}
unless(defined(&TULIP_RX_BUFLEN)) {
    sub TULIP_RX_BUFLEN () {	(( &MCLBYTES < 2048?  &MCLBYTES : 2048) - 16);}
}
eval("sub TULIP_21040 () { 0; }") unless defined(&TULIP_21040);
eval("sub TULIP_DE425 () { 1; }") unless defined(&TULIP_DE425);
eval("sub TULIP_21041 () { 2; }") unless defined(&TULIP_21041);
eval("sub TULIP_21140 () { 3; }") unless defined(&TULIP_21140);
eval("sub TULIP_21140A () { 4; }") unless defined(&TULIP_21140A);
eval("sub TULIP_21142 () { 5; }") unless defined(&TULIP_21142);
eval("sub TULIP_21143 () { 6; }") unless defined(&TULIP_21143);
eval("sub TULIP_CHIPID_UNKNOWN () { 7; }") unless defined(&TULIP_CHIPID_UNKNOWN);
eval("sub TULIP_MEDIA_UNKNOWN () { 0; }") unless defined(&TULIP_MEDIA_UNKNOWN);
eval("sub TULIP_MEDIA_10BASET () { 1; }") unless defined(&TULIP_MEDIA_10BASET);
eval("sub TULIP_MEDIA_10BASET_FD () { 2; }") unless defined(&TULIP_MEDIA_10BASET_FD);
eval("sub TULIP_MEDIA_BNC () { 3; }") unless defined(&TULIP_MEDIA_BNC);
eval("sub TULIP_MEDIA_AUI () { 4; }") unless defined(&TULIP_MEDIA_AUI);
eval("sub TULIP_MEDIA_EXTSIA () { 5; }") unless defined(&TULIP_MEDIA_EXTSIA);
eval("sub TULIP_MEDIA_AUIBNC () { 6; }") unless defined(&TULIP_MEDIA_AUIBNC);
eval("sub TULIP_MEDIA_100BASETX () { 7; }") unless defined(&TULIP_MEDIA_100BASETX);
eval("sub TULIP_MEDIA_100BASETX_FD () { 8; }") unless defined(&TULIP_MEDIA_100BASETX_FD);
eval("sub TULIP_MEDIA_100BASET4 () { 9; }") unless defined(&TULIP_MEDIA_100BASET4);
eval("sub TULIP_MEDIA_100BASEFX () { 10; }") unless defined(&TULIP_MEDIA_100BASEFX);
eval("sub TULIP_MEDIA_100BASEFX_FD () { 11; }") unless defined(&TULIP_MEDIA_100BASEFX_FD);
eval("sub TULIP_MEDIA_MAX () { 12; }") unless defined(&TULIP_MEDIA_MAX);
unless(defined(&TULIP_BIT)) {
    sub TULIP_BIT {
	my($b) = @_;
	eval q((1 << (($b))));
    }
}
unless(defined(&TULIP_FDBIT)) {
    sub TULIP_FDBIT {
	my($m) = @_;
	eval q((1 << ( &TULIP_MEDIA_  $m   &_FD)));
    }
}
unless(defined(&TULIP_MBIT)) {
    sub TULIP_MBIT {
	my($m) = @_;
	eval q((1 << ( &TULIP_MEDIA_  $m )));
    }
}
unless(defined(&TULIP_IS_MEDIA_FD)) {
    sub TULIP_IS_MEDIA_FD {
	my($m) = @_;
	eval q(( &TULIP_BIT($m) & ( &TULIP_FDBIT(10 &BASET) | &TULIP_FDBIT(100 &BASETX) | &TULIP_FDBIT(100 &BASEFX))));
    }
}
unless(defined(&TULIP_CAN_MEDIA_FD)) {
    sub TULIP_CAN_MEDIA_FD {
	my($m) = @_;
	eval q(( &TULIP_BIT($m) & ( &TULIP_MBIT(10 &BASET) | &TULIP_MBIT(100 &BASETX) | &TULIP_MBIT(100 &BASEFX))));
    }
}
unless(defined(&TULIP_FD_MEDIA_OF)) {
    sub TULIP_FD_MEDIA_OF {
	my($m) = @_;
	eval q((( &tulip_media_t)(($m) + 1)));
    }
}
unless(defined(&TULIP_HD_MEDIA_OF)) {
    sub TULIP_HD_MEDIA_OF {
	my($m) = @_;
	eval q((( &tulip_media_t)(($m) - 1)));
    }
}
unless(defined(&TULIP_IS_MEDIA_100MB)) {
    sub TULIP_IS_MEDIA_100MB {
	my($m) = @_;
	eval q((($m) >=  &TULIP_MEDIA_100BASETX));
    }
}
unless(defined(&TULIP_IS_MEDIA_TP)) {
    sub TULIP_IS_MEDIA_TP {
	my($m) = @_;
	eval q((( &TULIP_BIT($m) & ( &TULIP_MBIT( &BNC) | &TULIP_MBIT( &AUI) | &TULIP_MBIT( &AUIBNC) | &TULIP_MBIT( &EXTSIA))) == 0));
    }
}
unless(defined(&TULIP_SROM_ATTR_MII)) {
    sub TULIP_SROM_ATTR_MII () {	0x100;}
}
unless(defined(&TULIP_SROM_ATTR_NWAY)) {
    sub TULIP_SROM_ATTR_NWAY () {	0x200;}
}
unless(defined(&TULIP_SROM_ATTR_AUTOSENSE)) {
    sub TULIP_SROM_ATTR_AUTOSENSE () {	0x400;}
}
unless(defined(&TULIP_SROM_ATTR_POWERUP)) {
    sub TULIP_SROM_ATTR_POWERUP () {	0x800;}
}
unless(defined(&TULIP_SROM_ATTR_NOLINKPASS)) {
    sub TULIP_SROM_ATTR_NOLINKPASS () {	0x1000;}
}
eval("sub TULIP_MEDIAINFO_NONE () { 0; }") unless defined(&TULIP_MEDIAINFO_NONE);
eval("sub TULIP_MEDIAINFO_SIA () { 1; }") unless defined(&TULIP_MEDIAINFO_SIA);
eval("sub TULIP_MEDIAINFO_GPR () { 2; }") unless defined(&TULIP_MEDIAINFO_GPR);
eval("sub TULIP_MEDIAINFO_MII () { 3; }") unless defined(&TULIP_MEDIAINFO_MII);
eval("sub TULIP_MEDIAINFO_RESET () { 4; }") unless defined(&TULIP_MEDIAINFO_RESET);
eval("sub TULIP_MEDIAINFO_SYM () { 5; }") unless defined(&TULIP_MEDIAINFO_SYM);
unless(defined(&mi_sia_connectivity)) {
    sub mi_sia_connectivity () {	 ($mi_un->{un_sia}->{sia_connectivity});}
}
unless(defined(&mi_sia_tx_rx)) {
    sub mi_sia_tx_rx () {	 ($mi_un->{un_sia}->{sia_tx_rx});}
}
unless(defined(&mi_sia_general)) {
    sub mi_sia_general () {	 ($mi_un->{un_sia}->{sia_general});}
}
unless(defined(&mi_sia_gp_control)) {
    sub mi_sia_gp_control () {	 ($mi_un->{un_sia}->{sia_gp_control});}
}
unless(defined(&mi_sia_gp_data)) {
    sub mi_sia_gp_data () {	 ($mi_un->{un_sia}->{sia_gp_data});}
}
unless(defined(&mi_gpcontrol)) {
    sub mi_gpcontrol () {	 ($mi_un->{un_gpr}->{gpr_gpcontrol});}
}
unless(defined(&mi_gpdata)) {
    sub mi_gpdata () {	 ($mi_un->{un_gpr}->{gpr_gpdata});}
}
unless(defined(&mi_actmask)) {
    sub mi_actmask () {	 ($mi_un->{un_gpr}->{gpr_actmask});}
}
unless(defined(&mi_actdata)) {
    sub mi_actdata () {	 ($mi_un->{un_gpr}->{gpr_actdata});}
}
unless(defined(&mi_default)) {
    sub mi_default () {	 ($mi_un->{un_gpr}->{gpr_default});}
}
unless(defined(&mi_cmdmode)) {
    sub mi_cmdmode () {	 ($mi_un->{un_gpr}->{gpr_cmdmode});}
}
unless(defined(&mi_phyaddr)) {
    sub mi_phyaddr () {	 ($mi_un->{un_mii}->{mii_phyaddr});}
}
unless(defined(&mi_gpr_length)) {
    sub mi_gpr_length () {	 ($mi_un->{un_mii}->{mii_gpr_length});}
}
unless(defined(&mi_gpr_offset)) {
    sub mi_gpr_offset () {	 ($mi_un->{un_mii}->{mii_gpr_offset});}
}
unless(defined(&mi_reset_length)) {
    sub mi_reset_length () {	 ($mi_un->{un_mii}->{mii_reset_length});}
}
unless(defined(&mi_reset_offset)) {
    sub mi_reset_offset () {	 ($mi_un->{un_mii}->{mii_reset_offset});}
}
unless(defined(&mi_capabilities)) {
    sub mi_capabilities () {	 ($mi_un->{un_mii}->{mii_capabilities});}
}
unless(defined(&mi_advertisement)) {
    sub mi_advertisement () {	 ($mi_un->{un_mii}->{mii_advertisement});}
}
unless(defined(&mi_full_duplex)) {
    sub mi_full_duplex () {	 ($mi_un->{un_mii}->{mii_full_duplex});}
}
unless(defined(&mi_tx_threshold)) {
    sub mi_tx_threshold () {	 ($mi_un->{un_mii}->{mii_tx_threshold});}
}
unless(defined(&mi_mediamask)) {
    sub mi_mediamask () {	 ($mi_un->{un_mii}->{mii_mediamask});}
}
unless(defined(&mi_mii_interrupt)) {
    sub mi_mii_interrupt () {	 ($mi_un->{un_mii}->{mii_interrupt});}
}
unless(defined(&mi_phyid)) {
    sub mi_phyid () {	 ($mi_un->{un_mii}->{mii_phyid});}
}
unless(defined(&TULIP_MEDIAINFO_SIA_INIT)) {
    sub TULIP_MEDIAINFO_SIA_INIT {
	my($sc, $mi, $chipid, $media) = @_;
	eval q( &do { ($mi)-> &mi_type =  &TULIP_MEDIAINFO_SIA;  ($sc->{tulip_mediums[&TULIP_MEDIA_##media]}) = ($mi); ($mi)-> &mi_sia_connectivity =  &TULIP_  $chipid   &_SIACONN_  $media; ($mi)-> &mi_sia_tx_rx =  &TULIP_  $chipid   &_SIATXRX_  $media; ($mi)-> &mi_sia_general =  &TULIP_  $chipid   &_SIAGEN_  $media; }  &while (0));
    }
}
unless(defined(&TULIP_MEDIAINFO_ADD_CAPABILITY)) {
    sub TULIP_MEDIAINFO_ADD_CAPABILITY {
	my($sc, $mi, $media) = @_;
	eval q( &do {  &if (($sc)-> $tulip_mediums[ &TULIP_MEDIA_  $media] ==  &NULL  && (($mi)-> &mi_capabilities &  &PHYSTS_  $media)) { ($sc)-> $tulip_mediums[ &TULIP_MEDIA_  $media] = ($mi); ($mi)-> &mi_mediamask |=  &TULIP_BIT( &TULIP_MEDIA_  $media); } }  &while (0));
    }
}
unless(defined(&TULIP_MII_NOPHY)) {
    sub TULIP_MII_NOPHY () {	32;}
}
eval("sub TULIP_21040_GENERIC () { 0; }") unless defined(&TULIP_21040_GENERIC);
eval("sub TULIP_21140_ISV () { 1; }") unless defined(&TULIP_21140_ISV);
eval("sub TULIP_21142_ISV () { 2; }") unless defined(&TULIP_21142_ISV);
eval("sub TULIP_21143_ISV () { 3; }") unless defined(&TULIP_21143_ISV);
eval("sub TULIP_21140_DEC_EB () { 4; }") unless defined(&TULIP_21140_DEC_EB);
eval("sub TULIP_21140_MII () { 5; }") unless defined(&TULIP_21140_MII);
eval("sub TULIP_21140_DEC_DE500 () { 6; }") unless defined(&TULIP_21140_DEC_DE500);
eval("sub TULIP_21140_SMC_9332 () { 7; }") unless defined(&TULIP_21140_SMC_9332);
eval("sub TULIP_21140_COGENT_EM100 () { 8; }") unless defined(&TULIP_21140_COGENT_EM100);
eval("sub TULIP_21140_ZNYX_ZX34X () { 9; }") unless defined(&TULIP_21140_ZNYX_ZX34X);
eval("sub TULIP_21140_ASANTE () { 10; }") unless defined(&TULIP_21140_ASANTE);
eval("sub TULIP_21140_EN1207 () { 11; }") unless defined(&TULIP_21140_EN1207);
eval("sub TULIP_21041_GENERIC () { 12; }") unless defined(&TULIP_21041_GENERIC);
eval("sub TULIP_MEDIAPOLL_TIMER () { 0; }") unless defined(&TULIP_MEDIAPOLL_TIMER);
eval("sub TULIP_MEDIAPOLL_FASTTIMER () { 1; }") unless defined(&TULIP_MEDIAPOLL_FASTTIMER);
eval("sub TULIP_MEDIAPOLL_LINKFAIL () { 2; }") unless defined(&TULIP_MEDIAPOLL_LINKFAIL);
eval("sub TULIP_MEDIAPOLL_LINKPASS () { 3; }") unless defined(&TULIP_MEDIAPOLL_LINKPASS);
eval("sub TULIP_MEDIAPOLL_START () { 4; }") unless defined(&TULIP_MEDIAPOLL_START);
eval("sub TULIP_MEDIAPOLL_TXPROBE_OK () { 5; }") unless defined(&TULIP_MEDIAPOLL_TXPROBE_OK);
eval("sub TULIP_MEDIAPOLL_TXPROBE_FAILED () { 6; }") unless defined(&TULIP_MEDIAPOLL_TXPROBE_FAILED);
eval("sub TULIP_MEDIAPOLL_MAX () { 7; }") unless defined(&TULIP_MEDIAPOLL_MAX);
eval("sub TULIP_LINK_DOWN () { 0; }") unless defined(&TULIP_LINK_DOWN);
eval("sub TULIP_LINK_UP () { 1; }") unless defined(&TULIP_LINK_UP);
eval("sub TULIP_LINK_UNKNOWN () { 2; }") unless defined(&TULIP_LINK_UNKNOWN);
eval("sub PHY_MODE_10T () { 0; }") unless defined(&PHY_MODE_10T);
eval("sub PHY_MODE_100TX () { 1; }") unless defined(&PHY_MODE_100TX);
eval("sub PHY_MODE_100T4 () { 2; }") unless defined(&PHY_MODE_100T4);
eval("sub PHY_MODE_FULLDUPLEX () { 3; }") unless defined(&PHY_MODE_FULLDUPLEX);
eval("sub PHY_MODE_MAX () { 4; }") unless defined(&PHY_MODE_MAX);
unless(defined(&PHY_NEED_HARD_RESET)) {
    sub PHY_NEED_HARD_RESET () {	0x1;}
}
unless(defined(&PHY_DUAL_CYCLE_TA)) {
    sub PHY_DUAL_CYCLE_TA () {	0x2;}
}
if(defined(&TULIP_DEBUG)) {
}
eval("sub TULIP_PROBE_INACTIVE () { 0; }") unless defined(&TULIP_PROBE_INACTIVE);
eval("sub TULIP_PROBE_PHYRESET () { 1; }") unless defined(&TULIP_PROBE_PHYRESET);
eval("sub TULIP_PROBE_PHYAUTONEG () { 2; }") unless defined(&TULIP_PROBE_PHYAUTONEG);
eval("sub TULIP_PROBE_GPRTEST () { 3; }") unless defined(&TULIP_PROBE_GPRTEST);
eval("sub TULIP_PROBE_MEDIATEST () { 4; }") unless defined(&TULIP_PROBE_MEDIATEST);
eval("sub TULIP_PROBE_FAILED () { 5; }") unless defined(&TULIP_PROBE_FAILED);
unless(defined(&TULIP_WANTSETUP)) {
    sub TULIP_WANTSETUP () {	0x1;}
}
unless(defined(&TULIP_WANTHASHPERFECT)) {
    sub TULIP_WANTHASHPERFECT () {	0x2;}
}
unless(defined(&TULIP_WANTHASHONLY)) {
    sub TULIP_WANTHASHONLY () {	0x4;}
}
unless(defined(&TULIP_DOINGSETUP)) {
    sub TULIP_DOINGSETUP () {	0x8;}
}
unless(defined(&TULIP_PRINTMEDIA)) {
    sub TULIP_PRINTMEDIA () {	0x10;}
}
unless(defined(&TULIP_TXPROBE_ACTIVE)) {
    sub TULIP_TXPROBE_ACTIVE () {	0x20;}
}
unless(defined(&TULIP_ALLMULTI)) {
    sub TULIP_ALLMULTI () {	0x40;}
}
unless(defined(&TULIP_WANTRXACT)) {
    sub TULIP_WANTRXACT () {	0x80;}
}
unless(defined(&TULIP_RXACT)) {
    sub TULIP_RXACT () {	0x100;}
}
unless(defined(&TULIP_INRESET)) {
    sub TULIP_INRESET () {	0x200;}
}
unless(defined(&TULIP_NEEDRESET)) {
    sub TULIP_NEEDRESET () {	0x400;}
}
unless(defined(&TULIP_SQETEST)) {
    sub TULIP_SQETEST () {	0x800;}
}
unless(defined(&TULIP_FULLDUPLEX)) {
    sub TULIP_FULLDUPLEX () {	0x1000;}
}
unless(defined(&TULIP_xxxxxx1)) {
    sub TULIP_xxxxxx1 () {	0x2000;}
}
unless(defined(&TULIP_WANTTXSTART)) {
    sub TULIP_WANTTXSTART () {	0x4000;}
}
unless(defined(&TULIP_NEWTXTHRESH)) {
    sub TULIP_NEWTXTHRESH () {	0x8000;}
}
unless(defined(&TULIP_NOAUTOSENSE)) {
    sub TULIP_NOAUTOSENSE () {	0x10000;}
}
unless(defined(&TULIP_PRINTLINKUP)) {
    sub TULIP_PRINTLINKUP () {	0x20000;}
}
unless(defined(&TULIP_LINKUP)) {
    sub TULIP_LINKUP () {	0x40000;}
}
unless(defined(&TULIP_RXBUFSLOW)) {
    sub TULIP_RXBUFSLOW () {	0x80000;}
}
unless(defined(&TULIP_NOMESSAGES)) {
    sub TULIP_NOMESSAGES () {	0x100000;}
}
unless(defined(&TULIP_SYSTEMERROR)) {
    sub TULIP_SYSTEMERROR () {	0x200000;}
}
unless(defined(&TULIP_TIMEOUTPENDING)) {
    sub TULIP_TIMEOUTPENDING () {	0x400000;}
}
unless(defined(&TULIP_xxxxxx2)) {
    sub TULIP_xxxxxx2 () {	0x800000;}
}
unless(defined(&TULIP_TRYNWAY)) {
    sub TULIP_TRYNWAY () {	0x1000000;}
}
unless(defined(&TULIP_DIDNWAY)) {
    sub TULIP_DIDNWAY () {	0x2000000;}
}
unless(defined(&TULIP_RXIGNORE)) {
    sub TULIP_RXIGNORE () {	0x4000000;}
}
unless(defined(&TULIP_PROBE1STPASS)) {
    sub TULIP_PROBE1STPASS () {	0x8000000;}
}
unless(defined(&TULIP_DEVICEPROBE)) {
    sub TULIP_DEVICEPROBE () {	0x10000000;}
}
unless(defined(&TULIP_PROMISC)) {
    sub TULIP_PROMISC () {	0x20000000;}
}
unless(defined(&TULIP_HASHONLY)) {
    sub TULIP_HASHONLY () {	0x40000000;}
}
unless(defined(&TULIP_xxxxxx3)) {
    sub TULIP_xxxxxx3 () {	0x80000000;}
}
unless(defined(&TULIP_HAVE_GPR)) {
    sub TULIP_HAVE_GPR () {	0x1;}
}
unless(defined(&TULIP_HAVE_RXBADOVRFLW)) {
    sub TULIP_HAVE_RXBADOVRFLW () {	0x2;}
}
unless(defined(&TULIP_HAVE_POWERMGMT)) {
    sub TULIP_HAVE_POWERMGMT () {	0x4;}
}
unless(defined(&TULIP_HAVE_MII)) {
    sub TULIP_HAVE_MII () {	0x8;}
}
unless(defined(&TULIP_HAVE_SIANWAY)) {
    sub TULIP_HAVE_SIANWAY () {	0x10;}
}
unless(defined(&TULIP_HAVE_DUALSENSE)) {
    sub TULIP_HAVE_DUALSENSE () {	0x20;}
}
unless(defined(&TULIP_HAVE_SIAGP)) {
    sub TULIP_HAVE_SIAGP () {	0x40;}
}
unless(defined(&TULIP_HAVE_BROKEN_HASH)) {
    sub TULIP_HAVE_BROKEN_HASH () {	0x80;}
}
unless(defined(&TULIP_HAVE_ISVSROM)) {
    sub TULIP_HAVE_ISVSROM () {	0x100;}
}
unless(defined(&TULIP_HAVE_BASEROM)) {
    sub TULIP_HAVE_BASEROM () {	0x200;}
}
unless(defined(&TULIP_HAVE_SLAVEDROM)) {
    sub TULIP_HAVE_SLAVEDROM () {	0x400;}
}
unless(defined(&TULIP_HAVE_SLAVEDINTR)) {
    sub TULIP_HAVE_SLAVEDINTR () {	0x800;}
}
unless(defined(&TULIP_HAVE_SHAREDINTR)) {
    sub TULIP_HAVE_SHAREDINTR () {	0x1000;}
}
unless(defined(&TULIP_HAVE_OKROM)) {
    sub TULIP_HAVE_OKROM () {	0x2000;}
}
unless(defined(&TULIP_HAVE_NOMEDIA)) {
    sub TULIP_HAVE_NOMEDIA () {	0x4000;}
}
unless(defined(&TULIP_HAVE_STOREFWD)) {
    sub TULIP_HAVE_STOREFWD () {	0x8000;}
}
unless(defined(&TULIP_HAVE_SIA100)) {
    sub TULIP_HAVE_SIA100 () {	0x10000;}
}
unless(defined(&TULIP_HAVE_OKSROM)) {
    sub TULIP_HAVE_OKSROM () {	0x20000;}
}
unless(defined(&tulip_probe_count)) {
    sub tulip_probe_count () {	 ($tulip_probe->{probe_count});}
}
unless(defined(&tulip_probe_timeout)) {
    sub tulip_probe_timeout () {	 ($tulip_probe->{probe_timeout});}
}
unless(defined(&tulip_probe_state)) {
    sub tulip_probe_state () {	 ($tulip_probe->{probe_state});}
}
unless(defined(&tulip_probe_media)) {
    sub tulip_probe_media () {	 ($tulip_probe->{probe_media});}
}
unless(defined(&tulip_probe_mediamask)) {
    sub tulip_probe_mediamask () {	 ($tulip_probe->{probe_mediamask});}
}
unless(defined(&tulip_probe_passes)) {
    sub tulip_probe_passes () {	 ($tulip_probe->{probe_passes});}
}
if(defined( &TULIP_DEBUG)) {
}
if(defined( &TULIP_PERFSTATS)) {
    eval 'sub TULIP_PERF_CURRENT () {0;}' unless defined(&TULIP_PERF_CURRENT);
    eval 'sub TULIP_PERF_PREVIOUS () {1;}' unless defined(&TULIP_PERF_PREVIOUS);
    eval 'sub TULIP_PERF_TOTAL () {2;}' unless defined(&TULIP_PERF_TOTAL);
    eval 'sub TULIP_PERF_MAX () {3;}' unless defined(&TULIP_PERF_MAX);
    eval 'sub tulip_curperfstats () { $tulip_perfstats[ &TULIP_PERF_CURRENT];}' unless defined(&tulip_curperfstats);
}
unless(defined(&TULIP_DO_AUTOSENSE)) {
    sub TULIP_DO_AUTOSENSE {
	my($sc) = @_;
	eval q(( &IFM_SUBTYPE(($sc)-> ($tulip_ifmedia->{ifm_media})) ==  &IFM_AUTO));
    }
}
if(defined(&TULIP_DEBUG)) {
}
if(defined(&TULIP_DEBUG)) {
}
unless(defined(&TULIP_SROM_LASTCONNIDX)) {
    sub TULIP_SROM_LASTCONNIDX () {	($sizeof{ &tulip_srom_conninfo}/$sizeof{ $tulip_srom_conninfo[0]} - 1);}
}
unless(defined(&TULIP_MAX_DEVICES)) {
    sub TULIP_MAX_DEVICES () {	32;}
}
unless(defined(&TULIP_RXDESC_PRESYNC)) {
    sub TULIP_RXDESC_PRESYNC {
	my($sc, $di, $s) = @_;
	eval q( &bus_dmamap_sync(-> &tulip_dmatag, -> &tulip_rxdescmap, $di - ($sc)-> &tulip_rxdescs, ($s),  &BUS_DMASYNC_PREREAD| &BUS_DMASYNC_PREWRITE));
    }
}
unless(defined(&TULIP_RXDESC_POSTSYNC)) {
    sub TULIP_RXDESC_POSTSYNC {
	my($sc, $di, $s) = @_;
	eval q( &bus_dmamap_sync(-> &tulip_dmatag, -> &tulip_rxdescmap, $di - ($sc)-> &tulip_rxdescs, ($s),  &BUS_DMASYNC_POSTREAD| &BUS_DMASYNC_POSTWRITE));
    }
}
unless(defined(&TULIP_RXMAP_PRESYNC)) {
    sub TULIP_RXMAP_PRESYNC {
	my($sc, $map) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &tulip_dmatag, ($map), 0, ($map)-> &dm_mapsize,  &BUS_DMASYNC_PREREAD| &BUS_DMASYNC_PREWRITE));
    }
}
unless(defined(&TULIP_RXMAP_POSTSYNC)) {
    sub TULIP_RXMAP_POSTSYNC {
	my($sc, $map) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &tulip_dmatag, ($map), 0, ($map)-> &dm_mapsize,  &BUS_DMASYNC_POSTREAD| &BUS_DMASYNC_POSTWRITE));
    }
}
unless(defined(&TULIP_RXMAP_CREATE)) {
    sub TULIP_RXMAP_CREATE {
	my($sc, $mapp) = @_;
	eval q( &bus_dmamap_create(($sc)-> &tulip_dmatag,  &TULIP_RX_BUFLEN, 2,  &TULIP_DATA_PER_DESC, 0,  &BUS_DMA_NOWAIT| &BUS_DMA_ALLOCNOW, ($mapp)));
    }
}
unless(defined(&TULIP_TXDESC_PRESYNC)) {
    sub TULIP_TXDESC_PRESYNC {
	my($sc, $di, $s) = @_;
	eval q( &bus_dmamap_sync(-> &tulip_dmatag, -> &tulip_txdescmap, $di - ($sc)-> &tulip_txdescs, ($s),  &BUS_DMASYNC_PREREAD| &BUS_DMASYNC_PREWRITE));
    }
}
unless(defined(&TULIP_TXDESC_POSTSYNC)) {
    sub TULIP_TXDESC_POSTSYNC {
	my($sc, $di, $s) = @_;
	eval q( &bus_dmamap_sync(-> &tulip_dmatag, -> &tulip_txdescmap, $di - ($sc)-> &tulip_txdescs, ($s),  &BUS_DMASYNC_POSTREAD| &BUS_DMASYNC_POSTWRITE));
    }
}
unless(defined(&TULIP_TXMAP_PRESYNC)) {
    sub TULIP_TXMAP_PRESYNC {
	my($sc, $map) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &tulip_dmatag, ($map), 0, ($map)-> &dm_mapsize,  &BUS_DMASYNC_PREREAD| &BUS_DMASYNC_PREWRITE));
    }
}
unless(defined(&TULIP_TXMAP_POSTSYNC)) {
    sub TULIP_TXMAP_POSTSYNC {
	my($sc, $map) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &tulip_dmatag, ($map), 0, ($map)-> &dm_mapsize,  &BUS_DMASYNC_POSTREAD| &BUS_DMASYNC_POSTWRITE));
    }
}
unless(defined(&TULIP_TXMAP_CREATE)) {
    sub TULIP_TXMAP_CREATE {
	my($sc, $mapp) = @_;
	eval q( &bus_dmamap_create(($sc)-> &tulip_dmatag,  &TULIP_DATA_PER_DESC,  &TULIP_MAX_TXSEG,  &TULIP_DATA_PER_DESC, 0,  &BUS_DMA_NOWAIT, ($mapp)));
    }
}
unless(defined(&TULIP_UNIT_TO_SOFTC)) {
    sub TULIP_UNIT_TO_SOFTC {
	my($unit) = @_;
	eval q((( &tulip_softc_t *)  ($de_cd->{cd_devs[$unit]})));
    }
}
unless(defined(&TULIP_IFP_TO_SOFTC)) {
    sub TULIP_IFP_TO_SOFTC {
	my($ifp) = @_;
	eval q((( &tulip_softc_t *)(($ifp)-> &if_softc)));
    }
}
unless(defined(&tulip_unit)) {
    sub tulip_unit () {	 ($tulip_dev->{dv_unit});}
}
unless(defined(&tulip_xname)) {
    sub tulip_xname () {	 ($tulip_dev->{dv_cfdata}->{cf_driver}->{cd_name});}
}
unless(defined(&TULIP_PRINTF_FMT)) {
    sub TULIP_PRINTF_FMT () {	"%s%d";}
}
unless(defined(&TULIP_PRINTF_ARGS)) {
    sub TULIP_PRINTF_ARGS () {	 ($sc->{tulip_xname}),  ($sc->{tulip_unit});}
}
unless(defined(&TULIP_BURSTSIZE)) {
    sub TULIP_BURSTSIZE {
	my($unit) = @_;
	eval q(3);
    }
}
unless(defined(&tulip_if)) {
    sub tulip_if () {	 ($tulip_ac->{ac_if});}
}
unless(defined(&tulip_name)) {
    sub tulip_name () {	 ($tulip_if->{if_name});}
}
unless(defined(&tulip_enaddr)) {
    sub tulip_enaddr () {	 ($tulip_ac->{ac_enaddr});}
}
unless(defined(&tulip_multicnt)) {
    sub tulip_multicnt () {	 ($tulip_ac->{ac_multicnt});}
}
unless(defined(&tulip_bpf)) {
    sub tulip_bpf () {	 ($tulip_if->{if_bpf});}
}
unless(defined(&tulip_intrfunc_t)) {
    sub tulip_intrfunc_t () {	'int';}
}
if(defined( &TULIP_PERFSTATS)) {
    eval 'sub TULIP_PERFMERGE {
        my($sc, $member) = @_;
	    eval q( &do { ($sc)-> ($tulip_perfstats[&TULIP_PERF_TOTAL]->{member})  += ($sc)-> ($tulip_perfstats[&TULIP_PERF_CURRENT]->{member}); ($sc)-> ($tulip_perfstats[&TULIP_PERF_PREVIOUS]->{member})  = ($sc)-> ($tulip_perfstats[&TULIP_PERF_CURRENT]->{member}); ($sc)-> ($tulip_perfstats[&TULIP_PERF_CURRENT]->{member}) = 0; }  &while (0));
    }' unless defined(&TULIP_PERFMERGE);
    eval 'sub TULIP_PERFSTART {
        my($name) = @_;
	    eval q( &const  &tulip_cycle_t  &perfstart_  $name =  &TULIP_PERFREAD(););
    }' unless defined(&TULIP_PERFSTART);
    eval 'sub TULIP_PERFEND {
        my($name) = @_;
	    eval q( &do { ( &sc)-> ($tulip_curperfstats->{perf_})  $name   &_cycles +=  &TULIP_PERFDIFF( &perfstart_  $name,  &TULIP_PERFREAD()); ( &sc)-> ($tulip_curperfstats->{perf_})  $name++; }  &while (0));
    }' unless defined(&TULIP_PERFEND);
    if(defined( &__i386__)) {
	eval 'sub TULIP_PERFDIFF {
	    my($s, $f) = @_;
    	    eval q((($f) - ($s)));
	}' unless defined(&TULIP_PERFDIFF);
    }
 elsif(defined( &__alpha__)) {
	eval 'sub TULIP_PERFDIFF {
	    my($s, $f) = @_;
    	    eval q(( (($f) - ($s))));
	}' unless defined(&TULIP_PERFDIFF);
    }
} else {
    eval 'sub TULIP_PERFSTART {
        my($name) = @_;
	    eval q();
    }' unless defined(&TULIP_PERFSTART);
    eval 'sub TULIP_PERFEND {
        my($name) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&TULIP_PERFEND);
    eval 'sub TULIP_PERFMERGE {
        my($s,$n) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&TULIP_PERFMERGE);
}
unless(defined(&TULIP_MAX_TXSEG)) {
    sub TULIP_MAX_TXSEG () {	30;}
}
unless(defined(&TULIP_ADDREQUAL)) {
    sub TULIP_ADDREQUAL {
	my($a1, $a2) = @_;
	eval q(((( &u_int16_t *)$a1)[0] == (( &u_int16_t *)$a2)[0]  && (( &u_int16_t *)$a1)[1] == (( &u_int16_t *)$a2)[1]  && (( &u_int16_t *)$a1)[2] == (( &u_int16_t *)$a2)[2]));
    }
}
unless(defined(&TULIP_ADDRBRDCST)) {
    sub TULIP_ADDRBRDCST {
	my($a1) = @_;
	eval q(((( &u_int16_t *)$a1)[0] == 0xffff  && (( &u_int16_t *)$a1)[1] == 0xffff  && (( &u_int16_t *)$a1)[2] == 0xffff));
    }
}
unless(defined(&TULIP_GETCTX)) {
    sub TULIP_GETCTX {
	my($m, $t) = @_;
	eval q((($t) ($m)-> ($m_pkthdr->{rcvif}) + 0));
    }
}
unless(defined(&TULIP_SETCTX)) {
    sub TULIP_SETCTX {
	my($m, $c) = @_;
	eval q((( &void) (($m)-> ($m_pkthdr->{r$cvif}) = ( &void *) ($c))));
    }
}
1;
