/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

contactlistmodule.prototype = new ListModule;
contactlistmodule.prototype.constructor = contactlistmodule;
contactlistmodule.superclass = ListModule.prototype;

function contactlistmodule(id, element, title, data)
{
	if(arguments.length > 0) {
		this.init(id, element, title, data);
	}
	this.emailList = Object();
}

contactlistmodule.prototype.init = function(id, element, title, data)
{
	// entryid of the folder
	this.entryid = data["entryid"];
	
	this.character = webclient.settings.get("folders/entryid_"+this.entryid+"/selected_char", "a");

	this.defaultview = webclient.settings.get("folders/entryid_"+this.entryid+"/selected_view", "address_cards");
	
	contactlistmodule.superclass.init.call(this, id, element, title, data);
	this.initializeView();

	this.menuItems.push(webclient.menu.createMenuItem("seperator", ""));
	this.menuItems.push(webclient.menu.createMenuItem("contact_cards", _("Cards"), _("Address Cards"), eventContactlistSwitchView));
	this.menuItems.push(webclient.menu.createMenuItem("contact_list", _("List"), _("List View"), eventContactlistSwitchView));
	webclient.pluginManager.triggerHook('client.module.contactlistmodule.topmenu.buildup', {topmenu: this.menuItems});
	webclient.menu.buildTopMenu(this.id, "contact", this.menuItems, eventListNewMessage);

	var items = new Array();
	items.push(webclient.menu.createMenuItem("open", _("Open"), false, eventListContextMenuOpenMessage));
	items.push(webclient.menu.createMenuItem("print", _("Print"), false, eventListContextMenuPrintMessage));
	items.push(webclient.menu.createMenuItem("seperator", ""));
	items.push(webclient.menu.createMenuItem("createmail", _("Email Message"), false, eventContactlistClickEmail));
	items.push(webclient.menu.createMenuItem("categories", _("Categories"), false, eventListContextMenuCategoriesMessage));
	items.push(webclient.menu.createMenuItem("seperator", ""));
	items.push(webclient.menu.createMenuItem("delete", _("Delete"), false, eventListContextMenuDeleteMessage));
	webclient.pluginManager.triggerHook('client.module.contactlistmodule.contextmenu.buildup', {contextmenu: items});
	this.contextmenu = items;

	this.action = false;
}

contactlistmodule.prototype.initializeView = function(view)
{
	if (view){
		webclient.settings.set("folders/entryid_"+this.entryid+"/selected_view", view);
	}else{
		view = this.defaultview;
	}
	
	if (view == "contact_cards"){
		this.setTitle(this.title, NBSP, true);
	}else{
		this.setTitle(this.title, false, true);
	}
	this.contentElement = dhtml.addElement(this.element, "div");
	
	var data = new Object();
	data["character"] = this.character;

	this.events["alfabet"] = new Object();
	this.events["alfabet"]["mouseover"] = eventContactListMouseOverAlfabetItem;
	this.events["alfabet"]["mouseout"] = eventContactListMouseOutAlfabetItem;
	this.events["alfabet"]["click"] = eventContactListClickAlfabetItem;
	this.viewController.initView(this.id, view, this.contentElement, this.events, data);
}

/**
 * Function which execute an action. This function is called by the XMLRequest object. 
 * @param string type the action type
 * @param object action the action tag 
 */ 
contactlistmodule.prototype.execute = function(type, action)
{
	webclient.menu.showMenu();

	this.saveEmailInModule(type, action);
	switch(type)
	{
		case "list":
			this.messageList(action);
			break;
		case "item":
			this.item(action);
			break;
		case "delete":
			this.deleteItems(action);
			break;
	}
}

/**
 * Function will save the email address from the contacts in action
 * @param string type the action type
 * @param object action the action tag 
 */ 
contactlistmodule.prototype.saveEmailInModule = function(type,action)
{
	var items = action.getElementsByTagName("item");
	for(var i=0; i < items.length; i++){
		var item = items[i];
		var entryID = dhtml.getTextNode(item.getElementsByTagName("entryid")[0],"");
		var email = dhtml.getTextNode(item.getElementsByTagName("email_address_1")[0],"");
		var email_displayname = dhtml.getTextNode(item.getElementsByTagName("display_name")[0],"");
		var sender = "";
		if(email_displayname.length > 0) {
			sender = email_displayname;
		}
		if(email.length > 0 && email != email_displayname) {
			sender += " <"+email+">";
		}
		if(type != "delete"){
			this.emailList[entryID] = sender;
		}else{
			this.emailList[entryID] = "";
		}
	}
}

contactlistmodule.prototype.actionAfterDelete = function()
{
	this.viewController.resizeView();
}

contactlistmodule.prototype.getRestrictionData = function()
{
	var data = new Object();

	if(this.character) {
		data["character"] = this.character;
	}

	return data;
}

/**
 * "Customized" event handler for opening items. Normally a read flag is set 
 * causing a request to the server. This request returns an update which causes a
 * reload of the entire contactlist, because the view does not support a single 
 * update. This function does not set the read receipt flag, but still opens the 
 * dialog.
 * 
 * message_type is the type of message "appointment", "task", "contact" etc (usally a part of the message_class)
 */
contactlistmodule.prototype.onOpenItem = function(entryid, message_type)
{
	var uri = DIALOG_URL+"task=" + message_type + "_standard&storeid=" + this.storeid + "&parententryid=" + this.entryid + "&entryid=" + entryid;
	webclient.openWindow(this, message_type, uri);
}

function eventContactListMouseOverAlfabetItem(moduleObject, element, event)
{
	element.className += " characterover";
}

function eventContactListMouseOutAlfabetItem(moduleObject, element, event)
{
	if(element.className.indexOf("characterover") > 0) {
		element.className = element.className.substring(0, element.className.lastIndexOf("characterover"));
	}
}

function eventContactListClickAlfabetItem(moduleObject, element, event)
{
	var character = dhtml.getElementById("character_" + moduleObject.character);
	if(character) {
		character.className = character.className.substring(0, character.className.lastIndexOf("characterover"));
	}
	
	element.className += " characterover";

	moduleObject.character = element.id.substring(element.id.indexOf("_") + 1);
	webclient.settings.set("folders/entryid_"+moduleObject.entryid+"/selected_char", moduleObject.character);
	moduleObject.list();
}

function eventContactlistSwitchView(moduleObject, element, event)
{
	var newView = element.id;
	moduleObject.destructor(moduleObject);
	moduleObject.initializeView(newView);
	moduleObject.list();
	moduleObject.resize();
}

/**
 * Function will open an create email dialog and put the email address in the "to" field
 */
function eventContactlistClickEmail(moduleObject, element, event) 
{ 
	element.parentNode.style.display = "none";
	var entryID = moduleObject.entryids[element.parentNode.elementid];
	var email = moduleObject.emailList[entryID];
	webclient.openWindow(this, "createmail", DIALOG_URL+"task=createmail_standard&to=" + email);
	eventListCheckSelectedContextMessage(this); 
}
