<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

abstract class WebserviceEntityOperation{
	protected $user;
	protected $log;
	protected $webserviceObject;
	protected $meta;
	
	protected function WebserviceEntityOperation($webserviceObject,$user,$adb,$log){
		$this->user = $user;
		$this->log = $log;
		$this->webserviceObject = $webserviceObject;
		$this->pearDB = $adb;
	}
	
	public function create($elementType,$element){
		throw new WebServiceException(WebServiceErrorCode::$OPERATIONNOTSUPPORTED,
		"Operation Create is not supported for this entity");
	}
	
	public function retrieve($id){
		throw new WebServiceException(WebServiceErrorCode::$OPERATIONNOTSUPPORTED,
		"Operation Retrieve is not supported for this entity");
	}
	
	public function update($element){
		throw new WebServiceException(WebServiceErrorCode::$OPERATIONNOTSUPPORTED,
		"Operation Update is not supported for this entity");
	}
	
	public function delete($id){
		throw new WebServiceException(WebServiceErrorCode::$OPERATIONNOTSUPPORTED,
		"Operation delete is not supported for this entity");
	}
	
	public function query($q){
		throw new WebServiceException(WebServiceErrorCode::$OPERATIONNOTSUPPORTED,
		"Operation query is not supported for this entity");
	}
	
	public function describe($elementType){
		throw new WebServiceException(WebServiceErrorCode::$OPERATIONNOTSUPPORTED,
		"Operation describe is not supported for this entity");
	}
	
	function getFieldTypeDetails($webserviceField){
		global $upload_maxsize;
		$typeDetails = array();
		switch($webserviceField->getFieldDataType()){
			case 'reference': $typeDetails['refersTo'] = $webserviceField->getReferenceList();
				break;
			case 'picklist': $typeDetails["picklistValues"] = $this->getPicklistDetails($webserviceField);
				$typeDetails['defaultValue'] = $typeDetails["picklistValues"][0]['value'];
				break;
			case 'file': $maxUploadSize = 0;
				$maxUploadSize = ini_get('upload_max_filesize');
				$maxUploadSize = strtolower($maxUploadSize);
				$maxUploadSize = explode('m',$maxUploadSize);
				$maxUploadSize = $maxUploadSize[0];
				if(!is_numeric($maxUploadSize)){
					$maxUploadSize = 0;
				}
				$maxUploadSize = $maxUploadSize * 1000000;
				if($upload_maxsize > $maxUploadSize){
					$maxUploadSize = $upload_maxsize;
				}
				$typeDetails['maxUploadFileSize'] = $maxUploadSize;
				break;
			case 'date': $typeDetails['format'] = $this->user->date_format;
		}
		return $typeDetails;
	}
	
	function isEditable($webserviceField){
		if(((int)$webserviceField->getDisplayType()) === 2 || strcasecmp($webserviceField->getFieldDataType(),"autogenerated")
			===0 || strcasecmp($webserviceField->getFieldDataType(),"id")===0){
			return false;
		}
		//uitype 70 is vtiger generated fields, such as (of vtiger_crmentity table) createdtime and modified time fields.
		if($webserviceField->getUIType() ==  70){
			return false;
		}
		return true;
	}
	
	function getPicklistDetails($webserviceField){
		$hardCodedPickListNames = array("hdntaxtype");
		$hardCodedPickListValues = array("hdntaxtype"=>array(array("label"=>"Individual","value"=>"individual"),
														array("label"=>"Group","value"=>"group")));
		if(in_array(strtolower($webserviceField->getFieldName()),$hardCodedPickListNames)){
			return $hardCodedPickListValues[strtolower($webserviceField->getFieldName())];
		}
		return $this->getPickListOptions($webserviceField->getFieldName());
	}
	
	function getPickListOptions($fieldName){
		
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		$options = array();
		$sql = "select * from vtiger_picklist where name=?";
		$result = $this->pearDB->pquery($sql,array($fieldName));
		$numRows = $this->pearDB->num_rows($result);
		if($numRows == 0){
			$sql = "select * from vtiger_$fieldName";
			$result = $this->pearDB->pquery($sql,array());
			$numRows = $this->pearDB->num_rows($result);
			for($i=0;$i<$numRows;++$i){
				$elem = array();
				$picklistValue = $this->pearDB->query_result($result,$i,$fieldName);
				$picklistValue = html_entity_decode($picklistValue, ENT_QUOTES, $default_charset);
				$elem["label"] = getTranslatedString($picklistValue,$this->getMeta()->getTabName());
				$elem["value"] = $picklistValue;
				array_push($options,$elem);
			}
		}else{
			$details = getPickListValues($fieldName,$this->user->roleid);
			for($i=0;$i<sizeof($details);++$i){
				$elem = array();
				$picklistValue = html_entity_decode($details[$i], ENT_QUOTES, $default_charset);
				$elem["label"] = getTranslatedString($picklistValue,$this->getMeta()->getTabName());
				$elem["value"] = $picklistValue;
				array_push($options,$elem);
			}
		}
		return $options;
	}
	
	function getIdField($label){
		return array('name'=>'id','label'=>$label,'mandatory'=>false,'type'=>'id','editable'=>false,'type'=>
						array('name'=>'autogenerated'),'nullable'=>false,'default'=>"");
	}
	
	/**
	 * @return Intance of EntityMeta class.
	 *
	 */
	abstract public function getMeta();
	
}

?>