/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BitVector;

class SegmentReader
extends IndexReader {
    private String segment;
    private SegmentInfo si;
    FieldInfos fieldInfos;
    private FieldsReader fieldsReader;
    TermInfosReader tis;
    TermVectorsReader termVectorsReaderOrig = null;
    ThreadLocal termVectorsLocal = new ThreadLocal();
    BitVector deletedDocs = null;
    private boolean deletedDocsDirty = false;
    private boolean normsDirty = false;
    private boolean undeleteAll = false;
    private boolean rollbackDeletedDocsDirty = false;
    private boolean rollbackNormsDirty = false;
    private boolean rollbackUndeleteAll = false;
    IndexInput freqStream;
    IndexInput proxStream;
    CompoundFileReader cfsReader = null;
    private Hashtable norms = new Hashtable();
    private static Class IMPL;
    private byte[] ones;

    protected SegmentReader() {
        super(null);
    }

    public static SegmentReader get(SegmentInfo si) throws IOException {
        return SegmentReader.get(si.dir, si, null, false, false);
    }

    public static SegmentReader get(SegmentInfos sis, SegmentInfo si, boolean closeDir) throws IOException {
        return SegmentReader.get(si.dir, si, sis, closeDir, true);
    }

    public static SegmentReader get(Directory dir, SegmentInfo si, SegmentInfos sis, boolean closeDir, boolean ownDir) throws IOException {
        SegmentReader instance;
        try {
            instance = (SegmentReader)IMPL.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot load SegmentReader class: " + e, e);
        }
        instance.init(dir, sis, closeDir, ownDir);
        instance.initialize(si);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(SegmentInfo si) throws IOException {
        this.segment = si.name;
        this.si = si;
        boolean success = false;
        try {
            Directory cfsDir = this.directory();
            if (si.getUseCompoundFile()) {
                this.cfsReader = new CompoundFileReader(this.directory(), this.segment + ".cfs");
                cfsDir = this.cfsReader;
            }
            this.fieldInfos = new FieldInfos(cfsDir, this.segment + ".fnm");
            this.fieldsReader = new FieldsReader(cfsDir, this.segment, this.fieldInfos);
            if (this.fieldsReader.size() != si.docCount) {
                throw new IllegalStateException("doc counts differ for segment " + si.name + ": fieldsReader shows " + this.fieldsReader.size() + " but segmentInfo shows " + si.docCount);
            }
            this.tis = new TermInfosReader(cfsDir, this.segment, this.fieldInfos);
            if (SegmentReader.hasDeletions(si)) {
                this.deletedDocs = new BitVector(this.directory(), si.getDelFileName());
                if (this.deletedDocs.count() > this.maxDoc()) {
                    throw new IllegalStateException("number of deletes (" + this.deletedDocs.count() + ") exceeds max doc (" + this.maxDoc() + ") for segment " + si.name);
                }
            }
            this.freqStream = cfsDir.openInput(this.segment + ".frq");
            this.proxStream = cfsDir.openInput(this.segment + ".prx");
            this.openNorms(cfsDir);
            if (this.fieldInfos.hasVectors()) {
                this.termVectorsReaderOrig = new TermVectorsReader(cfsDir, this.segment, this.fieldInfos);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    protected void doCommit() throws IOException {
        String oldDelFileName;
        if (this.deletedDocsDirty) {
            oldDelFileName = this.si.getDelFileName();
            if (oldDelFileName != null) {
                this.deleter.addPendingFile(oldDelFileName);
            }
            this.si.advanceDelGen();
            this.deletedDocs.write(this.directory(), this.si.getDelFileName());
        }
        if (this.undeleteAll && this.si.hasDeletions()) {
            oldDelFileName = this.si.getDelFileName();
            if (oldDelFileName != null) {
                this.deleter.addPendingFile(oldDelFileName);
            }
            this.si.clearDelGen();
        }
        if (this.normsDirty) {
            this.si.setNumFields(this.fieldInfos.size());
            Enumeration values = this.norms.elements();
            while (values.hasMoreElements()) {
                Norm norm = (Norm)values.nextElement();
                if (!norm.dirty) continue;
                norm.reWrite(this.si);
            }
        }
        this.deletedDocsDirty = false;
        this.normsDirty = false;
        this.undeleteAll = false;
    }

    protected void doClose() throws IOException {
        if (this.fieldsReader != null) {
            this.fieldsReader.close();
        }
        if (this.tis != null) {
            this.tis.close();
        }
        if (this.freqStream != null) {
            this.freqStream.close();
        }
        if (this.proxStream != null) {
            this.proxStream.close();
        }
        this.closeNorms();
        if (this.termVectorsReaderOrig != null) {
            this.termVectorsReaderOrig.close();
        }
        if (this.cfsReader != null) {
            this.cfsReader.close();
        }
    }

    static boolean hasDeletions(SegmentInfo si) throws IOException {
        return si.hasDeletions();
    }

    public boolean hasDeletions() {
        return this.deletedDocs != null;
    }

    static boolean usesCompoundFile(SegmentInfo si) throws IOException {
        return si.getUseCompoundFile();
    }

    static boolean hasSeparateNorms(SegmentInfo si) throws IOException {
        return si.hasSeparateNorms();
    }

    protected void doDelete(int docNum) {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
        }
        this.deletedDocsDirty = true;
        this.undeleteAll = false;
        this.deletedDocs.set(docNum);
    }

    protected void doUndeleteAll() {
        this.deletedDocs = null;
        this.deletedDocsDirty = false;
        this.undeleteAll = true;
    }

    Vector files() throws IOException {
        Vector<String> files = new Vector<String>(16);
        if (this.si.getUseCompoundFile()) {
            String name = this.segment + ".cfs";
            if (this.directory().fileExists(name)) {
                files.addElement(name);
            }
        } else {
            for (int i = 0; i < IndexFileNames.INDEX_EXTENSIONS.length; ++i) {
                String name = this.segment + "." + IndexFileNames.INDEX_EXTENSIONS[i];
                if (!this.directory().fileExists(name)) continue;
                files.addElement(name);
            }
        }
        if (this.si.hasDeletions()) {
            files.addElement(this.si.getDelFileName());
        }
        boolean addedNrm = false;
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            String name = this.si.getNormFileName(i);
            if (name == null || !this.directory().fileExists(name)) continue;
            if (name.endsWith(".nrm")) {
                if (addedNrm) continue;
                addedNrm = true;
            }
            files.addElement(name);
        }
        return files;
    }

    public TermEnum terms() {
        return this.tis.terms();
    }

    public TermEnum terms(Term t) throws IOException {
        return this.tis.terms(t);
    }

    public synchronized Document document(int n, FieldSelector fieldSelector) throws IOException {
        if (this.isDeleted(n)) {
            throw new IllegalArgumentException("attempt to access a deleted document");
        }
        return this.fieldsReader.doc(n, fieldSelector);
    }

    public synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    public TermDocs termDocs() throws IOException {
        return new SegmentTermDocs(this);
    }

    public TermPositions termPositions() throws IOException {
        return new SegmentTermPositions(this);
    }

    public int docFreq(Term t) throws IOException {
        TermInfo ti = this.tis.get(t);
        if (ti != null) {
            return ti.docFreq;
        }
        return 0;
    }

    public int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    public int maxDoc() {
        return this.si.docCount;
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldOption) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fieldOption == IndexReader.FieldOption.ALL) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.isIndexed && fieldOption == IndexReader.FieldOption.UNINDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fieldOption == IndexReader.FieldOption.INDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && !fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_NO_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeTermVector && !fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_WITH_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_POSITION) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeOffsetWithTermVector && !fi.storePositionWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.storeOffsetWithTermVector || !fi.storePositionWithTermVector || fieldOption != IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET) continue;
            fieldSet.add(fi.name);
        }
        return fieldSet;
    }

    public synchronized boolean hasNorms(String field) {
        return this.norms.containsKey(field);
    }

    static byte[] createFakeNorms(int size) {
        byte[] ones = new byte[size];
        Arrays.fill(ones, DefaultSimilarity.encodeNorm(1.0f));
        return ones;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    protected synchronized byte[] getNorms(String field) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return null;
        }
        if (norm.bytes == null) {
            byte[] bytes = new byte[this.maxDoc()];
            this.norms(field, bytes, 0);
            Norm.access$202(norm, bytes);
        }
        return norm.bytes;
    }

    public synchronized byte[] norms(String field) throws IOException {
        byte[] bytes = this.getNorms(field);
        if (bytes == null) {
            bytes = this.fakeNorms();
        }
        return bytes;
    }

    protected void doSetNorm(int doc, String field, byte value) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return;
        }
        norm.dirty = true;
        this.normsDirty = true;
        this.norms((String)field)[doc] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void norms(String field, byte[] bytes, int offset) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            System.arraycopy(this.fakeNorms(), 0, bytes, offset, this.maxDoc());
            return;
        }
        if (norm.bytes != null) {
            System.arraycopy(norm.bytes, 0, bytes, offset, this.maxDoc());
            return;
        }
        IndexInput normStream = (IndexInput)norm.in.clone();
        try {
            normStream.seek(norm.normSeek);
            normStream.readBytes(bytes, offset, this.maxDoc());
        }
        finally {
            normStream.close();
        }
    }

    private void openNorms(Directory cfsDir) throws IOException {
        long nextNormSeek = SegmentMerger.NORMS_HEADER.length;
        int maxDoc = this.maxDoc();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (!fi.isIndexed || fi.omitNorms) continue;
            Directory d = this.directory();
            String fileName = this.si.getNormFileName(fi.number);
            if (!this.si.hasSeparateNorms(fi.number)) {
                d = cfsDir;
            }
            long normSeek = fileName.endsWith(".nrm") ? nextNormSeek : 0L;
            this.norms.put(fi.name, new Norm(d.openInput(fileName), fi.number, normSeek));
            nextNormSeek += (long)maxDoc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNorms() throws IOException {
        Hashtable hashtable = this.norms;
        synchronized (hashtable) {
            Enumeration enumerator = this.norms.elements();
            while (enumerator.hasMoreElements()) {
                Norm norm = (Norm)enumerator.nextElement();
                norm.in.close();
            }
        }
    }

    private TermVectorsReader getTermVectorsReader() {
        TermVectorsReader tvReader = (TermVectorsReader)this.termVectorsLocal.get();
        if (tvReader == null) {
            tvReader = (TermVectorsReader)this.termVectorsReaderOrig.clone();
            this.termVectorsLocal.set(tvReader);
        }
        return tvReader;
    }

    public TermFreqVector getTermFreqVector(int docNumber, String field) throws IOException {
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null || !fi.storeTermVector || this.termVectorsReaderOrig == null) {
            return null;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber, field);
    }

    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        if (this.termVectorsReaderOrig == null) {
            return null;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber);
    }

    String getSegmentName() {
        return this.segment;
    }

    void setSegmentInfo(SegmentInfo info) {
        this.si = info;
    }

    void startCommit() {
        super.startCommit();
        this.rollbackDeletedDocsDirty = this.deletedDocsDirty;
        this.rollbackNormsDirty = this.normsDirty;
        this.rollbackUndeleteAll = this.undeleteAll;
        Enumeration values = this.norms.elements();
        while (values.hasMoreElements()) {
            Norm norm = (Norm)values.nextElement();
            norm.rollbackDirty = norm.dirty;
        }
    }

    void rollbackCommit() {
        super.rollbackCommit();
        this.deletedDocsDirty = this.rollbackDeletedDocsDirty;
        this.normsDirty = this.rollbackNormsDirty;
        this.undeleteAll = this.rollbackUndeleteAll;
        Enumeration values = this.norms.elements();
        while (values.hasMoreElements()) {
            Norm norm = (Norm)values.nextElement();
            norm.dirty = norm.rollbackDirty;
        }
    }

    static {
        try {
            String name = System.getProperty("org.apache.lucene.SegmentReader.class", SegmentReader.class.getName());
            IMPL = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load SegmentReader class: " + e, e);
        }
        catch (SecurityException se) {
            try {
                IMPL = Class.forName(SegmentReader.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load default SegmentReader class: " + e, e);
            }
        }
    }

    private class Norm {
        private IndexInput in;
        private byte[] bytes;
        private boolean dirty;
        private int number;
        private long normSeek;
        private boolean rollbackDirty;

        public Norm(IndexInput in, int number, long normSeek) {
            this.in = in;
            this.number = number;
            this.normSeek = normSeek;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reWrite(SegmentInfo si) throws IOException {
            String oldFileName = si.getNormFileName(this.number);
            if (oldFileName != null && !oldFileName.endsWith(".nrm")) {
                SegmentReader.this.deleter.addPendingFile(oldFileName);
            }
            si.advanceNormGen(this.number);
            IndexOutput out = SegmentReader.this.directory().createOutput(si.getNormFileName(this.number));
            try {
                out.writeBytes(this.bytes, SegmentReader.this.maxDoc());
            }
            finally {
                out.close();
            }
            this.dirty = false;
        }

        static /* synthetic */ byte[] access$202(Norm x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }
}

