# XCircuit startup script for Tcl/Tk version
# Does the work previously handled by "builtins.lps".  Commands
# "loadlibrary" and "loadfontencoding" should no longer be used.
# Update, version 3.3.34:  Commands "library override" and
# "font override" should not be used; set XCOps(fontoverride)
# and XCOps(liboverride) instead.
#
#  Written by Tim Edwards 12/19/00, 6/24/02 (tim@bach.ece.jhu.edu)
#  The Johns Hopkins University

global XCOps
if {[catch {set XCOps(fontoverride)}]} {

  xcircuit::loadfont times_roman.xfe
  xcircuit::loadfont times_romaniso.xfe
  xcircuit::loadfont helvetica.xfe
  xcircuit::loadfont helveticaiso.xfe
  xcircuit::loadfont courier.xfe
  xcircuit::loadfont courieriso.xfe
  xcircuit::loadfont symbol.xfe

# Alternate font encodings:  Uncomment these if you want them
# loaded by default
#
# xcircuit::loadfont times_romaniso2.xfe
# xcircuit::loadfont courieriso2.xfe
# xcircuit::loadfont helveticaiso2.xfe
# xcircuit::loadfont times_romaniso5.xfe
# xcircuit::loadfont courieriso5.xfe
# xcircuit::loadfont helveticaiso5.xfe
}

if {[catch {set XCOps(liboverride)}]} {

# First library page
  xcircuit::library 1 load generic.lps
  xcircuit::library 1 load analog.lps
  xcircuit::library 1 load avlsi.lps
  xcircuit::library 1 load digital.lps

# Second library page
  xcircuit::library 2 load analoglib2.lps

# Third library page
# xcircuit::library 3 load ic_templates.lps

# Fourth library page
# xcircuit::library 4 load quadparts.lps
}
