'\"
'\" Generated from file '/usr/obj/ports/tkcon-2.5/tkcon-2.5/docs/tkcon.n.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) Jeffrey Hobbs <jeff at hobbs.org>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "tkcon" n 2.5 tkcon.n "TkCon"
.BS
.SH NAME
tkcon \- Controlling TkCon console
.SH SYNOPSIS
\fBtkcon\fR \fIattach\fR \fIinterpreter\fR
.sp
\fBtkcon\fR \fIbuffer\fR ?\fIsize\fR?
.sp
\fBtkcon\fR \fIbgerror\fR ?\fImsg\fR \fIerrorInfo\fR?
.sp
\fBtkcon\fR \fIclose\fR or \fBtkcon\fR \fIdestroy\fR
.sp
\fBtkcon\fR \fIcongets\fR
.sp
\fBtkcon\fR \fIconsole\fR \fIargs\fR
.sp
\fBtkcon\fR \fIerror\fR
.sp
\fBtkcon\fR \fIfind\fR \fIstring\fR ?\fI-case\fR \fITCL_BOOLEAN\fR \fI-regexp\fR \fITCL_BOOLEAN\fR?
.sp
\fBtkcon\fR \fIfont\fR ?\fIfontname\fR?
.sp
\fBtkcon\fR \fIgets\fR
.sp
\fBtkcon\fR \fIgetcommand\fR
.sp
\fBtkcon\fR \fIhide\fR
.sp
\fBtkcon\fR \fIhistory\fR ?\fI-newline\fR?
.sp
\fBtkcon\fR \fIiconify\fR
.sp
\fBtkcon\fR \fIlinelength\fR ?\fIvalue\fR?
.sp
\fBtkcon\fR \fIload\fR \fIfilename\fR
.sp
\fBtkcon\fR \fImain\fR ?\fIarg\fR \fIarg\fR \fI...\fR?
.sp
\fBtkcon\fR \fImaster\fR \fIargs\fR
.sp
\fBtkcon\fR \fInew\fR
.sp
\fBtkcon\fR \fIresultfilter\fR ?\fIcommand\fR?
.sp
\fBtkcon\fR \fIsave\fR ?\fIfilename\fR ?\fItype\fR??
.sp
\fBtkcon\fR \fIset\fR \fIvar\fR ?\fIvalue\fR?
.sp
\fBtkcon\fR \fIappend\fR \fIvar\fR ?\fIvalue\fR?
.sp
\fBtkcon\fR \fIlappend\fR \fIvar\fR ?\fIvalue\fR?
.sp
\fBtkcon\fR \fIshow\fR or \fBtkcon\fR \fIdeiconify\fR
.sp
\fBtkcon\fR \fIslave\fR ?\fIslavename\fR ?\fIarg arg ...\fR??
.sp
\fBtkcon\fR \fItitle\fR ?\fItitle\fR?
.sp
\fBtkcon\fR \fIversion\fR
.sp
.BE
.SH DESCRIPTION
.PP
This provides lots of useful control over a console:
.TP
\fBtkcon\fR \fIattach\fR \fIinterpreter\fR
Attaches tkcon to the named interpreter.
The name must be that returned by [\fBtk\fR \fIappname\fR] or a valid
path to a slave interpreter.
It's best to use this via the \fIConsole->Attach Console\fR menu.
.TP
\fBtkcon\fR \fIbuffer\fR ?\fIsize\fR?
Sets or queries the allowed size of the console text widget in lines.
The text widget will automatically delete leading lines once this
number has been exceeded (read: this is the scroll buffer size).
.TP
\fBtkcon\fR \fIbgerror\fR ?\fImsg\fR \fIerrorInfo\fR?
Does bgerror stuff in the tkcon master interpreter.
.TP
\fBtkcon\fR \fIclose\fR or \fBtkcon\fR \fIdestroy\fR
Destroys this tkcon widget.
.TP
\fBtkcon\fR \fIcongets\fR
Behaves like the traditional Tcl gets, but instead of using stdin,
it uses the tkcon console window.
By default, tkcon replaces the standard gets with this command.
This behavior can be controlled by altering the \fB::tkcon::OPT(gets)\fR
parameter at startup.
This should not be called directly - instead rely on the overloaded
gets, which has support for the optional varName parameter.
.TP
\fBtkcon\fR \fIconsole\fR \fIargs\fR
Passes the args to the tkcon text widget (the console).
.TP
\fBtkcon\fR \fIerror\fR
Pops up a dialog that gives the user a full trace of the
last error received in the tkcon console.
.TP
\fBtkcon\fR \fIfind\fR \fIstring\fR ?\fI-case\fR \fITCL_BOOLEAN\fR \fI-regexp\fR \fITCL_BOOLEAN\fR?
Highlights all instances of string in the console.
If the string is empty, it clears any previous highlighting.
.TP
\fBtkcon\fR \fIfont\fR ?\fIfontname\fR?
Sets or returns the font used by tkcon text widgets.
.TP
\fBtkcon\fR \fIgets\fR
Behaves like the traditional Tcl gets, but instead of needing
stdin, it pops a dialog box up for the user.
The overloaded gets has support for the optional varName parameter.
.TP
\fBtkcon\fR \fIgetcommand\fR
A variation of the congets method that requires a full
command to be input before returning.
.TP
\fBtkcon\fR \fIhide\fR
Withdraw the tkcon display from the screen (make sure you
have a way to get it back).
.TP
\fBtkcon\fR \fIhistory\fR ?\fI-newline\fR?
Displays the tkcon history in sourceable form.
If \fI-newline\fR is specified, it separates each command by
an extra newline.
.TP
\fBtkcon\fR \fIiconify\fR
Iconifies the tkcon display.
.TP
\fBtkcon\fR \fIlinelength\fR ?\fIvalue\fR?
Sets or displays the number that specifies the limit of long result lines.
True result is still captured in $_ (and 'puts $_' works).
.TP
\fBtkcon\fR \fIload\fR \fIfilename\fR
Sources named file into the slave interpreter.
If no filename is given, it will attempt to call
\fBtk_getOpenFile\fR to pop up the file select box.
.TP
\fBtkcon\fR \fImain\fR ?\fIarg\fR \fIarg\fR \fI...\fR?
Passes the args to the main tkcon interpreter to be
evaluated and returns the result.
.TP
\fBtkcon\fR \fImaster\fR \fIargs\fR
Passes the args to the master interpreter to be evaluated
and returns the result.
.TP
\fBtkcon\fR \fInew\fR
Creates a new tkcon widget.
.TP
\fBtkcon\fR \fIresultfilter\fR ?\fIcommand\fR?
Specify a command to process the results before outputting it to the console
window.  The command receives one argument (the result string) and the string
returned is placed in the console.
.TP
\fBtkcon\fR \fIsave\fR ?\fIfilename\fR ?\fItype\fR??
Saves the console buffer to the given filename.
If no filename is given, it will attempt to call
\fBtk_getSaveFile\fR to pop up the file select box.
If no type is given, a dialog will ask you to specify
what portion of the text you want to save.
.TP
\fBtkcon\fR \fIset\fR \fIvar\fR ?\fIvalue\fR?
Queries or sets a master interpreter variable.
.TP
\fBtkcon\fR \fIappend\fR \fIvar\fR ?\fIvalue\fR?
Like set, but uses append on the variable.
.TP
\fBtkcon\fR \fIlappend\fR \fIvar\fR ?\fIvalue\fR?
Like set, but uses lappend on the variable.
.TP
\fBtkcon\fR \fIshow\fR or \fBtkcon\fR \fIdeiconify\fR
Redisplays tkcon on the screen.
.TP
\fBtkcon\fR \fIslave\fR ?\fIslavename\fR ?\fIarg arg ...\fR??
If called with no args, it returns the name of all the tkcon interpreters.
Otherwise given an interp name it passes the args to the named interpreter
to be evaluated and returns the result.
If no args are passed, then it returns the [\fBtk\fR \fIappname\fR] of that
interpreter.
.TP
\fBtkcon\fR \fItitle\fR ?\fItitle\fR?
Sets or returns the title for tkcon.
.TP
\fBtkcon\fR \fIversion\fR
Returns of version of tkcon.
.PP
.SH "SEE ALSO"
\fBdump\fR(n), \fBobserve\fR(n), \fBtkcon\fR(1), \fBtkcon\fR(n), \fBtkconrc\fR(5)
.SH KEYWORDS
Tk, console, debug
.SH COPYRIGHT
.nf
Copyright (c) Jeffrey Hobbs <jeff at hobbs.org>

.fi