/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jgraph.pad.resources.Translator;

public class SugiyamaLayoutConfigurationDialog
extends JDialog {
    private static final String CAPTION = "SugiyamaLayoutConfiguration";
    private boolean canceled;
    private JPanel jPanel1;
    private JTextField verticalSpacingTextField;
    private JPanel toolBar;
    private JTextField horizontalSpacingTextField;
    private JButton cancelButton;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JButton finishedButton;

    public SugiyamaLayoutConfigurationDialog(Frame frame) {
        super(frame, true);
        this.initComponents();
        this.setTitle(CAPTION);
        this.setName(CAPTION);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getWidth()) / 2;
        int n2 = (dimension.height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private void action_cancel() {
        this.setVisible(false);
        this.dispose();
        this.canceled = true;
    }

    private void action_ok() {
        try {
            Integer.parseInt(this.horizontalSpacingTextField.getText());
            Integer.parseInt(this.verticalSpacingTextField.getText());
        }
        catch (Exception exception) {
            String string = Translator.getString("Error.SpacingMustBeNumbers");
            JOptionPane.showMessageDialog(this, string, Translator.getString("Error"), 1);
            return;
        }
        this.setVisible(false);
        this.dispose();
        this.canceled = false;
    }

    public boolean canceled() {
        return this.canceled;
    }

    public String getIndention() {
        return this.horizontalSpacingTextField.getText().trim();
    }

    public String getVerticalSpacing() {
        return this.verticalSpacingTextField.getText().trim();
    }

    public void setIndention(String string) {
        this.horizontalSpacingTextField.setText(string);
    }

    public void setVerticalSpacing(String string) {
        this.verticalSpacingTextField.setText(string);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(new GridLayout(2, 2));
        this.toolBar = new JPanel(new FlowLayout(2));
        this.cancelButton = new JButton();
        this.finishedButton = new JButton();
        this.horizontalSpacingTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.verticalSpacingTextField = new JTextField();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SugiyamaLayoutConfigurationDialog.this.closeDialog(windowEvent);
            }
        });
        this.finishedButton.setText(Translator.getString("OK"));
        this.finishedButton.setName(Translator.getString("OK"));
        this.finishedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SugiyamaLayoutConfigurationDialog.this.finishedButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.finishedButton);
        this.getRootPane().setDefaultButton(this.finishedButton);
        this.cancelButton.setText(Translator.getString("Cancel"));
        this.cancelButton.setName(Translator.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SugiyamaLayoutConfigurationDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.cancelButton);
        this.getContentPane().add((Component)this.toolBar, "South");
        this.jLabel1.setText(Translator.getString("HorizontalSpacing"));
        this.jLabel1.setName("HorizontalSpacing");
        this.jPanel1.add(this.jLabel1);
        this.jPanel1.add(this.horizontalSpacingTextField);
        this.jLabel2.setText(Translator.getString("VerticalSpacing"));
        this.jLabel2.setName("VerticalSpacing");
        this.jPanel1.add(this.jLabel2);
        this.jPanel1.add(this.verticalSpacingTextField);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void finishedButtonActionPerformed(ActionEvent actionEvent) {
        this.action_ok();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.action_cancel();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.action_cancel();
    }

    public static void main(String[] stringArray) {
        new SugiyamaLayoutConfigurationDialog(new JFrame()).show();
    }
}

