/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux <klaux@student.uni-kl.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/


#ifndef _LABEL_H
#define _LABEL_H


#include "widget.h"
#include "font.h"

namespace uta {

///
class Label : public Widget
{
 //OBJECT

 public:
  ///
  enum align_t {ALIGN_LEFT, ALIGN_RIGHT, ALIGN_CENTER};
  ///
  Label(Widget* parent, int x, int y, int w, int h, const Font *font=0);
  ///
  virtual ~Label();  
  ///
  void setTextColor(const Color& fontCol, 
		    const Color& fadeCol = Font::defaultFadeColor);
  ///
  void setAlign(align_t align) { align_ = align; needsUpdate_ = true; };

  ///
  void setText(const char*);
  

 protected:
  
  ///
  virtual void create();
  ///
  std::string labelText_;
  ///
  const Font* labelFont_;
  ///
  std::vector<Color> fontPal_;
  ///
  align_t align_;
};



}

#endif // !_LABEL_H

