/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.MenuBarUI;

public class JMenuBar
extends JComponent
implements Accessible,
MenuElement {
    private static final long serialVersionUID = -8191026883931977036L;
    private transient SingleSelectionModel selectionModel = new DefaultSingleSelectionModel();
    private boolean borderPainted = true;
    private Insets margin;

    public JMenu add(JMenu jMenu) {
        jMenu.setAlignmentX(0.0f);
        super.add(jMenu);
        return jMenu;
    }

    public void addNotify() {
        super.addNotify();
        KeyboardManager.getManager().registerJMenuBar(this);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuBar();
        }
        return this.accessibleContext;
    }

    public Component getComponent() {
        return this;
    }

    public Component getComponentAtIndex(int n) {
        return this.getComponent(n);
    }

    public int getComponentIndex(Component component) {
        Component[] componentArray = this.getComponents();
        int n = -1;
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2].equals(component)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public JMenu getHelpMenu() {
        return null;
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public JMenu getMenu(int n) {
        if (this.getComponentAtIndex(n) instanceof JMenu) {
            return (JMenu)this.getComponentAtIndex(n);
        }
        return null;
    }

    public int getMenuCount() {
        return this.getComponentCount();
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public MenuElement[] getSubElements() {
        MenuElement[] menuElementArray = new MenuElement[this.getComponentCount()];
        int n = 0;
        while (n < this.getComponentCount()) {
            menuElementArray[n] = this.getMenu(n);
            ++n;
        }
        return menuElementArray;
    }

    public MenuBarUI getUI() {
        return (MenuBarUI)this.ui;
    }

    public String getUIClassID() {
        return "MenuBarUI";
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected();
    }

    public void menuSelectionChanged(boolean bl) {
    }

    protected void paintBorder(Graphics graphics) {
        Border border;
        if (this.borderPainted && (border = this.getBorder()) != null) {
            this.getBorder().paintBorder(this, graphics, 0, 0, this.getSize(null).width, this.getSize(null).height);
        }
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.paramString());
        stringBuffer.append(",margin=");
        if (this.getMargin() != null) {
            stringBuffer.append(this.getMargin());
        }
        stringBuffer.append(",paintBorder=").append(this.isBorderPainted());
        return stringBuffer.toString();
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (super.processKeyBinding(keyStroke, keyEvent, n, bl)) {
            return true;
        }
        MenuElement[] menuElementArray = this.getSubElements();
        int n2 = 0;
        while (n2 < menuElementArray.length) {
            if (JMenuBar.processKeyBindingHelper(menuElementArray[n2], keyStroke, keyEvent, n, bl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static boolean processKeyBindingHelper(MenuElement menuElement, KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (menuElement instanceof JComponent && ((JComponent)((Object)menuElement)).processKeyBinding(keyStroke, keyEvent, n, bl)) {
            return true;
        }
        MenuElement[] menuElementArray = menuElement.getSubElements();
        int n2 = 0;
        while (n2 < menuElementArray.length) {
            if (JMenuBar.processKeyBindingHelper(menuElementArray[n2], keyStroke, keyEvent, n, bl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void removeNotify() {
        KeyboardManager.getManager().unregisterJMenuBar(this);
        super.removeNotify();
    }

    public void setBorderPainted(boolean bl) {
        if (bl != this.borderPainted) {
            boolean bl2 = this.borderPainted;
            this.borderPainted = bl;
            this.firePropertyChange("borderPainted", bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    public void setHelpMenu(JMenu jMenu) {
        throw new Error("setHelpMenu() not yet implemented.");
    }

    public void setMargin(Insets insets) {
        if (insets != this.margin) {
            Insets insets2 = this.margin;
            this.margin = insets;
            this.firePropertyChange("margin", insets2, this.margin);
        }
    }

    public void setSelected(Component component) {
        int n = this.getComponentIndex(component);
        this.selectionModel.setSelectedIndex(n);
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        if (this.selectionModel != singleSelectionModel) {
            SingleSelectionModel singleSelectionModel2 = this.selectionModel;
            this.selectionModel = singleSelectionModel;
            this.firePropertyChange("model", singleSelectionModel2, this.selectionModel);
        }
    }

    public void setUI(MenuBarUI menuBarUI) {
        super.setUI(menuBarUI);
    }

    public void updateUI() {
        this.setUI((MenuBarUI)UIManager.getUI(this));
    }

    public JMenuBar() {
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJMenuBar
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        public int getAccessibleSelectionCount() {
            int n = 0;
            if (JMenuBar.this.getSelectionModel().getSelectedIndex() != -1) {
                n = 1;
            }
            return n;
        }

        public Accessible getAccessibleSelection(int n) {
            if (JMenuBar.this.getSelectionModel().getSelectedIndex() != n) {
                return null;
            }
            return JMenuBar.this.getMenu(n);
        }

        public boolean isAccessibleChildSelected(int n) {
            boolean bl = false;
            if (JMenuBar.this.getSelectionModel().getSelectedIndex() == n) {
                bl = true;
            }
            return bl;
        }

        public void addAccessibleSelection(int n) {
            JMenuBar.this.getSelectionModel().setSelectedIndex(n);
        }

        public void removeAccessibleSelection(int n) {
            if (JMenuBar.this.getSelectionModel().getSelectedIndex() == n) {
                JMenuBar.this.getSelectionModel().clearSelection();
            }
        }

        public void clearAccessibleSelection() {
            JMenuBar.this.getSelectionModel().clearSelection();
        }

        public void selectAllAccessibleSelection() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        protected AccessibleJMenuBar() {
        }
    }
}

