<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php
	/**
	 * Journal Module
	 */
	class JournalListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function JournalListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getMailProperties();
			
			$this->tablecolumns = array();
			$this->addColumn($this->tablecolumns, "importance", false, 0, _("Priority"), _("Sort On Priority"));
			$this->addColumn($this->tablecolumns, "icon_index", true, 1, _("Icon"), _("Sort On Icon"));
			$this->addColumn($this->tablecolumns, "hasattach", true, 2, _("Attachments"), _("Sort On Attachments"));
			$this->addColumn($this->tablecolumns, "subject", true, 4, _("Subject"), _("Sort On Subject"), PERCENTAGE);
			$this->addColumn($this->tablecolumns, "message_size", false, 6, _("Size"), _("Sort On Size"), 80);
			$this->addColumn($this->tablecolumns, "flag_status", false, 7, _("Flag Status"), _("Sort On Flag Status"));
			$this->addColumn($this->tablecolumns, "categories", false, 8, _("Categories"), _("Sort On Categories"));
			$this->addColumn($this->tablecolumns, "sent_representing_name", true, 3, _("From"), _("Sort On Sender"));
			$this->addColumn($this->tablecolumns, "message_delivery_time", true, 5, _("Received"), _("Sort On Received Date"));
			$this->addColumn($this->tablecolumns, "display_to", false, 3, _("To"), _("Sort On Recipient"));
			$this->addColumn($this->tablecolumns, "client_submit_time", false, 5, _("Sent"), _("Sort On Sent Date"));

			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));

			$this->sort = array();
			$this->sort[$this->properties["message_delivery_time"]] = TABLE_SORT_DESCEND;
			
			$this->start = 0;
		}
	}
?>
