'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.11.1/tcllib-1.11.1/modules/pop3d/pop3d_dbox.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "pop3d::dbox" n 1.0.2 pop3d "Tcl POP3 Server Package"
.BS
.SH NAME
pop3d::dbox \- Simple mailbox database for pop3d
.SH SYNOPSIS
package require \fBTcl  8.3\fR
.sp
package require \fBpop3d::dbox  ?1.0.2?\fR
.sp
\fB::pop3d::dbox::new\fR ?\fIdbName\fR?
.sp
\fBdbName\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fIdbName\fR \fBdestroy\fR
.sp
\fIdbName\fR \fBbase\fR \fIbase\fR
.sp
\fIdbName\fR \fBadd\fR \fImbox\fR
.sp
\fIdbName\fR \fBremove\fR \fImbox\fR
.sp
\fIdbName\fR \fBmove\fR \fIold new\fR
.sp
\fIdbName\fR \fBlist\fR
.sp
\fIdbName\fR \fBexists\fR \fImbox\fR
.sp
\fIdbName\fR \fBlocked\fR \fImbox\fR
.sp
\fIdbName\fR \fBlock\fR \fImbox\fR
.sp
\fIdbName\fR \fBunlock\fR \fImbox\fR
.sp
\fIdbName\fR \fBstat\fR \fImbox\fR
.sp
\fIdbName\fR \fBsize\fR \fImbox\fR ?\fImsgId\fR?
.sp
\fIdbName\fR \fBdele\fR \fImbox msgList\fR
.sp
\fIstorageCmd\fR \fBget\fR \fImbox\fR \fImsgId\fR
.sp
.BE
.SH DESCRIPTION
.PP
The package \fBpop3d::dbox\fR provides simple/basic mailbox
management facilities. Each mailbox object manages a single base
directory whose subdirectories represent the managed mailboxes. Mails
in a mailbox are represented by files in a mailbox directory, where
each of these files contains a single mail, both headers and body, in
RFC 822 (\fIhttp://www.rfc-editor.org/rfc/rfc822.txt\fR) conformant
format.
.PP
Any mailbox object following the interface described below can be used
in conjunction with the pop3 server core provided by the package
\fBpop3d\fR. It is especially possible to directly use the objects
created by this package in the storage callback of pop3 servers
following the same interface as servers created by the package
\fBpop3d\fR.
.PP
.TP
\fB::pop3d::dbox::new\fR ?\fIdbName\fR?
This command creates a new database object with an associated global
Tcl command whose name is \fIdbName\fR.
.PP
The command \fBdbName\fR may be used to invoke various operations on
the database.  It has the following general form:
.TP
\fBdbName\fR \fIoption\fR ?\fIarg arg ...\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.PP
.PP
The following commands are possible for database objects:
.TP
\fIdbName\fR \fBdestroy\fR
Destroys the mailbox database and all transient data. The directory
associated with the object is not destroyed.
.TP
\fIdbName\fR \fBbase\fR \fIbase\fR
Defines the base directory containing the mailboxes to manage. If this
method is not called none of the following methods will work.
.TP
\fIdbName\fR \fBadd\fR \fImbox\fR
Adds a mailbox of name \fImbox\fR to the database. The name must be a
valid path component.
.TP
\fIdbName\fR \fBremove\fR \fImbox\fR
Removes the mailbox specified through \fImbox\fR, and the mails
contained therein, from the database. This method will fail if the
specified mailbox is locked.
.TP
\fIdbName\fR \fBmove\fR \fIold new\fR
Changes the name of the mailbox \fIold\fR to \fInew\fR.
.TP
\fIdbName\fR \fBlist\fR
Returns a list containing the names of all mailboxes in the directory
associated with the database.
.TP
\fIdbName\fR \fBexists\fR \fImbox\fR
Returns true if the mailbox with name \fImbox\fR exists in the
database, or false if not.
.TP
\fIdbName\fR \fBlocked\fR \fImbox\fR
Checks if the mailbox specified through \fImbox\fR is currently locked.
.TP
\fIdbName\fR \fBlock\fR \fImbox\fR
This method locks the specified mailbox for use by a single connection
to the server. This is necessary to prevent havoc if several
connections to the same mailbox are open. The complementary method is
\fBunlock\fR. The command will return true if the lock could be set
successfully or false if not.
.TP
\fIdbName\fR \fBunlock\fR \fImbox\fR
This is the complementary method to \fBlock\fR, it revokes the lock
on the specified mailbox.
.TP
\fIdbName\fR \fBstat\fR \fImbox\fR
Determines the number of messages in the specified mailbox and returns
this number. This method fails if the mailbox \fImbox\fR is not
locked.
.TP
\fIdbName\fR \fBsize\fR \fImbox\fR ?\fImsgId\fR?
Determines the size of the message specified through its id in
\fImsgId\fR, in bytes, and returns this number. The command will
return the size of the whole maildrop if no message id was specified.
If specified the \fImsgId\fR has to be in the range "1 ... [\fIdbName\fR \fBstat\fR]"
or this call will fail. If \fBstat\fR was not called before this
call, \fBsize\fR will assume that there are zero messages in the
mailbox.
.TP
\fIdbName\fR \fBdele\fR \fImbox msgList\fR
Deletes the messages whose numeric ids are contained in the
\fImsgList\fR from the mailbox specified via \fImbox\fR.
The \fImsgList\fR must not be empty or this call will fail.
The numeric ids in \fImsgList\fR have to be in the range "1 ...
[\fIdbName\fR \fBstat\fR]" or this
call will fail. If \fBstat\fR was not called
before this call, \fBdele\fR will assume
that there are zero messages in the mailbox.
.TP
\fIstorageCmd\fR \fBget\fR \fImbox\fR \fImsgId\fR
Returns a handle for the specified message. This handle is a mime
token following the interface described in the documentation of
package \fBmime\fR. The token is \fIread-only\fR. In other
words, the caller is allowed to do anything with the token except to
modify it.
The \fImsgId\fR has to be in the range "1 ...
[\fIdbName\fR \fBstat\fR]" or this
call will fail. If \fBstat\fR was not called
before this call, \fBget\fR will assume
that there are zero messages in the mailbox.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIpop3d\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
internet, network, pop3, protocol, rfc 822
.SH COPYRIGHT
.nf
Copyright (c) 2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi