'\" Color=Green
'\" 
'\" Derived from a document with following copyright
'\"
'\" Copyright (c) 1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) messageBox.n 1.5 96/09/19 17:02:40
'\" 
.so STk-man.macros
.TH Tk:message-box n 4.2 STk "STk procedure"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tk:message-box \- pops up a message window and waits for user response.
.SH SYNOPSIS
\fB(Tk:message-box \fR?\fIoption value ...\fR?)
.BE

.SH DESCRIPTION
.PP
This procedure creates and displays a message window with an
application-specified message, an icon and a set of buttons.  Each of
the buttons in the message window is identified by a unique symbolic
name (see the \fB:type\fR options).  After the message window is
popped up, \fBTk:message-box\fR waits for the user to select one of the
buttons. Then it returns the symbolic name of the selected button.

The following option-value pairs are supported:
.TP
\fB:default\fR \fIname\fR
\fIName\fR gives the symbolic name of the default button for
this message window ('ok', 'cancel', and so on). See \fB:type\fR 
for a list of the symbolic names.  If the message box has just one
button it will automatically be made the default, otherwise if this
option is not specified, there won't be any default button.
.TP
\fB:icon\fR \fIiconImage\fR
Specifies an icon to display. \fIIconImage\fR must be one of the
following: \fBerror\fR, \fBinfo\fR, \fBquestion\fR or
\fBwarning\fR. If this option is not specified, then no icon will be
displayed.
.TP
\fB:message\fR \fIstring\fR
Specifies the message to display in this message box.
\fB:title\fR \fItitleString\fR
Specifies a string to display as the title of the message box. The
default value is an empty string.
.TP
\fB:type\fR \fIpredefinedType\fR
Arranges for a predefined set of buttons to be displayed. The
following values are possible for \fIpredefinedType\fR:
.RS
.TP 18
\fBAbortRetryIgnore\fR
Displays three buttons whose symbolic names are \fBabort\fR,
\fBretry\fR and \fBignore\fR.
.TP 18
\fBOk\fR
Displays one button whose symbolic name is \fBok\fR.
.TP 18
\fBOkCancel\fR
Displays two buttons whose symbolic names are \fBok\fR and \fBcancel\fR.
.TP 18
\fBRetryCancel\fR
Displays two buttons whose symbolic names are \fBretry\fR and \fBcancel\fR.
.TP 18
\fBYesNo\fR
Displays two buttons whose symbolic names are \fByes\fR and \fBno\fR.
.TP 18
\fBYesNoCancel\fR
Displays three buttons whose symbolic names are \fByes\fR, \fBno\fR
and \fBcancel\fR.
.RE
.PP
.SH EXAMPLE
.CS
(let ((answer (Tk:message-box :message "Really quit?" 
                              :type 'YesNo 
                              :icon 'question)))
  (case answer
    ((yes) (exit))
    (else  (Tk:message-box :message "I know you like this application!"
                           :type 'Ok))))
.CE
.SH SEE ALSO
make-dialog

