# Rules file for Codd's cellular automaton
#
# More on this automaton may be found in:
#
# Codd, E.F., _Cellular_Automata_, Academic Press 1968 (ACM Monograph #3).
states 8

# Almost all configurations with neighborhoods in [0-3] are stable
passive 3

# These are the exceptions (Codd's `short table', page 66)
012121		# Path self-repair
300022		# Path self-repair
301022		# Gate control
301030		# Gate control
212323		# Gate control
312322		# Gate control
002131		# Path end self-repair
012326		# Echo generation
012227		# Echo generation

# The long table
0000[45]0	# k = cell k change-of-state
000140		# e = erase
000350		# i = inject signal 06
000410		# e
000520		# i
001040		# e
001050		# i
001420		# e
002410		# e
002730		# j = inject signal 07
003070		# j
0037[23]0	# j
002721		# j
003631		# i
0112[4567]1	# fi = fan-in
011[456]21	# fi
0121[4567]1	# fi
0122[4567]1	# p = signal propagation
012351		# p
012421		# p
012441		# fo = fan-out
0125[23]1	# fi
012551		# fo
012621		# p
012661		# fo
0127[23]1	# p
012771		# fo
013241		# p
013[4567]21	# pg - propagation at gate (subordibate path)
013731		# t7 = transforming to 07
014221		# p
014241		# fo
014321		# p
014421		# fo
0152[23]1	# p
015251		# fo
015321		# p
015521		# fo
016221		# p
016261		# fo
016621		# fo
017221		# p
017271		# fo
017721		# fo
000[01]62	# k
000252		# xl = extend left
000262		# sh = sheathing
000422		# xr = extend right
000612		# k
000622		# sh
000662		# sh
001062		# sh
001162		# k
001262		# sh
001612		# k
001622		# sh
001662		# sh
001062		# sh
001162		# k
001262		# sh
001612		# k
001622		# sh
001662		# sh
002062		# g = gate control
002262		# sh
0026[12]2	# sh
006112		# k
006212		# sh
006222		# sh
006262		# sh
006612		# sh
011162		# k
011662		# sh
022262		# sh
022662		# sh
000073		# k
000153		# i
000513		# i
001073		# e
002073		# g
100040		# e
100140		# e
100410		# e
101040		# e
101140		# e
101410		# e
104110		# e
111140		# e
113[4567]21	# g
100362		# i
100632		# i
10107[23]	# s = sense
100073		# s
100244		# xr
10[23]4[23]4	# pe = path end
111244		# fo
11[12]424	# fo,p
112[12]44	# fo,p
112434		# pg
112774		# fi
114224		# p
117274		# fi
117724		# fi
12[23]244	# pe
12[23]434	# pe
122444		# c = collision
123244		# pe
1[23]3344	# pe
124224		# c
124334		# pe
100525		# xl
101055		# i
10[23]5[23]5	# pe
111255		# fo
11[12]525	# fo,p
112[12]55	# fo,p
112445		# fi
112535		# pg
114245		# fi
114425		# fi
115225		# p
122[23]55	# pe
122535		# pe
122555		# c
123[23]55	# pe
123535		# pe
125255		# c
125335		# pe
133355		# pe
100[012]66	# sh
1006[126]6	# sh
101[012]66	# sh
1016[126]6	# sh
102266		# pe
102616		# sh
10[23]6[23]6	# pe
106066		# sh
1061[16]6	# sh
1062[12]6	# sh,pe
106266		# c
106066		# sh
1061[16]6	# sh
1062[126]6	# sh,sh,c
106616		# sh
111156		# i
111266		# fo
111626		# fo
112166		# fo
112266		# p
112556		# fi
112626		# p
112636		# pg
112666		# fi
115256		# fi
115526		# fi
116226		# p
116266		# fi
116626		# fi
122[23]66	# pe
122636		# pe
122666		# c
123[23]66	# pe
123636		# pe
126266		# c
126336		# pe
133366		# pe
1027[23]7	# pe
1037[23]7	# pe
111277		# fo
111727		# fo
112[12]77	# fo,p
1127[23]7	# p,pg
113[456]37	# t7
113737		# t7
117227		# p
122[23]77	# pe
122737		# pe
122777		# c
123[23]77	# pe
123737		# pe
127277		# c
127337		# pe
133377		# pe
20[012]060	# k,k,g
200[01]71	# s,x
200711		# x = extend
201071		# s
201171		# x
201711		# x
207111		# x
211171		# x
2000[45]2	# ss = stability of sheath
2001[456]2	# ss
2002[467]2	# ss
2003[4567]2	# ss
200[45]12	# ss
2005[23]2	# ss
2006[123]2	# ss
2007[23]2	# ss
2010[45]2	# ss
2011[456]2	# ss
201[45]12	# ss
2015[23]2	# ss
2016[12]2	# ss
201722		# ss
202[12][4567]2	# ss
2024[123]2	# ss
202522		# ss
202532		# ss
202612		# ss
202622		# ss
202632		# ss
2027[123]2	# ss
2034[23]2	# ss
2035[23]2	# ss
203[67]22	# ss
2041[12]2	# ss
204222		# ss
205112		# ss
205122		# ss
2061[12]2	# ss
206162		# ss
206262		# ss
207[127]22	# ss
207722		# ss
2111[456]2	# ss
2112[4567]2	# ss
211[456]22	# ss
211662		# ss
211722		# ss
211772		# ss
212[12][4567]2	# ss
2123[4567]2	# ss
212[4567]22	# ss
2122[4567]2	# ss
2123[4567]2	# ss
212[4567]22	# ss
2132[67]2	# ss
214222		# ss
214422		# ss
215222		# ss
215232		# ss
215322		# ss
215522		# ss
216222		# ss
216232		# ss
216262		# ss
216322		# ss
2172[23]2	# ss
217722		# ss
2222[4567]2	# ss
222442		# ss
222552		# ss
222662		# ss
222772		# ss
200253		# qm = cell q change of state
200423		# pm = cell p change of state
202073		# g
202513		# qm
2030[67]3	# g
3002[67]0	# r,m
300620		# r
300720		# m
301620		# pm
301720		# m
302610		# qm
302710		# m
300061		# s
300251		# qm
300421		# pm
3232[4567]2	# g
3000[45]3	# k
300523		# ns
3010[45]3	# e
301523		# ns
302[4567]23	# ns
3222[4567]3	# ns
301064		# e
301077		# j
400010		# e
400120		# fi
400210		# fi
401020		# fi
401120		# fo
401210		# fo
401220		# p
402110		# fo
402120		# p
402210		# p
403120		# pg
400021		# xr
400221		# c
402021		# pe
402221		# pe
402231		# pe
402321		# pe
402331		# pe
403221		# pe
403231		# pe
403321		# pe
403331		# pe
500010		# i
500120		# fi
500210		# fi
501020		# fi
501120		# fo
501210		# fo
501220		# p
502110		# fo
502120		# p
502210		# p
503120		# pg
500021		# xl
500221		# c
502[023][23]1	# pe
600010		# sh
600110		# sh
600120		# fi
600210		# fi
601010		# sh
601020		# fi
601110		# i
601120		# fo
601210		# fo
601220		# p
602110		# fo
602120		# p
602210		# p
602230		# pe
602320		# pe
602330		# pe
603120		# pg
603220		# pe
603230		# pe
603320		# pe
603330		# pe
612320		# s
600001		# sh
600021		# sh
600221		# c
602021		# pe
602221		# sh
700010		# j
701120		# fo
701210		# fo
701220		# p
702110		# fo
702120		# p
702210		# p
702230		# pe
702320		# pe
702330		# pe
703120		# pg
703130		# pe
703220		# pe
703230		# pe
703320		# pe
703330		# pe
712220		# s
700021		# pe
700221		# c
702021		# pe
702221		# x
# End of ruleset
