/*
 * Decompiled with CFR 0.152.
 */
package sun.util;

import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import sun.util.resources.LocaleData;

public class BuddhistCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -8527488697350388578L;
    private static final int buddhistOffset = 543;
    private transient int yearOffset = 543;

    public BuddhistCalendar() {
    }

    public BuddhistCalendar(TimeZone timeZone) {
        super(timeZone);
    }

    public BuddhistCalendar(Locale locale) {
        super(locale);
    }

    public BuddhistCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof BuddhistCalendar && super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ 0x21F;
    }

    @Override
    public int get(int n) {
        if (n == 1) {
            return super.get(n) + this.yearOffset;
        }
        return super.get(n);
    }

    @Override
    public void set(int n, int n2) {
        if (n == 1) {
            super.set(n, n2 - this.yearOffset);
        } else {
            super.set(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int n, int n2) {
        int n3 = this.yearOffset;
        this.yearOffset = 0;
        try {
            super.add(n, n2);
        }
        finally {
            this.yearOffset = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void roll(int n, int n2) {
        int n3 = this.yearOffset;
        this.yearOffset = 0;
        try {
            super.roll(n, n2);
        }
        finally {
            this.yearOffset = n3;
        }
    }

    @Override
    public String getDisplayName(int n, int n2, Locale locale) {
        if (n != 0) {
            return super.getDisplayName(n, n2, locale);
        }
        if (n < 0 || n >= this.fields.length || n2 < 1 || n2 > 2) {
            throw new IllegalArgumentException();
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        ResourceBundle resourceBundle = LocaleData.getDateFormatData(locale);
        String[] stringArray = resourceBundle.getStringArray(this.getKey(n2));
        return stringArray[this.get(n)];
    }

    @Override
    public Map<String, Integer> getDisplayNames(int n, int n2, Locale locale) {
        if (n != 0) {
            return super.getDisplayNames(n, n2, locale);
        }
        if (n < 0 || n >= this.fields.length || n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException();
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        if (n2 == 0) {
            Map<String, Integer> map = this.getDisplayNamesImpl(n, 1, locale);
            Map<String, Integer> map2 = this.getDisplayNamesImpl(n, 2, locale);
            if (map == null) {
                return map2;
            }
            if (map2 != null) {
                map.putAll(map2);
            }
            return map;
        }
        return this.getDisplayNamesImpl(n, n2, locale);
    }

    private Map<String, Integer> getDisplayNamesImpl(int n, int n2, Locale locale) {
        ResourceBundle resourceBundle = LocaleData.getDateFormatData(locale);
        String[] stringArray = resourceBundle.getStringArray(this.getKey(n2));
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(4);
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], i);
        }
        return hashMap;
    }

    private String getKey(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BuddhistCalendar.class.getName());
        if (n == 1) {
            stringBuilder.append(".short");
        }
        stringBuilder.append(".Eras");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActualMaximum(int n) {
        int n2 = this.yearOffset;
        this.yearOffset = 0;
        try {
            int n3 = super.getActualMaximum(n);
            return n3;
        }
        finally {
            this.yearOffset = n2;
        }
    }

    @Override
    public String toString() {
        String string = super.toString();
        if (!this.isSet(1)) {
            return string;
        }
        int n = string.indexOf("YEAR=");
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n += "YEAR=".length()));
        while (Character.isDigit(string.charAt(n++))) {
        }
        int n2 = this.internalGet(1) + 543;
        stringBuilder.append(n2).append(string.substring(n - 1));
        return stringBuilder.toString();
    }
}

