/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class RFC822Name
implements GeneralNameInterface {
    private String name;

    public RFC822Name(DerValue derValue) throws IOException {
        this.name = derValue.getIA5String();
        this.parseName(this.name);
    }

    public RFC822Name(String string) throws IOException {
        this.parseName(string);
        this.name = string;
    }

    public void parseName(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("RFC822Name may not be null or empty");
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        if (string2.length() == 0) {
            throw new IOException("RFC822Name may not end with @");
        }
        if (string2.startsWith(".") && string2.length() == 1) {
            throw new IOException("RFC822Name domain may not be just .");
        }
    }

    @Override
    public int getType() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putIA5String(this.name);
    }

    public String toString() {
        return "RFC822Name: " + this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RFC822Name)) {
            return false;
        }
        RFC822Name rFC822Name = (RFC822Name)object;
        return this.name.equalsIgnoreCase(rFC822Name.name);
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        int n2;
        String string;
        String string2;
        int n3 = generalNameInterface == null ? -1 : (generalNameInterface.getType() != 1 ? -1 : ((string2 = ((RFC822Name)generalNameInterface).getName().toLowerCase()).equals(string = this.name.toLowerCase()) ? 0 : (string.endsWith(string2) ? (string2.indexOf(64) != -1 ? 3 : (string2.startsWith(".") ? 2 : (string.charAt((n2 = string.lastIndexOf(string2)) - 1) == '@' ? 2 : 3))) : (string2.endsWith(string) ? (string.indexOf(64) != -1 ? 3 : (string.startsWith(".") ? 1 : (string2.charAt((n = string2.lastIndexOf(string)) - 1) == '@' ? 1 : 3))) : 3))));
        return n3;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        String string = this.name;
        int n = 1;
        int n2 = string.lastIndexOf(64);
        if (n2 >= 0) {
            ++n;
            string = string.substring(n2 + 1);
        }
        while (string.lastIndexOf(46) >= 0) {
            string = string.substring(0, string.lastIndexOf(46));
            ++n;
        }
        return n;
    }
}

